// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// This container contains information about an contract.
type AssetContract struct {

	// The container for the contract identifier containing its blockchain network and
	// address.
	//
	// This member is required.
	ContractIdentifier *ContractIdentifier

	// The address of the contract deployer.
	//
	// This member is required.
	DeployerAddress *string

	// The token standard of the contract.
	//
	// This member is required.
	TokenStandard QueryTokenStandard

	noSmithyDocumentSerde
}

// Error generated from a failed BatchGetTokenBalance request.
type BatchGetTokenBalanceErrorItem struct {

	// The error code associated with the error.
	//
	// This member is required.
	ErrorCode *string

	// The message associated with the error.
	//
	// This member is required.
	ErrorMessage *string

	// The type of error.
	//
	// This member is required.
	ErrorType ErrorType

	// The container for time.
	AtBlockchainInstant *BlockchainInstant

	// The container for the identifier of the owner.
	OwnerIdentifier *OwnerIdentifier

	// The container for the identifier for the token including the unique token ID
	// and its blockchain network. Only the native tokens BTC,ETH, and the ERC-20,
	// ERC-721, and ERC 1155 token standards are supported.
	TokenIdentifier *TokenIdentifier

	noSmithyDocumentSerde
}

// The container for the input for getting a token balance.
type BatchGetTokenBalanceInputItem struct {

	// The container for the identifier of the owner.
	//
	// This member is required.
	OwnerIdentifier *OwnerIdentifier

	// The container for the identifier for the token including the unique token ID
	// and its blockchain network. Only the native tokens BTC,ETH, and the ERC-20,
	// ERC-721, and ERC 1155 token standards are supported.
	//
	// This member is required.
	TokenIdentifier *TokenIdentifier

	// The container for time.
	AtBlockchainInstant *BlockchainInstant

	noSmithyDocumentSerde
}

// The container for the properties of a token balance output.
type BatchGetTokenBalanceOutputItem struct {

	// The container for time.
	//
	// This member is required.
	AtBlockchainInstant *BlockchainInstant

	// The container for the token balance.
	//
	// This member is required.
	Balance *string

	// The container for time.
	LastUpdatedTime *BlockchainInstant

	// The container for the identifier of the owner.
	OwnerIdentifier *OwnerIdentifier

	// The container for the identifier for the token including the unique token ID
	// and its blockchain network. Only the native tokens BTC,ETH, and the ERC-20,
	// ERC-721, and ERC 1155 token standards are supported.
	TokenIdentifier *TokenIdentifier

	noSmithyDocumentSerde
}

// The container for time.
type BlockchainInstant struct {

	// The container of the Timestamp of the blockchain instant. This timestamp will
	// only be recorded up to the second.
	Time *time.Time

	noSmithyDocumentSerde
}

// The contract or wallet address by which to filter the request.
type ContractFilter struct {

	// The network address of the deployer.
	//
	// This member is required.
	DeployerAddress *string

	// The blockchain network of the contract.
	//
	// This member is required.
	Network QueryNetwork

	// The container for the token standard.
	//
	// This member is required.
	TokenStandard QueryTokenStandard

	noSmithyDocumentSerde
}

// Container for the blockchain address and network information about a contract.
type ContractIdentifier struct {

	// Container for the blockchain address about a contract.
	//
	// This member is required.
	ContractAddress *string

	// The blockchain network of the contract.
	//
	// This member is required.
	Network QueryNetwork

	noSmithyDocumentSerde
}

// The metadata of the contract.
type ContractMetadata struct {

	// The decimals used by the token contract.
	Decimals *int32

	// The name of the token contract.
	Name *string

	// The symbol of the token contract.
	Symbol *string

	noSmithyDocumentSerde
}

// The container for determining how the list transaction result will be sorted.
type ListTransactionsSort struct {

	// Defaults to the value TRANSACTION_TIMESTAMP .
	SortBy ListTransactionsSortBy

	// The container for the sort order for ListTransactions . The SortOrder field
	// only accepts the values ASCENDING and DESCENDING . Not providing SortOrder will
	// default to ASCENDING .
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// The container for the owner information to filter by.
type OwnerFilter struct {

	// The contract or wallet address.
	//
	// This member is required.
	Address *string

	noSmithyDocumentSerde
}

// The container for the identifier of the owner.
type OwnerIdentifier struct {

	// The contract or wallet address for the owner.
	//
	// This member is required.
	Address *string

	noSmithyDocumentSerde
}

// The balance of the token.
type TokenBalance struct {

	// The time for when the TokenBalance is requested or the current time if a time
	// is not provided in the request. This time will only be recorded up to the
	// second.
	//
	// This member is required.
	AtBlockchainInstant *BlockchainInstant

	// The container of the token balance.
	//
	// This member is required.
	Balance *string

	// The Timestamp of the last transaction at which the balance for the token in the
	// wallet was updated.
	LastUpdatedTime *BlockchainInstant

	// The container for the identifier of the owner.
	OwnerIdentifier *OwnerIdentifier

	// The identifier for the token, including the unique token ID and its blockchain
	// network.
	TokenIdentifier *TokenIdentifier

	noSmithyDocumentSerde
}

// The container of the token filter like the contract address on a given
// blockchain network or a unique token identifier on a given blockchain network.
// You must always specify the network property of this container when using this
// operation.
type TokenFilter struct {

	// The blockchain network of the token.
	//
	// This member is required.
	Network QueryNetwork

	// This is the address of the contract.
	ContractAddress *string

	// The unique identifier of the token.
	TokenId *string

	noSmithyDocumentSerde
}

// The container for the identifier for the token including the unique token ID
// and its blockchain network. Only the native tokens BTC,ETH, and the ERC-20,
// ERC-721, and ERC 1155 token standards are supported.
type TokenIdentifier struct {

	// The blockchain network of the token.
	//
	// This member is required.
	Network QueryNetwork

	// This is the token's contract address.
	ContractAddress *string

	// The unique identifier of the token. You must specify this container with btc
	// for the native BTC token, and eth for the native ETH token. For all other token
	// types you must specify the tokenId in the 64 character hexadecimal tokenid
	// format.
	TokenId *string

	noSmithyDocumentSerde
}

// There are two possible types of transactions used for this data type:
//   - A Bitcoin transaction is a movement of BTC from one address to another.
//   - An Ethereum transaction refers to an action initiated by an externally
//     owned account, which is an account managed by a human, not a contract. For
//     example, if Bob sends Alice 1 ETH, Bob's account must be debited and Alice's
//     must be credited. This state-changing action occurs within a transaction.
type Transaction struct {

	// The blockchain network where the transaction occurred.
	//
	// This member is required.
	Network QueryNetwork

	// The number of transactions in the block.
	//
	// This member is required.
	NumberOfTransactions *int64

	// The identifier of the transaction. It is generated whenever a transaction is
	// verified and added to the blockchain.
	//
	// This member is required.
	To *string

	// The hash of the transaction. It is generated whenever a transaction is verified
	// and added to the blockchain.
	//
	// This member is required.
	TransactionHash *string

	// The index of the transaction within a blockchain.
	//
	// This member is required.
	TransactionIndex *int64

	// The Timestamp of the transaction.
	//
	// This member is required.
	TransactionTimestamp *time.Time

	// The block hash is a unique identifier for a block. It is a fixed-size string
	// that is calculated by using the information in the block. The block hash is used
	// to verify the integrity of the data in the block.
	BlockHash *string

	// The block number in which the transaction is recorded.
	BlockNumber *string

	// Specifies whether the transaction has reached Finality.
	ConfirmationStatus ConfirmationStatus

	// The blockchain address for the contract.
	ContractAddress *string

	// The amount of gas used up to the specified point in the block.
	CumulativeGasUsed *string

	// The effective gas price.
	EffectiveGasPrice *string

	// Identifies whether the transaction has succeeded or failed.
	ExecutionStatus ExecutionStatus

	// The initiator of the transaction. It is either in the form a public key or a
	// contract address.
	From *string

	// The amount of gas used for the transaction.
	GasUsed *string

	// The signature of the transaction. The X coordinate of a point R.
	SignatureR *string

	// The signature of the transaction. The Y coordinate of a point S.
	SignatureS *string

	// The signature of the transaction. The Z coordinate of a point V.
	SignatureV *int32

	// The status of the transaction. This property is deprecated. You must use the
	// confirmationStatus and the executionStatus properties to determine if the status
	// of the transaction is FINAL or FAILED .
	//   - Transactions with a status of FINAL will now have the confirmationStatus set
	//   to FINAL and the executionStatus set to SUCCEEDED .
	//   - Transactions with a status of FAILED will now have the confirmationStatus
	//   set to FINAL and the executionStatus set to FAILED .
	//
	// Deprecated: The status field in the GetTransaction response is deprecated and
	// is replaced with the confirmationStatus and executionStatus fields.
	Status QueryTransactionStatus

	// The transaction fee.
	TransactionFee *string

	// The unique identifier of the transaction. It is generated whenever a
	// transaction is verified and added to the blockchain.
	TransactionId *string

	noSmithyDocumentSerde
}

// The container for the properties of a transaction event.
type TransactionEvent struct {

	// The type of transaction event.
	//
	// This member is required.
	EventType QueryTransactionEventType

	// The blockchain network where the transaction occurred.
	//
	// This member is required.
	Network QueryNetwork

	// The hash of the transaction. It is generated whenever a transaction is verified
	// and added to the blockchain.
	//
	// This member is required.
	TransactionHash *string

	// The blockchain address. for the contract
	ContractAddress *string

	// The wallet address initiating the transaction. It can either be a public key or
	// a contract.
	From *string

	// The wallet address receiving the transaction. It can either be a public key or
	// a contract.
	To *string

	// The unique identifier for the token involved in the transaction.
	TokenId *string

	// The unique identifier of the transaction. It is generated whenever a
	// transaction is verified and added to the blockchain.
	TransactionId *string

	// The value that was transacted.
	Value *string

	// The position of the vout in the transaction output list.
	VoutIndex *int32

	noSmithyDocumentSerde
}

// The container of the transaction output.
type TransactionOutputItem struct {

	// The blockchain network where the transaction occurred.
	//
	// This member is required.
	Network QueryNetwork

	// The hash of the transaction. It is generated whenever a transaction is verified
	// and added to the blockchain.
	//
	// This member is required.
	TransactionHash *string

	// The time when the transaction occurred.
	//
	// This member is required.
	TransactionTimestamp *time.Time

	noSmithyDocumentSerde
}

// The resource passed is invalid.
type ValidationExceptionField struct {

	// The ValidationException message.
	//
	// This member is required.
	Message *string

	// The name of the field that triggered the ValidationException .
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
