// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sets the default encryption configuration for the Amazon Web Services account.
// For more information, see Key management (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html)
// in the IoT SiteWise User Guide.
func (c *Client) PutDefaultEncryptionConfiguration(ctx context.Context, params *PutDefaultEncryptionConfigurationInput, optFns ...func(*Options)) (*PutDefaultEncryptionConfigurationOutput, error) {
	if params == nil {
		params = &PutDefaultEncryptionConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutDefaultEncryptionConfiguration", params, optFns, c.addOperationPutDefaultEncryptionConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutDefaultEncryptionConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutDefaultEncryptionConfigurationInput struct {

	// The type of encryption used for the encryption configuration.
	//
	// This member is required.
	EncryptionType types.EncryptionType

	// The Key ID of the customer managed key used for KMS encryption. This is
	// required if you use KMS_BASED_ENCRYPTION .
	KmsKeyId *string

	noSmithyDocumentSerde
}

type PutDefaultEncryptionConfigurationOutput struct {

	// The status of the account configuration. This contains the ConfigurationState .
	// If there is an error, it also contains the ErrorDetails .
	//
	// This member is required.
	ConfigurationStatus *types.ConfigurationStatus

	// The type of encryption used for the encryption configuration.
	//
	// This member is required.
	EncryptionType types.EncryptionType

	// The Key ARN of the KMS key used for KMS encryption if you use
	// KMS_BASED_ENCRYPTION .
	KmsKeyArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutDefaultEncryptionConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutDefaultEncryptionConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutDefaultEncryptionConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutDefaultEncryptionConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opPutDefaultEncryptionConfigurationMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutDefaultEncryptionConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutDefaultEncryptionConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opPutDefaultEncryptionConfigurationMiddleware struct {
}

func (*endpointPrefix_opPutDefaultEncryptionConfigurationMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opPutDefaultEncryptionConfigurationMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opPutDefaultEncryptionConfigurationMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opPutDefaultEncryptionConfigurationMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opPutDefaultEncryptionConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutDefaultEncryptionConfiguration",
	}
}
