# Changelog

This changelog does not follow semantic versioning.

## 2.9.1 (04-Oct-2025)

### Fixed

- A double-free has been fixed that occered right after issue
  creation. In some cases this may have caused crashes of gcli.

  Submitted-by: Artyom Sinyugin <writers@altlinux.org>

## 2.9.0 (26-Aug-2025)

### Added

- A `-S` / `--assignee` option has been added to the issues subcommand.
  This flag allows you to search for issues that are assigned to
  the given user. See the `gcli-issues(1)` manual page for more
  details.

- An experimental `discussions` action was added to the pulls
  subcommand. It prints reviews and their comments in a threaded
  view. See the `gcli-pulls(1)` manual page for more details.

- The online version of the gcli tutorial is now compiled into a
  manual page `gcli-tutorial(1)` which is installed by default. It
  is included pre-generated in the release tarball but can be rebuilt
  by setting the newly added `--enable-maintainer` option of the
  configure script.

- Two actions `approve` and `unapprove` have been added to the
  `pulls` subcommand.  These allow giving approval or rejecting a
  pull request, offering to enter a commant about why a given PR
  was approved or rejected.  Because this reuses code from the
  reviews subsystem this currently only works on GitHub and Gitlab,
  however support for Gitea will be added in the next release.

### Fixed

- A bug in the autodetection of remotes and forge types from
  configured git remotes has been fixed.

  In cases where the git remote was pointing at an ssh-URL with a
  scheme but without a port the remote was not properly detected
  and lead to an incorrectly recognised owner/repo combination.

- A confusion about the automerge feature has been fixed causing
  pull requests with automerge to not work on Github forges. Note
  that this does not fix the general bug on Github which doesn't
  correctly report whether a pull request has been marked as
  auto-merge.

- Running the pulls checkout action as the last action used to
  result in an error 'not enough arguments'.

### Changed

- Compiler output file extensions are now guessed by the configure script

  This is done for Windows compatibility. People have reported that
  it is now possible again to build gcli on MSYS2.

  If the guessed extensions are wrong, one may override the guessed
  extensions using the environment variables  `EXEEXT`, `OBJEXT`,
  `LIBEXT`, `EXEEXT_FOR_BUILD`, `OBJEXT_FOR_BUILD` and `LIBEXT_FOR_BUILD`.

- When a pull/merge request or issue submission has failed, gcli
  will now store the entered message in `$PWD/gcli_message`. When
  the `pulls|issue create` subcommand is later re-run and this file
  is found, gcli will ask you whether you wish to recall its contents
  for the new message.

  Suggested-by: Bence Ferdinandy <bence@ferdinandy.com>

- The pdjson dependency is now unbundled by default. In case it
  is not found via pkg-config the vendored copy is used instead.

## 2.8.0 (25-May-2025)

### Added

- The pulls subcommand now supports assigning pull requests to
  users. A new assign action has been added.

- The releases create subcommand now has an option `-T`/`--template`.
  This option allows you to pass a path to a file that is used
  for the release notes. If combined with `--yes` the entire
  command is non-interactive allowing you to use it from scripts.
  If not combined with `--yes` an editor is opened with a copy of
  the passed file, allowing you to use it as a template for further
  editing.

  See the manual page `gcli-releases(1)` for details and usage
  examples.

  Suggested by: xaizek <https://github.com/xaizek>

### Fixed

- Parsing timestamps with timezone offsets now works properly.
  This was an issue on Gitea forges where sometimes timestamps with
  explicit timezone offsets were returned.

- Building on macOS has been fixed

  Darwin doesn't have a separate library for the POSIX real-time
  extensions. Trying to link with -lrt thus results in errors.

  The configure script now explicitly checks for a host platform
  apple-darwin and disables `-lrt` linkage in this case.

  Reported by: botantony <https://gitlab.com/botantony>

- Fixed a crash in jemalloc caused by a double-free in the patch action on Gitlab

  This only occured in the case where multiple patches are in a merge request.

- Fixed incorrect argument parsing in the pipelines subcommand
  leading to a nonsensical error message

- Fixed broken automerge feature when creating merge requests on
  Gitlab.


## 2.7.0 (04-Mar-2025)

### Added

- A `open` action has been added to various subcommand actions.
  This action allows you to open the item in a web browser.

  The URL to open is passed to the configured program in
  `url-open-program` in the global section. If this option
  is not set it defaults to `xdg-open` which uses your default
  browser.

  This feature currently works for Github, Gitlab and Bugzilla.
  I'm planning on implementing this for Gitea as well however some
  considerations have to be taken into account first.

  Requested by: Baptiste Daroussin <bapt@FreeBSD.org>

- The interactive status prompt now has a command `done` that allows
  you to mark a notification as done. When run on an action it will
  return you to the list of notifications.

- An `edit` action has been added to the issues subcommand.
  This action allows you to edit the original post / body / message
  of an issue, e.g. to update a TODO list checkmark.

- Comment submission has been implemented for Bugzilla.

### Fixed

- Fixed a printf formatting bug on 32-bit platforms in review tool.

  Submitted by: Artyom Sinyugin <writers@altlinux.org>

- Fixed Bugzilla support

  Bugzilla support was broken due to the path refactoring in 2.6.0.
  This caused the backend to not properly recognise the options
  passed to it. Compatibility has now been restored.

  Reported by: Baptiste Daroussin <bapt@FreeBSD.org>

- The interactive status command now properly handles comments and
  CI checks for GitHub PR notifications.

### Changed

- The status subcommand provides an interactive mode for going through
  notifications.
  This mode has been changed to reuse the actions of their respective
  subcommands. You can pass the same options as documented in the
  manual pages to the notification items.
  These features are available for issues and pull requests as of now.
  This means that if you select an issue notification you get a prompt
  for actions on the respective issue.

- The labels subcommand now uses the action-style argument parser
  to perform tasks on specific labels.
  With this change a few new actions have been added for changing
  the title, the colour or the description of a label.
  Refer to the manual page `gcli-labels(1)` for more information.

### Removed

## 2.6.1 (2025-Jan-19)

### Fixed

- Fix rendering bug caused by liblowdown 1.4 API breakage.

- Fixed missing documentation in `gcli-releases(1)`

  Reported by: xaizek <https://github.com/xaizek>

- Fix configure to fail when the compiler in `CC` does not exist

- Fix manual page compatibility with `groff_mdoc`

  Submitted by: remph <lhr@disroot.org>


## 2.6.0 (2025-Jan-04)

### Added

- Added a `checkout` action to the `pulls` subcommand that allows
  quickly checking out the target branch of a pull request.

- Added a `-R` command line option to the `pulls create` subcommand
  that allows specifying reviewers directly when creating the pull
  request.
  gcli now also asks for reviewers when creating a pull request
  interactively.
  See `gcli-pulls(1)`.

- Support for pull requests has been added to the interactive
  `status` subcommand.

### Fixed

- Fixed bad owner/repo when inferred repository information from
  a git remote with an ssh-url contained a port number

- gcli now handles nested projects on Gitlab correctly

- The documentation in `gcli(5)` mentioned the forge option
  `api-base` however it didn't work because of a typo in the
  responsible code. Parts of the other documentation however was
  using the incorrect option name without the option.  The config
  option and related documentation has been fixed to spell `api-base`.
  In order not to break existing configurations an alias has been
  added such that `apibase` is also a valid name, however `api-base`
  is preferred.

  Reported by: Jiří Štefka

- The previously added Markdown rendering functionality through
  liblowdown can now be disabled at runtime by providing a command
  line flag, setting an environment variable or by setting a
  configuration variable.

  Reported-by: Gavin-John Noonan <mail@gjnoonan.co.uk>

- The interactive status subcommand now doesn't crash anymore
  for release notifications on Github.

- Compatibility with the newly released liblowdown 1.4.0 has been
  restored. The new minor version broke the API causing compilation
  failures in gcli.

  Submitted by: Hoang Nguyen <https://github.com/folliehiyuki>

- Fix a segfault when no default account is declared in gcli config

  Submitted by: remph <lhr@disroot.org>

- Fix a segfault when listing repositories

  Submitted by: remph <lhr@disroot.org>

- Fix github API error 422 on `gcli forks create`

  This is caused by the distinction between users and organisations
  on Github.

  Submitted by: remph <lhr@disroot.org>

### Changed

- gcli now uses `time_t` internally to represent timestamps. This
  is visible to the user in that all timestamps are now printed
  in the consistent format `YYYY-mmm-dd HH:MM:SS` instead of the
  default format that each forge uses.

- When searching for a usable editor gcli now consults the following
  places in this order:

  - gcli config file
  - `$GIT_EDITOR`
  - `$VISUAL`
  - `$EDITOR`

  Submitted by: remph <lhr@disroot.org>

- gcli now uses a dedicated type for paths to objects on forges
  internally. This change is a quite intrusive in the code base and
  has been tested extensively over the past month in real scenarios.
  If you encounter bugs where things can't be found, command line
  option parsing seems to not work correctly anymore or stuff is
  submitted incorrectly otherwise please report a bug.

## 2.5.0 (2024-Aug-26)

### Added

- Added a `-R` flag to the comment subcommand that allows you to
  reply to a comment with the given ID.

### Fixed

- In various configuration places and environment variables where
  boolean values are accepted you can now specify `true` as a truthy
  value.

  Submitted by: Gavin-John Noonan <mail@gjnoonan.co.uk>

- The configure script now exits gracefully whenever a required
  program couldn't be found.

  Reported by: Alexey Ugnichev <alexey.ugnichev@gmail.com>

- A bug genereting invalid JSON when adding labels to a GitHub issue
  was fixed.

- The reviews cache directory is now automatically created if it
  doesn't exist avoiding a 'No such file or directory' error when
  invoking the review action for the first time.

  Reported by: Bence Ferdinandy <bence@ferdinandy.com>

- A few bugs in the patch parser have been fixed:

  - Under rare conditions hunk ranges were incorrectly parsed
  - Parser errors when a diff included lines starting with a backslash
    (e.g. when there is no newline at the end of file) were fixed

  Reported by: Bence Ferdinandy <bence@ferdinandy.com>

- The installation location of the manual pages of gcli has been
  fixed. The latest release accidentially installed manual pages to
  `${DESTDIR}${PREFIX}/share/man` instead of
  `${DESTDIR}${PREFIX}/share/man/manX`.

  Reported by: Bence Ferdinandy <bence@ferdinandy.com>

### Changed

- The pipelines subcommand has been refactored to accept actions
  for pipelines. This allows cases where a pipeline triggers child
  pipelines to be handled properly.

  See `gcli-pipelines(1)` for documentation.

  Reported by: Bence Ferdinandy <bence@ferdinandy.com>

### Removed

## 2.4.0 (2024-June-28)

### Added

- Added a convenience flag `-V` or `--version` that prints the
  version of gcli.

- Added an option to disable the spinner to indicate network activity

  You can now either set `disable-spinner=yes` in your default
  section in the config file, specify `--no-spinner` as a command
  line flag or set the environment variable `GCLI_NOSPINNER` to
  disable the spinner.  This is useful for dumb terminal environments
  like acme where the `\r` used by the spinner is not interpreted.
  Submitted by: Gavin-John Noonan

- Added an interactive status feature

  Running `gcli status` will now drop you into a prompt-based
  interactive TODO/notification menu. Currently this only supports
  issues however this will be extended in future releases.
  The old behaviour of `gcli status` showing a list of notifications
  can be achieved by supplying the `-l` or `--list` option.

  See also https://gitlab.com/herrhotzenplotz/gcli/-/issues/224

- Experimental support for code review has been added

  When enabling experimental features through either:

  - setting `GCLI_ENABLE_EXPERIMENTAL` in the environment to `yes`
  - setting `enable-experimental` in the default section of the
    gcli config file to yes

  you will get a action `review` on the pull request subcommand.

  This subcommand will pull down the diff of the given pull request
  and loads it into your editor. You can then annotate the diff,
  save and quit. gcli will then parse the diff, extract comments
  and allows you to submit them as a review.

  Please refer to the new `gcli-pulls-review(1)` manual page that
  has been added for this feature.

  Also note that this is experimental and may be buggy. However,
  testing is very much appreciated and I will gladly discuss ideas
  and usability issues.

  Please check in on IRC (#gcli on Libera.Chat) for these matters
  and/or post to our mailing list at
  https://lists.sr.ht/~herrhotzenplotz/gcli-discuss.

### Fixed

- Fixed resolving true .git directory when working inside a git
  worktree. This used to work before, however newer versions of git
  changed how these worktrees pointing to the true git directory.
  Reported by: Robert Clausecker

- Fixed bad error message extraction when API errors occured on
  GitLab. We now check for common error message fields in the
  returned payload from the GitLab API and choose the (probably)
  most useful one.

- Fixed segmentation fault when displaying certain pull requests
  on Gitea.

- Fixed some spelling mistakes in various manual pages

### Changed

- The GitLab API returns the list of comments in reverse chronological
  order. We now reverse this list to print the comments in the correct
  order such that a logical timeline of a conversation can be seen.

- The build system of gcli has been migrated away from Autotools.
  The GNU autotools have been complicating and slowing down the
  gcli builds by a huge amount. Using autotools prevented easy
  cross-compilation of gcli because it would have required the use
  of GNU make. Instead of autotools we now use a hand-written
  configure script and a hand-written Makefile that gets pre-processed
  by the configure script. You can still invoke the configure script
  as expected however some options aren't available anymore.

  Packagers are likely interested in the `--release` flag of the
  configure script. Most other compilation environment flags
  are controlled by environment variables. Please refer to
  `./configure --help` for more information. The `HACKING.md` file
  also includes valuable information including examples.

  Out-of-tree builds are still fully supported.

  If you encounter bugs / other difficulties due to these changes
  please report back!

## 2.3.0 (2024-Mar-25)

### Added

- It is now possible to build gcli against libgcli as a DLL on cygwin.
  Submitted by: Daisuke Fujimura

- The pulls subcommand now allows searching for pull requests with
  a given search term. The search terms can be appended to the
  regular pull subcommand for listing PRs:

  ```console
  $ gcli pulls -L bug segmentation fault
  ```

  The above will search for pull requests containing »segmentation
  fault« and the label »bug«.

- An interactive mode for creating both PRs and issues has been added.
  You can now interactively create pull requests and issues by omitting their title:

  ```console
  $ gcli issues create
  Owner [herrhotzenplotz]:
  Repository [gcli]:
  Title: foo
  The following issue will be created:

  TITLE   : foo
  OWNER   : herrhotzenplotz
  REPO    : gcli
  MESSAGE :
  No message

  Do you want to continue? [yN]
  ```

### Fixed

- gcli was incorrectly using an environment variable *XDG_CONFIG_DIR*.
  This variable has now been fixed to be *XDG_CONFIG_HOME*.
  Submitted by: Jakub Wilk

- Fixed a segmentation fault when listing forks

- Fixed error when submitting a comment on Gitlab issues

- The build on Haiku has been fixed. GCLI can now be compiled and
  used on this platform.

## 2.2.0 (2024-Feb-05)

### Added

- Preliminary (and thus experimental) support for Bugzilla has been
  added. For this a new yet undocumented `attachments` subcommand
  has been introduced.
  Currently if no account has been specified it will default to the
  FreeBSD Bugzilla - this may however change in the future.

- A search feature has been added to the issues subcommand. You can
  now optionally provide trailing text to the issues subcommand
  which will be used as a search term:

  ```console
  $ gcli issues -A herrhotzenplotz Segfault
  ```

  This will search for tickets authored by herrhotzenplotz containing
  "Segfault".

- Added partial support for auto-merge. When creating a pull request
  on Gitlab and Github you can set an automerge flag. Whenever this
  automerge flag is set a pull request will be merged once all the
  pipelines/checks on the pull request pass.

  This feature is not fully documented yet as there are bugs in it,
  especially on Gitlab there are flaws. Please consider this feature
  unstable and experimental.

### Fixed

- Fixed a segmentation fault when getting a 404 on Gitlab. This bug
  occured on Debian Linux when querying pipelines at the KiCad project.
  The returned 404 contained unparsable data which then lead to the
  error message to be improperly initialised.
  Reported by: Simon Richter

- Fixed missing URL-encode calls in Gitlab Pipelines causing 404 errors
  when using subprojects on Gitlab. You're now not forced anymore
  to manually urlencode slashes as %2F in the repos.
  Reported by: Simon Richter

- Fixed the patch generator for Gitlab Merge Requests to produce
  patches that can be applied with `git am`.
  Previously the patches were invalid when new files were created
  or deleted.

- Fixed Segmentation fault when the editor was opened and closed
  without changing the file. Several subcommands have been updated
  to also account for empty user messages.

- Fixed incorrect colour when creating labels. In any forge the
  provided colour code was converted incorrectly and always producing
  the wrong colour.

- Fixed a segmentation fault when listing Github gists

- Fixed possible JSON escape bug when creating a Github Gist

- Fixed gcli reporting incorrect libcurl version in the User-Agent
  header when performing HTTP requests.

- Fixed possible segmentation fault when no token was configured in
  gcli configuration file.

### Changed

- Internally a lot of code was using string views. Maintaining this
  was a bit cumbersome and required frequent reallocations.
  A lot of these uses have been refactored to use plain C-Strings
  now. This also involved changing some code to use the new
  `gcli_jsongen` set of routines.
  Due to these changes there may be regressions that are only visible
  during use. If you encounter such regressions where previously
  working commands suddenly fail due to malformed requests please
  report immediately.

### Removed

## 2.1.0 (2023-Dec-08)

### Added

- Added a little spinner to indicate network activity
- Added Windows 10 MSYS2 to list of confirmed-to-work platforms
- Added a new action `set-visibility` to the repos subcommand that
  allows updating the visibility level of a repository.
- Added a new action `request-review` to the pulls subcommand that
  allows requesting a review of a pull request from a given user.
- One can now define custom aliases in the alias section of the
  config file. Aliases are very primitive as of now. This means they
  are just different names for subcommands. Aliases may reference
  other aliases.
- Added a new `-M` flag to both the pulls and the issues subcommand
  to allow filtering by milestones.
- Added a new `patch` action to the pulls subcommand. This allows
  you to print the entire patch series for a given pull request.
  Also added the missing implementations for this feature for Github
  and Gitea.
- Added a new `title` action to both the issues and the pulls
  subcommand that allows updating their titles.

### Fixed

- Fixed incorrect internal help message of the `repos` subcommand.
- Worked around ICE with xlC 16 on ppc64le Debian Linux, gcli now
  compiles using xlC and works too.
- Fixed various memory leaks.
- Spelling fixes in manual pages (submitted by Jakub Wilk
  https://github.com/herrhotzenplotz/gcli/pull/121)
- Wired up alread existing implementation for forking on Gitea to
  gcli command.
- The `status` subcommand now works properly on Gitea.

### Changed

- Subcommands can now be abbreviated by providing an unambiguous
  prefix that matches the subcommand.

### Removed


## 2.0.0 (2023-Sep-21)

### Added

- This changelog has been added
- gcli is now built as a shared or static library which the gcli tool links against
  This implied so many changes that the major version number was bumped.
- Added a package-config file for libgcli
- Added a `-L` flag to the `issues` and `pulls` subcommand to allow
  filtering by label
- A work-in-progress tutorial has been added and is available at
  [the GCLI directory](https://herrhotzenplotz.de/gcli/tutorial) on
  my website.
- Gitlab jobs now show coverage information

### Fixed

- Parallel builds in autotools have been re-enabled
- Improved error messages in various places
- Bad roff syntax in manual pages has been fixed

### Changed

- the `gcli pulls create` subcommand does not print the URL to the
  created release anymore.
- The test suite is now using [atf-c](https://github.com/jmmv/atf)
  and [kyua](https://github.com/jmmv/kyua). These are dependencies
  if you want to run the tests. These tools are installed out of
  the box on most BSDs.
- A newly introduced dependency is the `sys/queue.h` header. On
  GNU/Linux systems you might need to install it as part of libbsd.

### Removed

- The reviews subcommand has been removed because it was generally useless
  This feature will be reimplemented as a WIP of
  [#189](https://gitlab.com/herrhotzenplotz/gcli/-/issues/189)
