#!/usr/bin/perl
use strict;
use warnings;
use AptPkg::Cache;

my $cache = AptPkg::Cache->new;
my $policy = $cache->policy;

foreach my $thumb (sort(<*.png>, <*.jpg>)) {
    (my $pkg = $thumb) =~ s/\..*?$//;

    my $p = $cache->{$pkg};
    unless ($p)
    {
        warn "Apt doesn't know about $pkg\n";
        next;
    }

    my $available = $p->{VersionList};
    unless ($available)
    {
        warn "Apt doesn't know any available version of $pkg\n";
        next;
    }

    my ($unstable, $testing);
    for my $v (@$available)
    {
        for my $f (map $_->{File}, @{$v->{FileList}})
        {
            if ($f->{Origin} and $f->{Origin} eq 'Debian' and $f->{Component} eq 'main')
            {
                $testing ||= $f->{Archive} eq 'testing';
                $unstable ||= $f->{Archive} eq 'unstable';
            }
        }
    }

    warn "$pkg is not in unstable\n" if not $unstable;
    warn "$pkg is not in testing\n" if not $testing;
}
