!{\src2tex{textfont=tt}}
!!****m* etsf_kpoints/etsf_io_kpoints_get
!! NAME
!!  etsf_io_kpoints_get
!!
!! FUNCTION
!!    Read an opened ETSF file to get data related to the given group.
!!    Only associated pointers of argument @folder will be accessed. If any accessed
!!    variable is missing, this routine returns an error (usually an access_mode_id
!!    of argument error_data set to ERROR_MODE_INQ). Any other errors implies a
!!    return with @lstat = .false..
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * use_atomic_units = (optional) 
!!     set this flag to .true. makes the library use the value of the attribute
!!     scale_to_atomic_units to multiply the read variables (that are units dependent)
!!     by this factor (if different from 1.0d0).
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!! SIDE EFFECTS
!! * folder <type(etsf_kpoints)> = 
!!     an allocated structure with pointers on allocated areas in memory.
!!     These areas will be read or written if the pointer is associated, if
!!     not, the variable will be ignored. It is possible to access to specific
!!     dimensions of a variable using the <short_var_name>__kpoint_access or
!!     <short_var_name>__spin_access of this @folder structure. The 
!!     <short_var_name>__number_of_<something> can also been set if only a subpart
!!     in one dimension should be accessed (this is possible when the specifications
!!     have been declared with a max_number_of_<something>.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_kpoints_get(ncid, folder, lstat, error_data, use_atomic_units)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_kpoints), intent(inout) :: folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  logical, optional, intent(in) :: use_atomic_units

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_kpoints_get'
  logical :: my_use_atomic_units
  integer,allocatable :: varid(:)
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  character(etsf_charlen) :: flag


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_kpoints_get : enter'
!ENDDEBUG

  ! Get values for optional arguments, set default.
  if (present(use_atomic_units)) then
    my_use_atomic_units = use_atomic_units
  else
    my_use_atomic_units = .true.
  end if
  
  allocate(varid(5))
  
  if (associated(folder%kpoint_grid_shift)) then
    call etsf_io_low_read_var(ncid, "kpoint_grid_shift", &
                            & folder%kpoint_grid_shift, &
                            & lstat, ncvarid = varid(1), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%kpoint_grid_vectors)) then
    call etsf_io_low_read_var(ncid, "kpoint_grid_vectors", &
                            & folder%kpoint_grid_vectors, &
                            & lstat, ncvarid = varid(2), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%monkhorst_pack_folding)) then
    call etsf_io_low_read_var(ncid, "monkhorst_pack_folding", &
                            & folder%monkhorst_pack_folding, &
                            & lstat, ncvarid = varid(3), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%reduced_coordinates_of_kpoints)) then
    call etsf_io_low_read_var(ncid, "reduced_coordinates_of_kpoints", &
                            & folder%reduced_coordinates_of_kpoints, &
                            & lstat, ncvarid = varid(4), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%kpoint_weights)) then
    call etsf_io_low_read_var(ncid, "kpoint_weights", &
                            & folder%kpoint_weights, &
                            & lstat, ncvarid = varid(5), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  deallocate(varid)

!DEBUG
!write (*,*) 'etsf_io_kpoints_get : exit'
!ENDDEBUG

end subroutine etsf_io_kpoints_get
!!***
