/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import java.util.Vector;

public class AlignmentOrder {
    public static final int FILE = 0;
    public static final int MSA = 1;
    public static final int USER = 2;
    private int Type = 0;
    private String Name;
    private Vector Order = null;

    public AlignmentOrder() {
    }

    public AlignmentOrder(Vector anOrder) {
        this.Order = anOrder;
    }

    public AlignmentOrder(AlignmentI orderFrom) {
        this.Order = new Vector();
        int ns = orderFrom.getHeight();
        for (int i = 0; i < ns; ++i) {
            this.Order.addElement(orderFrom.getSequenceAt(i));
        }
    }

    public AlignmentOrder(SequenceI[] orderFrom) {
        this.Order = new Vector();
        int ns = orderFrom.length;
        for (int i = 0; i < ns; ++i) {
            this.Order.addElement(orderFrom[i]);
        }
    }

    public void setType(int Type2) {
        this.Type = Type2;
    }

    public int getType() {
        return this.Type;
    }

    public void setName(String Name) {
        this.Name = Name;
    }

    public String getName() {
        return this.Name;
    }

    public void setOrder(Vector Order) {
        this.Order = Order;
    }

    public Vector getOrder() {
        return this.Order;
    }

    public boolean updateSequence(SequenceI oldref, SequenceI newref) {
        int found = this.Order.indexOf(oldref);
        if (found > -1) {
            this.Order.setElementAt(newref, found);
        }
        return found > -1;
    }

    public boolean equals(AlignmentOrder o) {
        return this.equals(o, true);
    }

    public boolean equals(AlignmentOrder o, boolean identity) {
        if (o != this) {
            if (o == null) {
                return false;
            }
            if (this.Order != null && o.Order != null && this.Order.size() == o.Order.size()) {
                if (!identity) {
                    throw new Error("Weak sequenceI equivalence not yet implemented.");
                }
                int j = o.Order.size();
                for (int i = 0; i < j; ++i) {
                    if (this.Order.elementAt(i) == o.Order.elementAt(i)) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean isConsistent(AlignmentOrder o) {
        return this.isConsistent(o, true);
    }

    public boolean isConsistent(AlignmentOrder o, boolean identity) {
        if (o != this) {
            if (o == null) {
                return false;
            }
            if (this.Order != null && o.Order != null) {
                Vector s;
                Vector c;
                if (o.Order.size() > this.Order.size()) {
                    c = o.Order;
                    s = this.Order;
                } else {
                    c = this.Order;
                    s = o.Order;
                }
                if (!identity) {
                    throw new Error("Weak sequenceI equivalence not yet implemented.");
                }
                int last = -1;
                int j = s.size();
                for (int i = 0; i < j; ++i) {
                    int pos = c.indexOf(s.elementAt(i));
                    if (pos <= last) {
                        return false;
                    }
                    last = pos;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

