/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MAINBOARD_GOOGLE_GERALT_GPIO_H__
#define __MAINBOARD_GOOGLE_GERALT_GPIO_H__

#include <soc/gpio.h>

#define GPIO_AP_DISP_BKLTEN	GPIO(GPIO01)
#define GPIO_AP_EC_WARM_RST_REQ	GPIO(DPI_HSYNC)
#define GPIO_AP_WP_ODL		GPIO(GPIO15)
#define GPIO_BEEP_ON_OD		GPIO(KPROW0)
#define GPIO_EC_AP_INT_ODL	GPIO(DPI_DE)
#define GPIO_EC_AP_HPD_OD	GPIO(DPTX_HPD)
#define GPIO_EC_AP_HID_INT_ODL	GPIO(DPI_VSYNC)
#define GPIO_EC_AP_RSVD0_ODL	GPIO(MSDC2_DAT1)
#define GPIO_EN_SPKR		GPIO(I2SIN_D1)
#define GPIO_GSC_AP_INT_ODL	GPIO(GPIO00)
#define GPIO_RST_SPKR_L		GPIO(I2SO2_D1)
#define GPIO_XHCI_INIT_DONE	GPIO(DPI_CK)
#define GPIO_SAR_INT_ODL	GPIO(USB1_VBUS_VALID)
#define GPIO_HP_INT_ODL		GPIO(I2SIN_BCK)
#define GPIO_SPKR_INT_ODL	GPIO(I2SIN_WS)

#define GPIO_I2SI1_LRCK		GPIO(I2SO2_D2)
#define GPIO_I2SI1_BCK		GPIO(I2SIN_D3)
#define GPIO_I2SO1_D0		GPIO(GPIO11)

#define GPIO_PCIE_WAKE_1V8_ODL		GPIO(PCIE_WAKE_N)
#define GPIO_PCIE_CLKREQ_1V8_ODL	GPIO(PCIE_CLKREQ_N)
#define GPIO_TCHSCR_INT_1V8_L		GPIO(DPI_D12)
#define GPIO_MT7921_PMU_EN_1V8		GPIO(DPI_D14)

#define GPIO_EDP_BL_PWM_1V8		GPIO(DISP_PWM1)
#define GPIO_EDP_HPD_1V8		GPIO(GPIO17)
#define GPIO_EN_PP3300_EDP_DISP_X	GPIO(DSI1_LCM_RST)

#define GPIO_DISP_RST_1V8_L		GPIO(DSI0_LCM_RST)
#define GPIO_EN_PPVAR_MIPI_DISP		GPIO(GPIO03)
#define GPIO_EN_PPVAR_MIPI_DISP_150MA	GPIO(GPIO04)
#define GPIO_MIPI_BL_PWM_1V8		GPIO(DISP_PWM0)

#define GPIO_SD_CD_ODL			GPIO(I2SIN_MCK)

#define GPIO_USB3_HUB_RST_L		GPIO(MSDC2_DAT0)

void setup_chromeos_gpios(void);

#endif
