# Casilda

A simple Wayland compositor widget for Gtk 4 which can be used to embed other
processes windows in your Gtk 4 application.

It was originally created for Cambalache's workspace using wlroots,
a modular library to create Wayland compositors.

Following Wayland tradition, this library is named after my hometown in
Santa Fe, Argentina.

## License

Casilda is distributed under the [GNU Lesser General Public License](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html),
version 2.1 only (LGPL) as described in the COPYING file.

## Source code

Source code lives on GNOME gitlab [here](https://gitlab.gnome.org/jpu/casilda)

`git clone https://gitlab.gnome.org/jpu/casilda.git`

## Dependencies

* [Meson](http://mesonbuild.com) build system
* [GTK](http://www.gtk.org) Version 4
* wlroots - Library to create Wayland compositors


## Manual installation

This is a regular meson package and can be installed the usual way.

```bash
# Configure project in _build directory
meson setup --wipe --prefix=~/.local _build .

# Build and install in ~/.local
ninja -C _build install
```

## How to use it

To add a Wayland compositor to your application all you have to do is create a
CasildaCompositor widget and pack it as any other widget.

```c
compositor = casilda_compositor_new (NULL);
gtk_window_set_child (GTK_WINDOW (window), GTK_WIDGET (compositor));
gtk_window_present (GTK_WINDOW (window));
```

The easiest way to show another process window in the compositor is to spawn the
process using the helper function provided by Casilda

```c
gchar *argv[] = { "/usr/bin/gtk4-demo", NULL };
casilda_compositor_spawn_async (compositor, NULL, argv, NULL, G_SPAWN_DEFAULT, NULL, NULL, NULL, NULL);
```

## API

Casilda uses gi-docgen to generate it's API reference documentation and is [available online.](https://jpu.pages.gitlab.gnome.org/casilda/)

## Contributing

If you are interested in contributing you can open an issue [here](https://gitlab.gnome.org/jpu/casilda/-/issues)
and/or a merge request [here](https://gitlab.gnome.org/jpu/casilda/-/merge_requests)

## Contact

You can hang with us and ask us questions on Cambalache Matrix at #cambalache:gnome.org

[Matrix](https://matrix.to/#/#cambalache:gnome.org)
