
/* Simple program:  Test bitmap blits */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SDL/SDL.h"
#include "SDL/SDL_video.h"
#include "SDL/SDL_mouse.h"
#include "SDL/SDL_syswm.h"

#ifndef SDL_VERSIONNUM
#define SDL_VERSIONNUM(X, Y, Z)  (X)*1000 + (Y)*100 + (Z)
#endif

#define _SDL_VER SDL_VERSIONNUM(SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL)

#if _SDL_VER < 1103
int main(int argc, char *argv[]) { return 0; }
#else

static const char* def_file = "KylieMinogue.bmp";
static int width = 640;
static int height = 480;
static int fourcc = SDL_YV12_OVERLAY;

int main(int argc, char *argv[])
{
    SDL_Surface* screen;
    SDL_Surface* bitmap;
    SDL_Overlay* overlay;
    Uint8  video_bpp;
    Uint32 videoflags;
    Uint8 *buffer;
    int i, done;
    SDL_Event event;
    SDL_Rect rect;
    int use_yuv;

    /* Initialize SDL */
    if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
	fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
	exit(1);
    }
    atexit(SDL_Quit);
    SDL_EventState(SDL_SYSWMEVENT, SDL_ENABLE);

    video_bpp = 0;
    videoflags = SDL_SWSURFACE | SDL_RESIZABLE;
    while ( argc > 1 ) {
	--argc;
	if ( strcmp(argv[argc-1], "-bpp") == 0 ) {
	    video_bpp = atoi(argv[argc]);
	    --argc;
	} else if ( strcmp(argv[argc], "-warp") == 0 ) {
	    videoflags |= SDL_HWPALETTE;
	} else if ( strcmp(argv[argc], "-w") == 0 ) {
	    width = atoi(argv[++argc]);
	} else if ( strcmp(argv[argc], "-h") == 0 ) {
	    height = atoi(argv[++argc]);
	} else if ( strcmp(argv[argc], "-hw") == 0 ) {
	    videoflags |= SDL_HWSURFACE;
	} else if ( strcmp(argv[argc], "-yv12") == 0 ) {
	    fourcc = SDL_YV12_OVERLAY;
	} else if ( strcmp(argv[argc], "-iyuv") == 0 ) {
	    fourcc = SDL_IYUV_OVERLAY;
	} else if ( strcmp(argv[argc], "-yuy2") == 0 ) {
	    fourcc = SDL_YV12_OVERLAY;
	} else if ( strcmp(argv[argc], "-uyvy") == 0 ) {
	    fourcc = SDL_UYVY_OVERLAY;
	} else if ( strcmp(argv[argc], "-yvyu") == 0 ) {
	    fourcc = SDL_YVYU_OVERLAY;
	} else if ( strcmp(argv[argc], "-fullscreen") == 0 ) {
	    videoflags |= SDL_FULLSCREEN;
	} else {
	    fprintf(stderr, "Usage: %s [-bpp N] [-warp] [-hw] [-fullscreen]"
		    "[-yuy2|-iyuv|-yv12|-uyvy|-yvyu] [-w #width] [-h #height]"
                    "\n",
		    argv[0]);
	    exit(1);
	}
    }

    /* Set 640x480 video mode */
    if ( (screen=SDL_SetVideoMode(width, height, video_bpp, videoflags)) == NULL ) {
	fprintf(stderr, "Couldn't set 640x480x%d video mode: %s\n",
		video_bpp, SDL_GetError());
	exit(2);
    }

    overlay = SDL_CreateYUVOverlay(width, height, fourcc, screen);

    /* Set the surface pixels and refresh! */
    if ( SDL_LockSurface(screen) < 0 ) {
	fprintf(stderr, "Couldn't lock the display surface: %s\n",
		SDL_GetError());
	exit(2);
    }
    buffer=(Uint8 *)screen->pixels;
    for ( i=screen->h/2; i<screen->h; i++ ) {
	memset(buffer, (i*255)/screen->h, screen->pitch);
	buffer += screen->pitch;
    }
    SDL_UnlockSurface(screen);
    SDL_UpdateRect(screen, 0, 0, 0, 0);

    buffer = (Uint8 *)overlay->pixels[0];
    for (i = 0; i < screen->h; i++)
    {
	memset(buffer, i, overlay->pitches[0]);
        buffer += overlay->pitches[0];
    }

    rect.x = rect.y = 0;
    rect.w = width;
    rect.h = height;
    SDL_DisplayYUVOverlay(overlay, &rect);


    /* Load the bitmap */
    bitmap = SDL_LoadBMP(def_file);
    if ( bitmap == NULL ) {
	exit(1);
    }

    /* Wait for a keystroke */
    done = 0;
    while ( !done ) {
	/* Check for events */
	while ( SDL_PollEvent(&event) ) {
	    switch (event.type) {
	    case SDL_MOUSEBUTTONDOWN: {
		SDL_Rect dst;

		dst.x = event.button.x - bitmap->w/2;
		dst.y = event.button.y - bitmap->h/2;
		dst.w = bitmap->w;
		dst.h = bitmap->h;
		SDL_BlitSurface(bitmap, NULL, screen, &dst);
		SDL_UpdateRects(screen,1,&dst);
		SDL_DisplayYUVOverlay(overlay, &rect);
	    }
	    break;
	    case SDL_KEYDOWN:
		switch (event.key.keysym.sym)
		{
		case SDLK_q:
		case SDLK_ESCAPE:
		case SDLK_RETURN:
		    done = 1;
		    break;
		case SDLK_SPACE:

		    // (
		    printf("KEYSPACE\n");
                    break;
		}
                break;
	    case SDL_QUIT:
		done = 1;
		break;
	    default:
                //printf("EVENT %d\n", event.type);
		SDL_DisplayYUVOverlay(overlay, &rect);
		break;
	    }
	}
    }
    SDL_FreeSurface(bitmap);
    return(0);
}
#endif
