#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sherlock Holmes: Crimes and Punishments
# send your bug reports to contact@dotslashplay.it
###

script_version=20240826.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='sherlock-holmes-7-crimes-and-punishments'
GAME_NAME='Sherlock Holmes: Crimes and Punishments'

ARCHIVE_BASE_0_NAME='setup_sherlock_holmes_crimes_and_punishments_76411_(32864).exe'
ARCHIVE_BASE_0_MD5='b9c8bcd83540b4accfa03ea016ab75ba'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_sherlock_holmes_crimes_and_punishments_76411_(32864)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='757b844b87696a6ab9e044a354189d6f'
ARCHIVE_BASE_0_PART2_NAME='setup_sherlock_holmes_crimes_and_punishments_76411_(32864)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='d786ed336b2c2f48de3289dfce038081'
ARCHIVE_BASE_0_VERSION='76411-gog32864'
ARCHIVE_BASE_0_SIZE='9200000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/sherlock_holmes_crimes_and_punishments'

CONTENT_PATH_DEFAULT='.'
## TODO: Check if the inclusion of the "app" directory is required.
CONTENT_GAME_BIN_FILES='
app
binaries
fdk'
CONTENT_GAME_DATA_FILES='
engine
sh7game'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/My Games/Sherlock Holmes - Crimes and Punishments/SH7Game'

APP_MAIN_EXE='binaries/win32/sherlock.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
