// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// frame_capture_replay_autogen.cpp:
//   Util function to dispatch captured GL calls through Context and replay them.

#include "angle_gl.h"

#include "common/debug.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/FrameCapture.h"

using namespace gl;

namespace angle
{

void FrameCaptureShared::ReplayCall(gl::Context *context,
                                    ReplayContext *replayContext,
                                    const CallCapture &call)
{
    const ParamBuffer &params = call.params;
    switch (call.entryPoint)
    {
        case angle::EntryPoint::GLActiveShaderProgram:
            context->activeShaderProgram(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("programPacked", ParamType::TShaderProgramID, 1)
                    .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLActiveTexture:
            context->activeTexture(
                params.getParam("texture", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLAlphaFunc:
            context->alphaFunc(
                params.getParam("funcPacked", ParamType::TAlphaTestFunc, 0).value.AlphaTestFuncVal,
                params.getParam("ref", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLAlphaFuncx:
            context->alphaFuncx(
                params.getParam("funcPacked", ParamType::TAlphaTestFunc, 0).value.AlphaTestFuncVal,
                params.getParam("ref", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLAttachShader:
            context->attachShader(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("shaderPacked", ParamType::TShaderProgramID, 1)
                                      .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLBeginQuery:
            context->beginQuery(
                params.getParam("targetPacked", ParamType::TQueryType, 0).value.QueryTypeVal,
                params.getParam("idPacked", ParamType::TQueryID, 1).value.QueryIDVal);
            break;
        case angle::EntryPoint::GLBeginTransformFeedback:
            context->beginTransformFeedback(
                params.getParam("primitiveModePacked", ParamType::TPrimitiveMode, 0)
                    .value.PrimitiveModeVal);
            break;
        case angle::EntryPoint::GLBindAttribLocation:
            context->bindAttribLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case angle::EntryPoint::GLBindBuffer:
            context->bindBuffer(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 1).value.BufferIDVal);
            break;
        case angle::EntryPoint::GLBindBufferBase:
            context->bindBufferBase(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 2).value.BufferIDVal);
            break;
        case angle::EntryPoint::GLBindBufferRange:
            context->bindBufferRange(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 2).value.BufferIDVal,
                params.getParam("offset", ParamType::TGLintptr, 3).value.GLintptrVal,
                params.getParam("size", ParamType::TGLsizeiptr, 4).value.GLsizeiptrVal);
            break;
        case angle::EntryPoint::GLBindFragDataLocation:
            context->bindFragDataLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("color", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case angle::EntryPoint::GLBindFragDataLocationIndexed:
            context->bindFragDataLocationIndexed(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("colorNumber", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("index", ParamType::TGLuint, 2).value.GLuintVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 3)));
            break;
        case angle::EntryPoint::GLBindFramebuffer:
            context->bindFramebuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("framebufferPacked", ParamType::TFramebufferID, 1)
                    .value.FramebufferIDVal);
            break;
        case angle::EntryPoint::GLBindImageTexture:
            context->bindImageTexture(
                params.getParam("unit", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("texturePacked", ParamType::TTextureID, 1).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("layered", ParamType::TGLboolean, 3).value.GLbooleanVal,
                params.getParam("layer", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("access", ParamType::TGLenum, 5).value.GLenumVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBindProgramPipeline:
            context->bindProgramPipeline(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal);
            break;
        case angle::EntryPoint::GLBindRenderbuffer:
            context->bindRenderbuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("renderbufferPacked", ParamType::TRenderbufferID, 1)
                    .value.RenderbufferIDVal);
            break;
        case angle::EntryPoint::GLBindSampler:
            context->bindSampler(
                params.getParam("unit", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("samplerPacked", ParamType::TSamplerID, 1).value.SamplerIDVal);
            break;
        case angle::EntryPoint::GLBindTexture:
            context->bindTexture(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("texturePacked", ParamType::TTextureID, 1).value.TextureIDVal);
            break;
        case angle::EntryPoint::GLBindTransformFeedback:
            context->bindTransformFeedback(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("idPacked", ParamType::TTransformFeedbackID, 1)
                    .value.TransformFeedbackIDVal);
            break;
        case angle::EntryPoint::GLBindVertexArray:
            context->bindVertexArray(params.getParam("arrayPacked", ParamType::TVertexArrayID, 0)
                                         .value.VertexArrayIDVal);
            break;
        case angle::EntryPoint::GLBindVertexBuffer:
            context->bindVertexBuffer(
                params.getParam("bindingindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 1).value.BufferIDVal,
                params.getParam("offset", ParamType::TGLintptr, 2).value.GLintptrVal,
                params.getParam("stride", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLBlendBarrier:
            context->blendBarrier();
            break;
        case angle::EntryPoint::GLBlendColor:
            context->blendColor(params.getParam("red", ParamType::TGLfloat, 0).value.GLfloatVal,
                                params.getParam("green", ParamType::TGLfloat, 1).value.GLfloatVal,
                                params.getParam("blue", ParamType::TGLfloat, 2).value.GLfloatVal,
                                params.getParam("alpha", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLBlendEquation:
            context->blendEquation(params.getParam("mode", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlendEquationSeparate:
            context->blendEquationSeparate(
                params.getParam("modeRGB", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("modeAlpha", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlendEquationSeparatei:
            context->blendEquationSeparatei(
                params.getParam("buf", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("modeRGB", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("modeAlpha", ParamType::TGLenum, 2).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlendEquationi:
            context->blendEquationi(params.getParam("buf", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("mode", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlendFunc:
            context->blendFunc(params.getParam("sfactor", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("dfactor", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlendFuncSeparate:
            context->blendFuncSeparate(
                params.getParam("sfactorRGB", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("dfactorRGB", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("sfactorAlpha", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("dfactorAlpha", ParamType::TGLenum, 3).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlendFuncSeparatei:
            context->blendFuncSeparatei(
                params.getParam("buf", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("srcRGB", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("dstRGB", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("srcAlpha", ParamType::TGLenum, 3).value.GLenumVal,
                params.getParam("dstAlpha", ParamType::TGLenum, 4).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlendFunci:
            context->blendFunci(params.getParam("buf", ParamType::TGLuint, 0).value.GLuintVal,
                                params.getParam("src", ParamType::TGLenum, 1).value.GLenumVal,
                                params.getParam("dst", ParamType::TGLenum, 2).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlitFramebuffer:
            context->blitFramebuffer(
                params.getParam("srcX0", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("srcY0", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("srcX1", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("srcY1", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("dstX0", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("dstY0", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("dstX1", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("dstY1", ParamType::TGLint, 7).value.GLintVal,
                params.getParam("mask", ParamType::TGLbitfield, 8).value.GLbitfieldVal,
                params.getParam("filter", ParamType::TGLenum, 9).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBlitFramebufferNV:
            context->blitFramebufferNV(
                params.getParam("srcX0", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("srcY0", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("srcX1", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("srcY1", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("dstX0", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("dstY0", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("dstX1", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("dstY1", ParamType::TGLint, 7).value.GLintVal,
                params.getParam("mask", ParamType::TGLbitfield, 8).value.GLbitfieldVal,
                params.getParam("filter", ParamType::TGLenum, 9).value.GLenumVal);
            break;
        case angle::EntryPoint::GLBufferData:
            context->bufferData(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("size", ParamType::TGLsizeiptr, 1).value.GLsizeiptrVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 2)),
                params.getParam("usagePacked", ParamType::TBufferUsage, 3).value.BufferUsageVal);
            break;
        case angle::EntryPoint::GLBufferStorage:
            context->bufferStorage(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("size", ParamType::TGLsizeiptr, 1).value.GLsizeiptrVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 2)),
                params.getParam("flags", ParamType::TGLbitfield, 3).value.GLbitfieldVal);
            break;
        case angle::EntryPoint::GLBufferSubData:
            context->bufferSubData(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("offset", ParamType::TGLintptr, 1).value.GLintptrVal,
                params.getParam("size", ParamType::TGLsizeiptr, 2).value.GLsizeiptrVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 3)));
            break;
        case angle::EntryPoint::GLCheckFramebufferStatus:
            context->checkFramebufferStatus(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLClear:
            context->clear(params.getParam("mask", ParamType::TGLbitfield, 0).value.GLbitfieldVal);
            break;
        case angle::EntryPoint::GLClearBufferfi:
            context->clearBufferfi(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("depth", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("stencil", ParamType::TGLint, 3).value.GLintVal);
            break;
        case angle::EntryPoint::GLClearBufferfv:
            context->clearBufferfv(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLClearBufferiv:
            context->clearBufferiv(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLClearBufferuiv:
            context->clearBufferuiv(
                params.getParam("buffer", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("drawbuffer", ParamType::TGLint, 1).value.GLintVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLClearColor:
            context->clearColor(params.getParam("red", ParamType::TGLfloat, 0).value.GLfloatVal,
                                params.getParam("green", ParamType::TGLfloat, 1).value.GLfloatVal,
                                params.getParam("blue", ParamType::TGLfloat, 2).value.GLfloatVal,
                                params.getParam("alpha", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLClearColorx:
            context->clearColorx(params.getParam("red", ParamType::TGLfixed, 0).value.GLfixedVal,
                                 params.getParam("green", ParamType::TGLfixed, 1).value.GLfixedVal,
                                 params.getParam("blue", ParamType::TGLfixed, 2).value.GLfixedVal,
                                 params.getParam("alpha", ParamType::TGLfixed, 3).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLClearDepthf:
            context->clearDepthf(params.getParam("d", ParamType::TGLfloat, 0).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLClearDepthx:
            context->clearDepthx(params.getParam("depth", ParamType::TGLfixed, 0).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLClearStencil:
            context->clearStencil(params.getParam("s", ParamType::TGLint, 0).value.GLintVal);
            break;
        case angle::EntryPoint::GLClientActiveTexture:
            context->clientActiveTexture(
                params.getParam("texture", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLClientWaitSync:
            context->clientWaitSync(
                params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal,
                params.getParam("flags", ParamType::TGLbitfield, 1).value.GLbitfieldVal,
                params.getParam("timeout", ParamType::TGLuint64, 2).value.GLuint64Val);
            break;
        case angle::EntryPoint::GLClipControl:
            context->clipControl(params.getParam("origin", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("depth", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case angle::EntryPoint::GLClipPlanef:
            context->clipPlanef(params.getParam("p", ParamType::TGLenum, 0).value.GLenumVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("eqn", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLClipPlanex:
            context->clipPlanex(params.getParam("plane", ParamType::TGLenum, 0).value.GLenumVal,
                                replayContext->getAsConstPointer<const GLfixed *>(params.getParam(
                                    "equation", ParamType::TGLfixedConstPointer, 1)));
            break;
        case angle::EntryPoint::GLColor4f:
            context->color4f(params.getParam("red", ParamType::TGLfloat, 0).value.GLfloatVal,
                             params.getParam("green", ParamType::TGLfloat, 1).value.GLfloatVal,
                             params.getParam("blue", ParamType::TGLfloat, 2).value.GLfloatVal,
                             params.getParam("alpha", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLColor4ub:
            context->color4ub(params.getParam("red", ParamType::TGLubyte, 0).value.GLubyteVal,
                              params.getParam("green", ParamType::TGLubyte, 1).value.GLubyteVal,
                              params.getParam("blue", ParamType::TGLubyte, 2).value.GLubyteVal,
                              params.getParam("alpha", ParamType::TGLubyte, 3).value.GLubyteVal);
            break;
        case angle::EntryPoint::GLColor4x:
            context->color4x(params.getParam("red", ParamType::TGLfixed, 0).value.GLfixedVal,
                             params.getParam("green", ParamType::TGLfixed, 1).value.GLfixedVal,
                             params.getParam("blue", ParamType::TGLfixed, 2).value.GLfixedVal,
                             params.getParam("alpha", ParamType::TGLfixed, 3).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLColorMask:
            context->colorMask(
                params.getParam("red", ParamType::TGLboolean, 0).value.GLbooleanVal,
                params.getParam("green", ParamType::TGLboolean, 1).value.GLbooleanVal,
                params.getParam("blue", ParamType::TGLboolean, 2).value.GLbooleanVal,
                params.getParam("alpha", ParamType::TGLboolean, 3).value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLColorMaski:
            context->colorMaski(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                params.getParam("r", ParamType::TGLboolean, 1).value.GLbooleanVal,
                                params.getParam("g", ParamType::TGLboolean, 2).value.GLbooleanVal,
                                params.getParam("b", ParamType::TGLboolean, 3).value.GLbooleanVal,
                                params.getParam("a", ParamType::TGLboolean, 4).value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLColorPointer:
            context->colorPointer(
                params.getParam("size", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 1)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 3)));
            break;
        case angle::EntryPoint::GLCompileShader:
            context->compileShader(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                       .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLCompressedTexImage2D:
            context->compressedTexImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("imageSize", ParamType::TGLsizei, 6).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 7)));
            break;
        case angle::EntryPoint::GLCompressedTexImage3D:
            context->compressedTexImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("imageSize", ParamType::TGLsizei, 7).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 8)));
            break;
        case angle::EntryPoint::GLCompressedTexSubImage2D:
            context->compressedTexSubImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal,
                params.getParam("imageSize", ParamType::TGLsizei, 7).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 8)));
            break;
        case angle::EntryPoint::GLCompressedTexSubImage3D:
            context->compressedTexSubImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 7).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 8).value.GLenumVal,
                params.getParam("imageSize", ParamType::TGLsizei, 9).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("data", ParamType::TvoidConstPointer, 10)));
            break;
        case angle::EntryPoint::GLCopyBufferSubData:
            context->copyBufferSubData(
                params.getParam("readTargetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("writeTargetPacked", ParamType::TBufferBinding, 1)
                    .value.BufferBindingVal,
                params.getParam("readOffset", ParamType::TGLintptr, 2).value.GLintptrVal,
                params.getParam("writeOffset", ParamType::TGLintptr, 3).value.GLintptrVal,
                params.getParam("size", ParamType::TGLsizeiptr, 4).value.GLsizeiptrVal);
            break;
        case angle::EntryPoint::GLCopyImageSubData:
            context->copyImageSubData(
                params.getParam("srcName", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("srcTarget", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("srcLevel", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("srcX", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("srcY", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("srcZ", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("dstName", ParamType::TGLuint, 6).value.GLuintVal,
                params.getParam("dstTarget", ParamType::TGLenum, 7).value.GLenumVal,
                params.getParam("dstLevel", ParamType::TGLint, 8).value.GLintVal,
                params.getParam("dstX", ParamType::TGLint, 9).value.GLintVal,
                params.getParam("dstY", ParamType::TGLint, 10).value.GLintVal,
                params.getParam("dstZ", ParamType::TGLint, 11).value.GLintVal,
                params.getParam("srcWidth", ParamType::TGLsizei, 12).value.GLsizeiVal,
                params.getParam("srcHeight", ParamType::TGLsizei, 13).value.GLsizeiVal,
                params.getParam("srcDepth", ParamType::TGLsizei, 14).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLCopyTexImage2D:
            context->copyTexImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("x", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 7).value.GLintVal);
            break;
        case angle::EntryPoint::GLCopyTexSubImage2D:
            context->copyTexSubImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("x", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 7).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLCopyTexSubImage3D:
            context->copyTexSubImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("x", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 7).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 8).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLCreateProgram:
            context->createProgram();
            break;
        case angle::EntryPoint::GLCreateShader:
            context->createShader(
                params.getParam("typePacked", ParamType::TShaderType, 0).value.ShaderTypeVal);
            break;
        case angle::EntryPoint::GLCreateShaderProgramv:
            context->createShaderProgramv(
                params.getParam("typePacked", ParamType::TShaderType, 0).value.ShaderTypeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("strings", ParamType::TGLcharConstPointerPointer, 2)));
            break;
        case angle::EntryPoint::GLCullFace:
            context->cullFace(
                params.getParam("modePacked", ParamType::TCullFaceMode, 0).value.CullFaceModeVal);
            break;
        case angle::EntryPoint::GLDebugMessageCallback:
            context->debugMessageCallback(
                params.getParam("callback", ParamType::TGLDEBUGPROC, 0).value.GLDEBUGPROCVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("userParam", ParamType::TvoidConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDebugMessageControl:
            context->debugMessageControl(
                params.getParam("source", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("severity", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("count", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("ids", ParamType::TGLuintConstPointer, 4)),
                params.getParam("enabled", ParamType::TGLboolean, 5).value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLDebugMessageInsert:
            context->debugMessageInsert(
                params.getParam("source", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("id", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("severity", ParamType::TGLenum, 3).value.GLenumVal,
                params.getParam("length", ParamType::TGLsizei, 4).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("buf", ParamType::TGLcharConstPointer, 5)));
            break;
        case angle::EntryPoint::GLDeleteBuffers:
            context->deleteBuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const BufferID *>(
                    params.getParam("buffersPacked", ParamType::TBufferIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteFencesNV:
            context->deleteFencesNV(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const FenceNVID *>(
                    params.getParam("fencesPacked", ParamType::TFenceNVIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteFramebuffers:
            context->deleteFramebuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const FramebufferID *>(params.getParam(
                    "framebuffersPacked", ParamType::TFramebufferIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteProgram:
            context->deleteProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                       .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLDeleteProgramPipelines:
            context->deleteProgramPipelines(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const ProgramPipelineID *>(params.getParam(
                    "pipelinesPacked", ParamType::TProgramPipelineIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteQueries:
            context->deleteQueries(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const QueryID *>(
                    params.getParam("idsPacked", ParamType::TQueryIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteRenderbuffers:
            context->deleteRenderbuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const RenderbufferID *>(params.getParam(
                    "renderbuffersPacked", ParamType::TRenderbufferIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteSamplers:
            context->deleteSamplers(
                params.getParam("count", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const SamplerID *>(
                    params.getParam("samplersPacked", ParamType::TSamplerIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteShader:
            context->deleteShader(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLDeleteSync:
            context->deleteSync(params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal);
            break;
        case angle::EntryPoint::GLDeleteTextures:
            context->deleteTextures(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const TextureID *>(
                    params.getParam("texturesPacked", ParamType::TTextureIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteTransformFeedbacks:
            context->deleteTransformFeedbacks(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const TransformFeedbackID *>(
                    params.getParam("idsPacked", ParamType::TTransformFeedbackIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDeleteVertexArrays:
            context->deleteVertexArrays(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const VertexArrayID *>(
                    params.getParam("arraysPacked", ParamType::TVertexArrayIDConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDepthFunc:
            context->depthFunc(params.getParam("func", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLDepthMask:
            context->depthMask(
                params.getParam("flag", ParamType::TGLboolean, 0).value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLDepthRangef:
            context->depthRangef(params.getParam("n", ParamType::TGLfloat, 0).value.GLfloatVal,
                                 params.getParam("f", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLDepthRangex:
            context->depthRangex(params.getParam("n", ParamType::TGLfixed, 0).value.GLfixedVal,
                                 params.getParam("f", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLDetachShader:
            context->detachShader(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("shaderPacked", ParamType::TShaderProgramID, 1)
                                      .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLDisable:
            context->disable(params.getParam("cap", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLDisableClientState:
            context->disableClientState(
                params.getParam("arrayPacked", ParamType::TClientVertexArrayType, 0)
                    .value.ClientVertexArrayTypeVal);
            break;
        case angle::EntryPoint::GLDisableVertexAttribArray:
            context->disableVertexAttribArray(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal);
            break;
        case angle::EntryPoint::GLDisablei:
            context->disablei(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                              params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLDispatchCompute:
            context->dispatchCompute(
                params.getParam("num_groups_x", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("num_groups_y", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("num_groups_z", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case angle::EntryPoint::GLDispatchComputeIndirect:
            context->dispatchComputeIndirect(
                params.getParam("indirect", ParamType::TGLintptr, 0).value.GLintptrVal);
            break;
        case angle::EntryPoint::GLDrawArrays:
            context->drawArrays(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("first", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLDrawArraysIndirect:
            context->drawArraysIndirect(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indirect", ParamType::TvoidConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDrawArraysInstanced:
            context->drawArraysInstanced(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("first", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("instancecount", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLDrawArraysInstancedBaseInstance:
            context->drawArraysInstancedBaseInstance(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("first", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("instancecount", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("baseinstance", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case angle::EntryPoint::GLDrawBuffers:
            context->drawBuffers(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLenum *>(
                                     params.getParam("bufs", ParamType::TGLenumConstPointer, 1)));
            break;
        case angle::EntryPoint::GLDrawElements:
            context->drawElements(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)));
            break;
        case angle::EntryPoint::GLDrawElementsBaseVertex:
            context->drawElementsBaseVertex(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)),
                params.getParam("basevertex", ParamType::TGLint, 4).value.GLintVal);
            break;
        case angle::EntryPoint::GLDrawElementsIndirect:
            context->drawElementsIndirect(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 1)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indirect", ParamType::TvoidConstPointer, 2)));
            break;
        case angle::EntryPoint::GLDrawElementsInstanced:
            context->drawElementsInstanced(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)),
                params.getParam("instancecount", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLDrawElementsInstancedBaseInstance:
            context->drawElementsInstancedBaseInstance(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)),
                params.getParam("instancecount", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("baseinstance", ParamType::TGLuint, 5).value.GLuintVal);
            break;
        case angle::EntryPoint::GLDrawElementsInstancedBaseVertex:
            context->drawElementsInstancedBaseVertex(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)),
                params.getParam("instancecount", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("basevertex", ParamType::TGLint, 5).value.GLintVal);
            break;
        case angle::EntryPoint::GLDrawElementsInstancedBaseVertexBaseInstance:
            context->drawElementsInstancedBaseVertexBaseInstance(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 3)),
                params.getParam("instancecount", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("basevertex", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("baseinstance", ParamType::TGLuint, 6).value.GLuintVal);
            break;
        case angle::EntryPoint::GLDrawRangeElements:
            context->drawRangeElements(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("start", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("end", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("count", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 4)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 5)));
            break;
        case angle::EntryPoint::GLDrawRangeElementsBaseVertex:
            context->drawRangeElementsBaseVertex(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("start", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("end", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("count", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 4)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indices", ParamType::TvoidConstPointer, 5)),
                params.getParam("basevertex", ParamType::TGLint, 6).value.GLintVal);
            break;
        case angle::EntryPoint::GLEnable:
            context->enable(params.getParam("cap", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLEnableClientState:
            context->enableClientState(
                params.getParam("arrayPacked", ParamType::TClientVertexArrayType, 0)
                    .value.ClientVertexArrayTypeVal);
            break;
        case angle::EntryPoint::GLEnableVertexAttribArray:
            context->enableVertexAttribArray(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal);
            break;
        case angle::EntryPoint::GLEnablei:
            context->enablei(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLEndQuery:
            context->endQuery(
                params.getParam("targetPacked", ParamType::TQueryType, 0).value.QueryTypeVal);
            break;
        case angle::EntryPoint::GLEndTransformFeedback:
            context->endTransformFeedback();
            break;
        case angle::EntryPoint::GLFenceSync:
            context->fenceSync(
                params.getParam("condition", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("flags", ParamType::TGLbitfield, 1).value.GLbitfieldVal);
            break;
        case angle::EntryPoint::GLFinish:
            context->finish();
            break;
        case angle::EntryPoint::GLFinishFenceNV:
            context->finishFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal);
            break;
        case angle::EntryPoint::GLFlush:
            context->flush();
            break;
        case angle::EntryPoint::GLFlushMappedBufferRange:
            context->flushMappedBufferRange(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("offset", ParamType::TGLintptr, 1).value.GLintptrVal,
                params.getParam("length", ParamType::TGLsizeiptr, 2).value.GLsizeiptrVal);
            break;
        case angle::EntryPoint::GLFogf:
            context->fogf(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                          params.getParam("param", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLFogfv:
            context->fogfv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                           replayContext->getAsConstPointer<const GLfloat *>(
                               params.getParam("params", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLFogx:
            context->fogx(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                          params.getParam("param", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLFogxv:
            context->fogxv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                           replayContext->getAsConstPointer<const GLfixed *>(
                               params.getParam("param", ParamType::TGLfixedConstPointer, 1)));
            break;
        case angle::EntryPoint::GLFramebufferParameteri:
            context->framebufferParameteri(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLFramebufferParameteriMESA:
            context->framebufferParameteriMESA(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLFramebufferRenderbuffer:
            context->framebufferRenderbuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("renderbuffertarget", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("renderbufferPacked", ParamType::TRenderbufferID, 3)
                    .value.RenderbufferIDVal);
            break;
        case angle::EntryPoint::GLFramebufferTexture:
            context->framebufferTexture(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("texturePacked", ParamType::TTextureID, 2).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 3).value.GLintVal);
            break;
        case angle::EntryPoint::GLFramebufferTexture2D:
            context->framebufferTexture2D(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("textargetPacked", ParamType::TTextureTarget, 2)
                    .value.TextureTargetVal,
                params.getParam("texturePacked", ParamType::TTextureID, 3).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 4).value.GLintVal);
            break;
        case angle::EntryPoint::GLFramebufferTexture3D:
            context->framebufferTexture3D(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("textargetPacked", ParamType::TTextureTarget, 2)
                    .value.TextureTargetVal,
                params.getParam("texturePacked", ParamType::TTextureID, 3).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 5).value.GLintVal);
            break;
        case angle::EntryPoint::GLFramebufferTextureLayer:
            context->framebufferTextureLayer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("texturePacked", ParamType::TTextureID, 2).value.TextureIDVal,
                params.getParam("level", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("layer", ParamType::TGLint, 4).value.GLintVal);
            break;
        case angle::EntryPoint::GLFrontFace:
            context->frontFace(params.getParam("mode", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLFrustumf:
            context->frustumf(params.getParam("l", ParamType::TGLfloat, 0).value.GLfloatVal,
                              params.getParam("r", ParamType::TGLfloat, 1).value.GLfloatVal,
                              params.getParam("b", ParamType::TGLfloat, 2).value.GLfloatVal,
                              params.getParam("t", ParamType::TGLfloat, 3).value.GLfloatVal,
                              params.getParam("n", ParamType::TGLfloat, 4).value.GLfloatVal,
                              params.getParam("f", ParamType::TGLfloat, 5).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLFrustumx:
            context->frustumx(params.getParam("l", ParamType::TGLfixed, 0).value.GLfixedVal,
                              params.getParam("r", ParamType::TGLfixed, 1).value.GLfixedVal,
                              params.getParam("b", ParamType::TGLfixed, 2).value.GLfixedVal,
                              params.getParam("t", ParamType::TGLfixed, 3).value.GLfixedVal,
                              params.getParam("n", ParamType::TGLfixed, 4).value.GLfixedVal,
                              params.getParam("f", ParamType::TGLfixed, 5).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLGenBuffers:
            context->genBuffers(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                replayContext->getReadBufferPointer<BufferID *>(params.getParam(
                                    "buffersPacked", ParamType::TBufferIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenFencesNV:
            context->genFencesNV(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getReadBufferPointer<FenceNVID *>(params.getParam(
                                     "fencesPacked", ParamType::TFenceNVIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenFramebuffers:
            context->genFramebuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<FramebufferID *>(
                    params.getParam("framebuffersPacked", ParamType::TFramebufferIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenProgramPipelines:
            context->genProgramPipelines(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<ProgramPipelineID *>(
                    params.getParam("pipelinesPacked", ParamType::TProgramPipelineIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenQueries:
            context->genQueries(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                replayContext->getReadBufferPointer<QueryID *>(
                                    params.getParam("idsPacked", ParamType::TQueryIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenRenderbuffers:
            context->genRenderbuffers(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<RenderbufferID *>(
                    params.getParam("renderbuffersPacked", ParamType::TRenderbufferIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenSamplers:
            context->genSamplers(params.getParam("count", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getReadBufferPointer<SamplerID *>(params.getParam(
                                     "samplersPacked", ParamType::TSamplerIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenTextures:
            context->genTextures(params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                                 replayContext->getReadBufferPointer<TextureID *>(params.getParam(
                                     "texturesPacked", ParamType::TTextureIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenTransformFeedbacks:
            context->genTransformFeedbacks(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<TransformFeedbackID *>(
                    params.getParam("idsPacked", ParamType::TTransformFeedbackIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenVertexArrays:
            context->genVertexArrays(
                params.getParam("n", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getReadBufferPointer<VertexArrayID *>(
                    params.getParam("arraysPacked", ParamType::TVertexArrayIDPointer, 1)));
            break;
        case angle::EntryPoint::GLGenerateMipmap:
            context->generateMipmap(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal);
            break;
        case angle::EntryPoint::GLGetActiveAttrib:
            context->getActiveAttrib(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("size", ParamType::TGLintPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("type", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 6)));
            break;
        case angle::EntryPoint::GLGetActiveUniform:
            context->getActiveUniform(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("size", ParamType::TGLintPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("type", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 6)));
            break;
        case angle::EntryPoint::GLGetActiveUniformBlockName:
            context->getActiveUniformBlockName(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformBlockIndexPacked", ParamType::TUniformBlockIndex, 1)
                    .value.UniformBlockIndexVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("uniformBlockName", ParamType::TGLcharPointer, 4)));
            break;
        case angle::EntryPoint::GLGetActiveUniformBlockiv:
            context->getActiveUniformBlockiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformBlockIndexPacked", ParamType::TUniformBlockIndex, 1)
                    .value.UniformBlockIndexVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case angle::EntryPoint::GLGetActiveUniformsiv:
            context->getActiveUniformsiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformCount", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("uniformIndices", ParamType::TGLuintConstPointer, 2)),
                params.getParam("pname", ParamType::TGLenum, 3).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 4)));
            break;
        case angle::EntryPoint::GLGetAttachedShaders:
            context->getAttachedShaders(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("maxCount", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("count", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<ShaderProgramID *>(
                    params.getParam("shadersPacked", ParamType::TShaderProgramIDPointer, 3)));
            break;
        case angle::EntryPoint::GLGetAttribLocation:
            context->getAttribLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case angle::EntryPoint::GLGetBooleani_v:
            context->getBooleani_v(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                                   replayContext->getReadBufferPointer<GLboolean *>(
                                       params.getParam("data", ParamType::TGLbooleanPointer, 2)));
            break;
        case angle::EntryPoint::GLGetBooleanv:
            context->getBooleanv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLboolean *>(
                                     params.getParam("data", ParamType::TGLbooleanPointer, 1)));
            break;
        case angle::EntryPoint::GLGetBufferParameteri64v:
            context->getBufferParameteri64v(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint64 *>(
                    params.getParam("params", ParamType::TGLint64Pointer, 2)));
            break;
        case angle::EntryPoint::GLGetBufferParameteriv:
            context->getBufferParameteriv(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetBufferPointerv:
            context->getBufferPointerv(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<void **>(
                    params.getParam("params", ParamType::TvoidPointerPointer, 2)));
            break;
        case angle::EntryPoint::GLGetClipPlanef:
            context->getClipPlanef(params.getParam("plane", ParamType::TGLenum, 0).value.GLenumVal,
                                   replayContext->getReadBufferPointer<GLfloat *>(
                                       params.getParam("equation", ParamType::TGLfloatPointer, 1)));
            break;
        case angle::EntryPoint::GLGetClipPlanex:
            context->getClipPlanex(params.getParam("plane", ParamType::TGLenum, 0).value.GLenumVal,
                                   replayContext->getReadBufferPointer<GLfixed *>(
                                       params.getParam("equation", ParamType::TGLfixedPointer, 1)));
            break;
        case angle::EntryPoint::GLGetCompressedTexImage:
            context->getCompressedTexImage(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                replayContext->getReadBufferPointer<void *>(
                    params.getParam("img", ParamType::TvoidPointer, 2)));
            break;
        case angle::EntryPoint::GLGetDebugMessageLog:
            context->getDebugMessageLog(
                params.getParam("count", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("sources", ParamType::TGLenumPointer, 2)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("types", ParamType::TGLenumPointer, 3)),
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("ids", ParamType::TGLuintPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("severities", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("lengths", ParamType::TGLsizeiPointer, 6)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("messageLog", ParamType::TGLcharPointer, 7)));
            break;
        case angle::EntryPoint::GLGetError:
            context->getError();
            break;
        case angle::EntryPoint::GLGetFenceivNV:
            context->getFenceivNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetFixedv:
            context->getFixedv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                               replayContext->getReadBufferPointer<GLfixed *>(
                                   params.getParam("params", ParamType::TGLfixedPointer, 1)));
            break;
        case angle::EntryPoint::GLGetFloatv:
            context->getFloatv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                               replayContext->getReadBufferPointer<GLfloat *>(
                                   params.getParam("data", ParamType::TGLfloatPointer, 1)));
            break;
        case angle::EntryPoint::GLGetFragDataIndex:
            context->getFragDataIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case angle::EntryPoint::GLGetFragDataLocation:
            context->getFragDataLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case angle::EntryPoint::GLGetFramebufferAttachmentParameteriv:
            context->getFramebufferAttachmentParameteriv(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("attachment", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case angle::EntryPoint::GLGetFramebufferParameteriv:
            context->getFramebufferParameteriv(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetFramebufferParameterivMESA:
            context->getFramebufferParameterivMESA(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetGraphicsResetStatus:
            context->getGraphicsResetStatus();
            break;
        case angle::EntryPoint::GLGetInteger64i_v:
            context->getInteger64i_v(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getReadBufferPointer<GLint64 *>(
                    params.getParam("data", ParamType::TGLint64Pointer, 2)));
            break;
        case angle::EntryPoint::GLGetInteger64v:
            context->getInteger64v(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                   replayContext->getReadBufferPointer<GLint64 *>(
                                       params.getParam("data", ParamType::TGLint64Pointer, 1)));
            break;
        case angle::EntryPoint::GLGetIntegeri_v:
            context->getIntegeri_v(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                                   replayContext->getReadBufferPointer<GLint *>(
                                       params.getParam("data", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetIntegerv:
            context->getIntegerv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("data", ParamType::TGLintPointer, 1)));
            break;
        case angle::EntryPoint::GLGetInternalformativ:
            context->getInternalformativ(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("internalformat", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("bufSize", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 4)));
            break;
        case angle::EntryPoint::GLGetLightfv:
            context->getLightfv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                    .value.LightParameterVal,
                                replayContext->getReadBufferPointer<GLfloat *>(
                                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetLightxv:
            context->getLightxv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                    .value.LightParameterVal,
                                replayContext->getReadBufferPointer<GLfixed *>(
                                    params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case angle::EntryPoint::GLGetMaterialfv:
            context->getMaterialfv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                       .value.MaterialParameterVal,
                                   replayContext->getReadBufferPointer<GLfloat *>(
                                       params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetMaterialxv:
            context->getMaterialxv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                   params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                       .value.MaterialParameterVal,
                                   replayContext->getReadBufferPointer<GLfixed *>(
                                       params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case angle::EntryPoint::GLGetMultisamplefv:
            context->getMultisamplefv(
                params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("val", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetObjectLabel:
            context->getObjectLabel(
                params.getParam("identifier", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("name", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("label", ParamType::TGLcharPointer, 4)));
            break;
        case angle::EntryPoint::GLGetObjectPtrLabel:
            context->getObjectPtrLabel(
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("ptr", ParamType::TvoidConstPointer, 0)),
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("label", ParamType::TGLcharPointer, 3)));
            break;
        case angle::EntryPoint::GLGetPointerv:
            context->getPointerv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 replayContext->getReadBufferPointer<void **>(
                                     params.getParam("params", ParamType::TvoidPointerPointer, 1)));
            break;
        case angle::EntryPoint::GLGetProgramBinary:
            context->getProgramBinary(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("binaryFormat", ParamType::TGLenumPointer, 3)),
                replayContext->getReadBufferPointer<void *>(
                    params.getParam("binary", ParamType::TvoidPointer, 4)));
            break;
        case angle::EntryPoint::GLGetProgramInfoLog:
            context->getProgramInfoLog(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("infoLog", ParamType::TGLcharPointer, 3)));
            break;
        case angle::EntryPoint::GLGetProgramInterfaceiv:
            context->getProgramInterfaceiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case angle::EntryPoint::GLGetProgramPipelineInfoLog:
            context->getProgramPipelineInfoLog(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("infoLog", ParamType::TGLcharPointer, 3)));
            break;
        case angle::EntryPoint::GLGetProgramPipelineiv:
            context->getProgramPipelineiv(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetProgramResourceIndex:
            context->getProgramResourceIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case angle::EntryPoint::GLGetProgramResourceLocation:
            context->getProgramResourceLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case angle::EntryPoint::GLGetProgramResourceLocationIndex:
            context->getProgramResourceLocationIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 2)));
            break;
        case angle::EntryPoint::GLGetProgramResourceName:
            context->getProgramResourceName(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 4)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 5)));
            break;
        case angle::EntryPoint::GLGetProgramResourceiv:
            context->getProgramResourceiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("programInterface", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("index", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("propCount", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLenum *>(
                    params.getParam("props", ParamType::TGLenumConstPointer, 4)),
                params.getParam("bufSize", ParamType::TGLsizei, 5).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 6)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 7)));
            break;
        case angle::EntryPoint::GLGetProgramiv:
            context->getProgramiv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                  replayContext->getReadBufferPointer<GLint *>(
                                      params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetQueryObjecti64v:
            context->getQueryObjecti64v(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint64 *>(
                    params.getParam("params", ParamType::TGLint64Pointer, 2)));
            break;
        case angle::EntryPoint::GLGetQueryObjectiv:
            context->getQueryObjectiv(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetQueryObjectui64v:
            context->getQueryObjectui64v(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint64 *>(
                    params.getParam("params", ParamType::TGLuint64Pointer, 2)));
            break;
        case angle::EntryPoint::GLGetQueryObjectuiv:
            context->getQueryObjectuiv(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetQueryiv:
            context->getQueryiv(
                params.getParam("targetPacked", ParamType::TQueryType, 0).value.QueryTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetRenderbufferParameteriv:
            context->getRenderbufferParameteriv(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetSamplerParameterIiv:
            context->getSamplerParameterIiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetSamplerParameterIuiv:
            context->getSamplerParameterIuiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetSamplerParameterfv:
            context->getSamplerParameterfv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetSamplerParameteriv:
            context->getSamplerParameteriv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetShaderInfoLog:
            context->getShaderInfoLog(
                params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("infoLog", ParamType::TGLcharPointer, 3)));
            break;
        case angle::EntryPoint::GLGetShaderPrecisionFormat:
            context->getShaderPrecisionFormat(
                params.getParam("shadertype", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("precisiontype", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("range", ParamType::TGLintPointer, 2)),
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("precision", ParamType::TGLintPointer, 3)));
            break;
        case angle::EntryPoint::GLGetShaderSource:
            context->getShaderSource(
                params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("bufSize", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 2)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("source", ParamType::TGLcharPointer, 3)));
            break;
        case angle::EntryPoint::GLGetShaderiv:
            context->getShaderiv(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                     .value.ShaderProgramIDVal,
                                 params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetString:
            context->getString(params.getParam("name", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLGetStringi:
            context->getStringi(params.getParam("name", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLGetSynciv:
            context->getSynciv(params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal,
                               params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                               params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                               replayContext->getReadBufferPointer<GLsizei *>(
                                   params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                               replayContext->getReadBufferPointer<GLint *>(
                                   params.getParam("values", ParamType::TGLintPointer, 4)));
            break;
        case angle::EntryPoint::GLGetTexEnvfv:
            context->getTexEnvfv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                     .value.TextureEnvTargetVal,
                                 params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                     .value.TextureEnvParameterVal,
                                 replayContext->getReadBufferPointer<GLfloat *>(
                                     params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexEnviv:
            context->getTexEnviv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                     .value.TextureEnvTargetVal,
                                 params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                     .value.TextureEnvParameterVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexEnvxv:
            context->getTexEnvxv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                     .value.TextureEnvTargetVal,
                                 params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                     .value.TextureEnvParameterVal,
                                 replayContext->getReadBufferPointer<GLfixed *>(
                                     params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexGenfv:
            context->getTexGenfv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLfloat *>(
                                     params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexGeniv:
            context->getTexGeniv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                                 replayContext->getReadBufferPointer<GLint *>(
                                     params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexImage:
            context->getTexImage(params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                                     .value.TextureTargetVal,
                                 params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                                 params.getParam("format", ParamType::TGLenum, 2).value.GLenumVal,
                                 params.getParam("type", ParamType::TGLenum, 3).value.GLenumVal,
                                 replayContext->getReadBufferPointer<void *>(
                                     params.getParam("pixels", ParamType::TvoidPointer, 4)));
            break;
        case angle::EntryPoint::GLGetTexLevelParameterfv:
            context->getTexLevelParameterfv(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 3)));
            break;
        case angle::EntryPoint::GLGetTexLevelParameteriv:
            context->getTexLevelParameteriv(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("pname", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case angle::EntryPoint::GLGetTexParameterIiv:
            context->getTexParameterIiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexParameterIuiv:
            context->getTexParameterIuiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexParameterfv:
            context->getTexParameterfv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexParameteriv:
            context->getTexParameteriv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTexParameterxv:
            context->getTexParameterxv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfixed *>(
                    params.getParam("params", ParamType::TGLfixedPointer, 2)));
            break;
        case angle::EntryPoint::GLGetTransformFeedbackVarying:
            context->getTransformFeedbackVarying(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("length", ParamType::TGLsizeiPointer, 3)),
                replayContext->getReadBufferPointer<GLsizei *>(
                    params.getParam("size", ParamType::TGLsizeiPointer, 4)),
                replayContext->getReadBufferPointer<GLenum *>(
                    params.getParam("type", ParamType::TGLenumPointer, 5)),
                replayContext->getReadBufferPointer<GLchar *>(
                    params.getParam("name", ParamType::TGLcharPointer, 6)));
            break;
        case angle::EntryPoint::GLGetUniformBlockIndex:
            context->getUniformBlockIndex(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("uniformBlockName", ParamType::TGLcharConstPointer, 1)));
            break;
        case angle::EntryPoint::GLGetUniformIndices:
            context->getUniformIndices(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformCount", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("uniformNames", ParamType::TGLcharConstPointerPointer, 2)),
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("uniformIndices", ParamType::TGLuintPointer, 3)));
            break;
        case angle::EntryPoint::GLGetUniformLocation:
            context->getUniformLocation(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("name", ParamType::TGLcharConstPointer, 1)));
            break;
        case angle::EntryPoint::GLGetUniformfv:
            context->getUniformfv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                                      .value.UniformLocationVal,
                                  replayContext->getReadBufferPointer<GLfloat *>(
                                      params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetUniformiv:
            context->getUniformiv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                      .value.ShaderProgramIDVal,
                                  params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                                      .value.UniformLocationVal,
                                  replayContext->getReadBufferPointer<GLint *>(
                                      params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetUniformuiv:
            context->getUniformuiv(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                       .value.ShaderProgramIDVal,
                                   params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                                       .value.UniformLocationVal,
                                   replayContext->getReadBufferPointer<GLuint *>(
                                       params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetVertexAttribIiv:
            context->getVertexAttribIiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetVertexAttribIuiv:
            context->getVertexAttribIuiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetVertexAttribPointerv:
            context->getVertexAttribPointerv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<void **>(
                    params.getParam("pointer", ParamType::TvoidPointerPointer, 2)));
            break;
        case angle::EntryPoint::GLGetVertexAttribfv:
            context->getVertexAttribfv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 2)));
            break;
        case angle::EntryPoint::GLGetVertexAttribiv:
            context->getVertexAttribiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 2)));
            break;
        case angle::EntryPoint::GLGetnUniformfv:
            context->getnUniformfv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatPointer, 3)));
            break;
        case angle::EntryPoint::GLGetnUniformiv:
            context->getnUniformiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLint *>(
                    params.getParam("params", ParamType::TGLintPointer, 3)));
            break;
        case angle::EntryPoint::GLGetnUniformuiv:
            context->getnUniformuiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("bufSize", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getReadBufferPointer<GLuint *>(
                    params.getParam("params", ParamType::TGLuintPointer, 3)));
            break;
        case angle::EntryPoint::GLHint:
            context->hint(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                          params.getParam("mode", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case angle::EntryPoint::GLInvalidateFramebuffer:
            context->invalidateFramebuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("numAttachments", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLenum *>(
                    params.getParam("attachments", ParamType::TGLenumConstPointer, 2)));
            break;
        case angle::EntryPoint::GLInvalidateSubFramebuffer:
            context->invalidateSubFramebuffer(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("numAttachments", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLenum *>(
                    params.getParam("attachments", ParamType::TGLenumConstPointer, 2)),
                params.getParam("x", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLIsBuffer:
            context->isBuffer(
                params.getParam("bufferPacked", ParamType::TBufferID, 0).value.BufferIDVal);
            break;
        case angle::EntryPoint::GLIsEnabled:
            context->isEnabled(params.getParam("cap", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLIsEnabledi:
            context->isEnabledi(params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("index", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLIsFenceNV:
            context->isFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal);
            break;
        case angle::EntryPoint::GLIsFramebuffer:
            context->isFramebuffer(
                params.getParam("framebufferPacked", ParamType::TFramebufferID, 0)
                    .value.FramebufferIDVal);
            break;
        case angle::EntryPoint::GLIsProgram:
            context->isProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                   .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLIsProgramPipeline:
            context->isProgramPipeline(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal);
            break;
        case angle::EntryPoint::GLIsQuery:
            context->isQuery(params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal);
            break;
        case angle::EntryPoint::GLIsRenderbuffer:
            context->isRenderbuffer(
                params.getParam("renderbufferPacked", ParamType::TRenderbufferID, 0)
                    .value.RenderbufferIDVal);
            break;
        case angle::EntryPoint::GLIsSampler:
            context->isSampler(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal);
            break;
        case angle::EntryPoint::GLIsShader:
            context->isShader(params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                                  .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLIsSync:
            context->isSync(params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal);
            break;
        case angle::EntryPoint::GLIsTexture:
            context->isTexture(
                params.getParam("texturePacked", ParamType::TTextureID, 0).value.TextureIDVal);
            break;
        case angle::EntryPoint::GLIsTransformFeedback:
            context->isTransformFeedback(
                params.getParam("idPacked", ParamType::TTransformFeedbackID, 0)
                    .value.TransformFeedbackIDVal);
            break;
        case angle::EntryPoint::GLIsVertexArray:
            context->isVertexArray(params.getParam("arrayPacked", ParamType::TVertexArrayID, 0)
                                       .value.VertexArrayIDVal);
            break;
        case angle::EntryPoint::GLLightModelf:
            context->lightModelf(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("param", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLLightModelfv:
            context->lightModelfv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                  replayContext->getAsConstPointer<const GLfloat *>(params.getParam(
                                      "params", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLLightModelx:
            context->lightModelx(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("param", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLLightModelxv:
            context->lightModelxv(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                  replayContext->getAsConstPointer<const GLfixed *>(params.getParam(
                                      "param", ParamType::TGLfixedConstPointer, 1)));
            break;
        case angle::EntryPoint::GLLightf:
            context->lightf(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                            params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                .value.LightParameterVal,
                            params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLLightfv:
            context->lightfv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                 .value.LightParameterVal,
                             replayContext->getAsConstPointer<const GLfloat *>(
                                 params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLLightx:
            context->lightx(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                            params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                .value.LightParameterVal,
                            params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLLightxv:
            context->lightxv(params.getParam("light", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pnamePacked", ParamType::TLightParameter, 1)
                                 .value.LightParameterVal,
                             replayContext->getAsConstPointer<const GLfixed *>(
                                 params.getParam("params", ParamType::TGLfixedConstPointer, 2)));
            break;
        case angle::EntryPoint::GLLineWidth:
            context->lineWidth(params.getParam("width", ParamType::TGLfloat, 0).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLLineWidthx:
            context->lineWidthx(params.getParam("width", ParamType::TGLfixed, 0).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLLinkProgram:
            context->linkProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                     .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLLoadIdentity:
            context->loadIdentity();
            break;
        case angle::EntryPoint::GLLoadMatrixf:
            context->loadMatrixf(replayContext->getAsConstPointer<const GLfloat *>(
                params.getParam("m", ParamType::TGLfloatConstPointer, 0)));
            break;
        case angle::EntryPoint::GLLoadMatrixx:
            context->loadMatrixx(replayContext->getAsConstPointer<const GLfixed *>(
                params.getParam("m", ParamType::TGLfixedConstPointer, 0)));
            break;
        case angle::EntryPoint::GLLogicOp:
            context->logicOp(params.getParam("opcodePacked", ParamType::TLogicalOperation, 0)
                                 .value.LogicalOperationVal);
            break;
        case angle::EntryPoint::GLMapBuffer:
            context->mapBuffer(params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                                   .value.BufferBindingVal,
                               params.getParam("access", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case angle::EntryPoint::GLMapBufferRange:
            context->mapBufferRange(
                params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                    .value.BufferBindingVal,
                params.getParam("offset", ParamType::TGLintptr, 1).value.GLintptrVal,
                params.getParam("length", ParamType::TGLsizeiptr, 2).value.GLsizeiptrVal,
                params.getParam("access", ParamType::TGLbitfield, 3).value.GLbitfieldVal);
            break;
        case angle::EntryPoint::GLMaterialf:
            context->materialf(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                   .value.MaterialParameterVal,
                               params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLMaterialfv:
            context->materialfv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                    .value.MaterialParameterVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLMaterialx:
            context->materialx(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                   .value.MaterialParameterVal,
                               params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLMaterialxv:
            context->materialxv(params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                                params.getParam("pnamePacked", ParamType::TMaterialParameter, 1)
                                    .value.MaterialParameterVal,
                                replayContext->getAsConstPointer<const GLfixed *>(
                                    params.getParam("param", ParamType::TGLfixedConstPointer, 2)));
            break;
        case angle::EntryPoint::GLMatrixMode:
            context->matrixMode(
                params.getParam("modePacked", ParamType::TMatrixType, 0).value.MatrixTypeVal);
            break;
        case angle::EntryPoint::GLMemoryBarrier:
            context->memoryBarrier(
                params.getParam("barriers", ParamType::TGLbitfield, 0).value.GLbitfieldVal);
            break;
        case angle::EntryPoint::GLMemoryBarrierByRegion:
            context->memoryBarrierByRegion(
                params.getParam("barriers", ParamType::TGLbitfield, 0).value.GLbitfieldVal);
            break;
        case angle::EntryPoint::GLMinSampleShading:
            context->minSampleShading(
                params.getParam("value", ParamType::TGLfloat, 0).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLMultMatrixf:
            context->multMatrixf(replayContext->getAsConstPointer<const GLfloat *>(
                params.getParam("m", ParamType::TGLfloatConstPointer, 0)));
            break;
        case angle::EntryPoint::GLMultMatrixx:
            context->multMatrixx(replayContext->getAsConstPointer<const GLfixed *>(
                params.getParam("m", ParamType::TGLfixedConstPointer, 0)));
            break;
        case angle::EntryPoint::GLMultiDrawArrays:
            context->multiDrawArrays(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("first", ParamType::TGLintConstPointer, 1)),
                replayContext->getAsConstPointer<const GLsizei *>(
                    params.getParam("count", ParamType::TGLsizeiConstPointer, 2)),
                params.getParam("drawcount", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLMultiDrawArraysIndirect:
            context->multiDrawArraysIndirect(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indirect", ParamType::TvoidConstPointer, 1)),
                params.getParam("drawcount", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("stride", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLMultiDrawElements:
            context->multiDrawElements(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const GLsizei *>(
                    params.getParam("count", ParamType::TGLsizeiConstPointer, 1)),
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsPointerConstPointer<const void *const *>(
                    params.getParam("indices", ParamType::TvoidConstPointerPointer, 3)),
                params.getParam("drawcount", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLMultiDrawElementsBaseVertex:
            context->multiDrawElementsBaseVertex(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                replayContext->getAsConstPointer<const GLsizei *>(
                    params.getParam("count", ParamType::TGLsizeiConstPointer, 1)),
                params.getParam("typePacked", ParamType::TDrawElementsType, 2)
                    .value.DrawElementsTypeVal,
                replayContext->getAsPointerConstPointer<const void *const *>(
                    params.getParam("indices", ParamType::TvoidConstPointerPointer, 3)),
                params.getParam("drawcount", ParamType::TGLsizei, 4).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("basevertex", ParamType::TGLintConstPointer, 5)));
            break;
        case angle::EntryPoint::GLMultiDrawElementsIndirect:
            context->multiDrawElementsIndirect(
                params.getParam("modePacked", ParamType::TPrimitiveMode, 0).value.PrimitiveModeVal,
                params.getParam("typePacked", ParamType::TDrawElementsType, 1)
                    .value.DrawElementsTypeVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("indirect", ParamType::TvoidConstPointer, 2)),
                params.getParam("drawcount", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("stride", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLMultiTexCoord4f:
            context->multiTexCoord4f(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("s", ParamType::TGLfloat, 1).value.GLfloatVal,
                params.getParam("t", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("r", ParamType::TGLfloat, 3).value.GLfloatVal,
                params.getParam("q", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLMultiTexCoord4x:
            context->multiTexCoord4x(
                params.getParam("texture", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("s", ParamType::TGLfixed, 1).value.GLfixedVal,
                params.getParam("t", ParamType::TGLfixed, 2).value.GLfixedVal,
                params.getParam("r", ParamType::TGLfixed, 3).value.GLfixedVal,
                params.getParam("q", ParamType::TGLfixed, 4).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLNormal3f:
            context->normal3f(params.getParam("nx", ParamType::TGLfloat, 0).value.GLfloatVal,
                              params.getParam("ny", ParamType::TGLfloat, 1).value.GLfloatVal,
                              params.getParam("nz", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLNormal3x:
            context->normal3x(params.getParam("nx", ParamType::TGLfixed, 0).value.GLfixedVal,
                              params.getParam("ny", ParamType::TGLfixed, 1).value.GLfixedVal,
                              params.getParam("nz", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLNormalPointer:
            context->normalPointer(
                params.getParam("typePacked", ParamType::TVertexAttribType, 0)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 2)));
            break;
        case angle::EntryPoint::GLObjectLabel:
            context->objectLabel(
                params.getParam("identifier", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("name", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("length", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("label", ParamType::TGLcharConstPointer, 3)));
            break;
        case angle::EntryPoint::GLObjectPtrLabel:
            context->objectPtrLabel(
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("ptr", ParamType::TvoidConstPointer, 0)),
                params.getParam("length", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("label", ParamType::TGLcharConstPointer, 2)));
            break;
        case angle::EntryPoint::GLOrthof:
            context->orthof(params.getParam("l", ParamType::TGLfloat, 0).value.GLfloatVal,
                            params.getParam("r", ParamType::TGLfloat, 1).value.GLfloatVal,
                            params.getParam("b", ParamType::TGLfloat, 2).value.GLfloatVal,
                            params.getParam("t", ParamType::TGLfloat, 3).value.GLfloatVal,
                            params.getParam("n", ParamType::TGLfloat, 4).value.GLfloatVal,
                            params.getParam("f", ParamType::TGLfloat, 5).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLOrthox:
            context->orthox(params.getParam("l", ParamType::TGLfixed, 0).value.GLfixedVal,
                            params.getParam("r", ParamType::TGLfixed, 1).value.GLfixedVal,
                            params.getParam("b", ParamType::TGLfixed, 2).value.GLfixedVal,
                            params.getParam("t", ParamType::TGLfixed, 3).value.GLfixedVal,
                            params.getParam("n", ParamType::TGLfixed, 4).value.GLfixedVal,
                            params.getParam("f", ParamType::TGLfixed, 5).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLPatchParameteri:
            context->patchParameteri(
                params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("value", ParamType::TGLint, 1).value.GLintVal);
            break;
        case angle::EntryPoint::GLPauseTransformFeedback:
            context->pauseTransformFeedback();
            break;
        case angle::EntryPoint::GLPixelStorei:
            context->pixelStorei(params.getParam("pname", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("param", ParamType::TGLint, 1).value.GLintVal);
            break;
        case angle::EntryPoint::GLPointParameterf:
            context->pointParameterf(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                params.getParam("param", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLPointParameterfv:
            context->pointParameterfv(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLPointParameterx:
            context->pointParameterx(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                params.getParam("param", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLPointParameterxv:
            context->pointParameterxv(
                params.getParam("pnamePacked", ParamType::TPointParameter, 0)
                    .value.PointParameterVal,
                replayContext->getAsConstPointer<const GLfixed *>(
                    params.getParam("params", ParamType::TGLfixedConstPointer, 1)));
            break;
        case angle::EntryPoint::GLPointSize:
            context->pointSize(params.getParam("size", ParamType::TGLfloat, 0).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLPointSizex:
            context->pointSizex(params.getParam("size", ParamType::TGLfixed, 0).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLPolygonOffset:
            context->polygonOffset(
                params.getParam("factor", ParamType::TGLfloat, 0).value.GLfloatVal,
                params.getParam("units", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLPolygonOffsetx:
            context->polygonOffsetx(
                params.getParam("factor", ParamType::TGLfixed, 0).value.GLfixedVal,
                params.getParam("units", ParamType::TGLfixed, 1).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLPopDebugGroup:
            context->popDebugGroup();
            break;
        case angle::EntryPoint::GLPopMatrix:
            context->popMatrix();
            break;
        case angle::EntryPoint::GLPrimitiveBoundingBox:
            context->primitiveBoundingBox(
                params.getParam("minX", ParamType::TGLfloat, 0).value.GLfloatVal,
                params.getParam("minY", ParamType::TGLfloat, 1).value.GLfloatVal,
                params.getParam("minZ", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("minW", ParamType::TGLfloat, 3).value.GLfloatVal,
                params.getParam("maxX", ParamType::TGLfloat, 4).value.GLfloatVal,
                params.getParam("maxY", ParamType::TGLfloat, 5).value.GLfloatVal,
                params.getParam("maxZ", ParamType::TGLfloat, 6).value.GLfloatVal,
                params.getParam("maxW", ParamType::TGLfloat, 7).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLProgramBinary:
            context->programBinary(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("binaryFormat", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("binary", ParamType::TvoidConstPointer, 2)),
                params.getParam("length", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLProgramParameteri:
            context->programParameteri(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("value", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLProgramUniform1f:
            context->programUniform1f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLProgramUniform1fv:
            context->programUniform1fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform1i:
            context->programUniform1i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLProgramUniform1iv:
            context->programUniform1iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform1ui:
            context->programUniform1ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case angle::EntryPoint::GLProgramUniform1uiv:
            context->programUniform1uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform2f:
            context->programUniform2f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("v1", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLProgramUniform2fv:
            context->programUniform2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform2i:
            context->programUniform2i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("v1", ParamType::TGLint, 3).value.GLintVal);
            break;
        case angle::EntryPoint::GLProgramUniform2iv:
            context->programUniform2iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform2ui:
            context->programUniform2ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("v1", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case angle::EntryPoint::GLProgramUniform2uiv:
            context->programUniform2uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform3f:
            context->programUniform3f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("v1", ParamType::TGLfloat, 3).value.GLfloatVal,
                params.getParam("v2", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLProgramUniform3fv:
            context->programUniform3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform3i:
            context->programUniform3i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("v1", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("v2", ParamType::TGLint, 4).value.GLintVal);
            break;
        case angle::EntryPoint::GLProgramUniform3iv:
            context->programUniform3iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform3ui:
            context->programUniform3ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("v1", ParamType::TGLuint, 3).value.GLuintVal,
                params.getParam("v2", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case angle::EntryPoint::GLProgramUniform3uiv:
            context->programUniform3uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform4f:
            context->programUniform4f(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLfloat, 2).value.GLfloatVal,
                params.getParam("v1", ParamType::TGLfloat, 3).value.GLfloatVal,
                params.getParam("v2", ParamType::TGLfloat, 4).value.GLfloatVal,
                params.getParam("v3", ParamType::TGLfloat, 5).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLProgramUniform4fv:
            context->programUniform4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform4i:
            context->programUniform4i(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("v1", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("v2", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("v3", ParamType::TGLint, 5).value.GLintVal);
            break;
        case angle::EntryPoint::GLProgramUniform4iv:
            context->programUniform4iv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("value", ParamType::TGLintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniform4ui:
            context->programUniform4ui(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("v0", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("v1", ParamType::TGLuint, 3).value.GLuintVal,
                params.getParam("v2", ParamType::TGLuint, 4).value.GLuintVal,
                params.getParam("v3", ParamType::TGLuint, 5).value.GLuintVal);
            break;
        case angle::EntryPoint::GLProgramUniform4uiv:
            context->programUniform4uiv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("value", ParamType::TGLuintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix2fv:
            context->programUniformMatrix2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix2x3fv:
            context->programUniformMatrix2x3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix2x4fv:
            context->programUniformMatrix2x4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix3fv:
            context->programUniformMatrix3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix3x2fv:
            context->programUniformMatrix3x2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix3x4fv:
            context->programUniformMatrix3x4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix4fv:
            context->programUniformMatrix4fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix4x2fv:
            context->programUniformMatrix4x2fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProgramUniformMatrix4x3fv:
            context->programUniformMatrix4x3fv(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("locationPacked", ParamType::TUniformLocation, 1)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 3).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 4)));
            break;
        case angle::EntryPoint::GLProvokingVertex:
            context->provokingVertex(
                params.getParam("modePacked", ParamType::TProvokingVertexConvention, 0)
                    .value.ProvokingVertexConventionVal);
            break;
        case angle::EntryPoint::GLPushDebugGroup:
            context->pushDebugGroup(
                params.getParam("source", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("id", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("length", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const GLchar *>(
                    params.getParam("message", ParamType::TGLcharConstPointer, 3)));
            break;
        case angle::EntryPoint::GLPushMatrix:
            context->pushMatrix();
            break;
        case angle::EntryPoint::GLQueryCounter:
            context->queryCounter(
                params.getParam("idPacked", ParamType::TQueryID, 0).value.QueryIDVal,
                params.getParam("targetPacked", ParamType::TQueryType, 1).value.QueryTypeVal);
            break;
        case angle::EntryPoint::GLReadBuffer:
            context->readBuffer(params.getParam("src", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLReadPixels:
            context->readPixels(params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                                params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                                params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                                params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal,
                                params.getParam("format", ParamType::TGLenum, 4).value.GLenumVal,
                                params.getParam("type", ParamType::TGLenum, 5).value.GLenumVal,
                                replayContext->getReadBufferPointer<void *>(
                                    params.getParam("pixels", ParamType::TvoidPointer, 6)));
            break;
        case angle::EntryPoint::GLReadnPixels:
            context->readnPixels(
                params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 4).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 5).value.GLenumVal,
                params.getParam("bufSize", ParamType::TGLsizei, 6).value.GLsizeiVal,
                replayContext->getReadBufferPointer<void *>(
                    params.getParam("data", ParamType::TvoidPointer, 7)));
            break;
        case angle::EntryPoint::GLReleaseShaderCompiler:
            context->releaseShaderCompiler();
            break;
        case angle::EntryPoint::GLRenderbufferStorage:
            context->renderbufferStorage(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("internalformat", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLRenderbufferStorageMultisample:
            context->renderbufferStorageMultisample(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("samples", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLRenderbufferStorageMultisampleEXT:
            context->renderbufferStorageMultisampleEXT(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("samples", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLResumeTransformFeedback:
            context->resumeTransformFeedback();
            break;
        case angle::EntryPoint::GLRotatef:
            context->rotatef(params.getParam("angle", ParamType::TGLfloat, 0).value.GLfloatVal,
                             params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                             params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal,
                             params.getParam("z", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLRotatex:
            context->rotatex(params.getParam("angle", ParamType::TGLfixed, 0).value.GLfixedVal,
                             params.getParam("x", ParamType::TGLfixed, 1).value.GLfixedVal,
                             params.getParam("y", ParamType::TGLfixed, 2).value.GLfixedVal,
                             params.getParam("z", ParamType::TGLfixed, 3).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLSampleCoverage:
            context->sampleCoverage(
                params.getParam("value", ParamType::TGLfloat, 0).value.GLfloatVal,
                params.getParam("invert", ParamType::TGLboolean, 1).value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLSampleCoveragex:
            context->sampleCoveragex(
                params.getParam("value", ParamType::TGLclampx, 0).value.GLclampxVal,
                params.getParam("invert", ParamType::TGLboolean, 1).value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLSampleMaski:
            context->sampleMaski(
                params.getParam("maskNumber", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("mask", ParamType::TGLbitfield, 1).value.GLbitfieldVal);
            break;
        case angle::EntryPoint::GLSamplerParameterIiv:
            context->samplerParameterIiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("param", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLSamplerParameterIuiv:
            context->samplerParameterIuiv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("param", ParamType::TGLuintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLSamplerParameterf:
            context->samplerParameterf(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLSamplerParameterfv:
            context->samplerParameterfv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("param", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLSamplerParameteri:
            context->samplerParameteri(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLSamplerParameteriv:
            context->samplerParameteriv(
                params.getParam("samplerPacked", ParamType::TSamplerID, 0).value.SamplerIDVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("param", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLScalef:
            context->scalef(params.getParam("x", ParamType::TGLfloat, 0).value.GLfloatVal,
                            params.getParam("y", ParamType::TGLfloat, 1).value.GLfloatVal,
                            params.getParam("z", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLScalex:
            context->scalex(params.getParam("x", ParamType::TGLfixed, 0).value.GLfixedVal,
                            params.getParam("y", ParamType::TGLfixed, 1).value.GLfixedVal,
                            params.getParam("z", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLScissor:
            context->scissor(params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                             params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                             params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                             params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLSetFenceNV:
            context->setFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal,
                params.getParam("condition", ParamType::TGLenum, 1).value.GLenumVal);
            break;
        case angle::EntryPoint::GLShadeModel:
            context->shadeModel(
                params.getParam("modePacked", ParamType::TShadingModel, 0).value.ShadingModelVal);
            break;
        case angle::EntryPoint::GLShaderBinary:
            context->shaderBinary(
                params.getParam("count", ParamType::TGLsizei, 0).value.GLsizeiVal,
                replayContext->getAsConstPointer<const ShaderProgramID *>(
                    params.getParam("shadersPacked", ParamType::TShaderProgramIDConstPointer, 1)),
                params.getParam("binaryformat", ParamType::TGLenum, 2).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("binary", ParamType::TvoidConstPointer, 3)),
                params.getParam("length", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLShaderSource:
            context->shaderSource(
                params.getParam("shaderPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("string", ParamType::TGLcharConstPointerPointer, 2)),
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("length", ParamType::TGLintConstPointer, 3)));
            break;
        case angle::EntryPoint::GLShadingRateQCOM:
            context->shadingRateQCOM(
                params.getParam("rate", ParamType::TGLenum, 0).value.GLenumVal);
            break;
        case angle::EntryPoint::GLStencilFunc:
            context->stencilFunc(params.getParam("func", ParamType::TGLenum, 0).value.GLenumVal,
                                 params.getParam("ref", ParamType::TGLint, 1).value.GLintVal,
                                 params.getParam("mask", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case angle::EntryPoint::GLStencilFuncSeparate:
            context->stencilFuncSeparate(
                params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("func", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("ref", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("mask", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case angle::EntryPoint::GLStencilMask:
            context->stencilMask(params.getParam("mask", ParamType::TGLuint, 0).value.GLuintVal);
            break;
        case angle::EntryPoint::GLStencilMaskSeparate:
            context->stencilMaskSeparate(
                params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("mask", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLStencilOp:
            context->stencilOp(params.getParam("fail", ParamType::TGLenum, 0).value.GLenumVal,
                               params.getParam("zfail", ParamType::TGLenum, 1).value.GLenumVal,
                               params.getParam("zpass", ParamType::TGLenum, 2).value.GLenumVal);
            break;
        case angle::EntryPoint::GLStencilOpSeparate:
            context->stencilOpSeparate(
                params.getParam("face", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("sfail", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("dpfail", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("dppass", ParamType::TGLenum, 3).value.GLenumVal);
            break;
        case angle::EntryPoint::GLTestFenceNV:
            context->testFenceNV(
                params.getParam("fencePacked", ParamType::TFenceNVID, 0).value.FenceNVIDVal);
            break;
        case angle::EntryPoint::GLTexBuffer:
            context->texBuffer(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("internalformat", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 2).value.BufferIDVal);
            break;
        case angle::EntryPoint::GLTexBufferRange:
            context->texBufferRange(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("internalformat", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("bufferPacked", ParamType::TBufferID, 2).value.BufferIDVal,
                params.getParam("offset", ParamType::TGLintptr, 3).value.GLintptrVal,
                params.getParam("size", ParamType::TGLsizeiptr, 4).value.GLsizeiptrVal);
            break;
        case angle::EntryPoint::GLTexCoordPointer:
            context->texCoordPointer(
                params.getParam("size", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 1)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 3)));
            break;
        case angle::EntryPoint::GLTexEnvf:
            context->texEnvf(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                 .value.TextureEnvTargetVal,
                             params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                 .value.TextureEnvParameterVal,
                             params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLTexEnvfv:
            context->texEnvfv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                  .value.TextureEnvTargetVal,
                              params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                  .value.TextureEnvParameterVal,
                              replayContext->getAsConstPointer<const GLfloat *>(
                                  params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexEnvi:
            context->texEnvi(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                 .value.TextureEnvTargetVal,
                             params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                 .value.TextureEnvParameterVal,
                             params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLTexEnviv:
            context->texEnviv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                  .value.TextureEnvTargetVal,
                              params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                  .value.TextureEnvParameterVal,
                              replayContext->getAsConstPointer<const GLint *>(
                                  params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexEnvx:
            context->texEnvx(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                 .value.TextureEnvTargetVal,
                             params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                 .value.TextureEnvParameterVal,
                             params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLTexEnvxv:
            context->texEnvxv(params.getParam("targetPacked", ParamType::TTextureEnvTarget, 0)
                                  .value.TextureEnvTargetVal,
                              params.getParam("pnamePacked", ParamType::TTextureEnvParameter, 1)
                                  .value.TextureEnvParameterVal,
                              replayContext->getAsConstPointer<const GLfixed *>(
                                  params.getParam("params", ParamType::TGLfixedConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexGenf:
            context->texGenf(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                             params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLTexGenfv:
            context->texGenfv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                              params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                              replayContext->getAsConstPointer<const GLfloat *>(
                                  params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexGeni:
            context->texGeni(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                             params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                             params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLTexGeniv:
            context->texGeniv(params.getParam("coord", ParamType::TGLenum, 0).value.GLenumVal,
                              params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                              replayContext->getAsConstPointer<const GLint *>(
                                  params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexImage2D:
            context->texImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 5).value.GLintVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 7).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 8)));
            break;
        case angle::EntryPoint::GLTexImage3D:
            context->texImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("internalformat", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("border", ParamType::TGLint, 6).value.GLintVal,
                params.getParam("format", ParamType::TGLenum, 7).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 8).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 9)));
            break;
        case angle::EntryPoint::GLTexParameterIiv:
            context->texParameterIiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexParameterIuiv:
            context->texParameterIuiv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("params", ParamType::TGLuintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexParameterf:
            context->texParameterf(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLTexParameterfv:
            context->texParameterfv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("params", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexParameteri:
            context->texParameteri(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLTexParameteriv:
            context->texParameteriv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("params", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexParameterx:
            context->texParameterx(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                params.getParam("param", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLTexParameterxv:
            context->texParameterxv(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("pname", ParamType::TGLenum, 1).value.GLenumVal,
                replayContext->getAsConstPointer<const GLfixed *>(
                    params.getParam("params", ParamType::TGLfixedConstPointer, 2)));
            break;
        case angle::EntryPoint::GLTexStorage1D:
            context->texStorage1D(
                params.getParam("target", ParamType::TGLenum, 0).value.GLenumVal,
                params.getParam("levels", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLTexStorage2D:
            context->texStorage2D(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("levels", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLTexStorage2DMultisample:
            context->texStorage2DMultisample(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("samples", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("fixedsamplelocations", ParamType::TGLboolean, 5)
                    .value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLTexStorage3D:
            context->texStorage3D(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("levels", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLTexStorage3DMultisample:
            context->texStorage3DMultisample(
                params.getParam("targetPacked", ParamType::TTextureType, 0).value.TextureTypeVal,
                params.getParam("samples", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("internalformat", ParamType::TGLenum, 2).value.GLenumVal,
                params.getParam("width", ParamType::TGLsizei, 3).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("fixedsamplelocations", ParamType::TGLboolean, 6)
                    .value.GLbooleanVal);
            break;
        case angle::EntryPoint::GLTexSubImage2D:
            context->texSubImage2D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 4).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 6).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 7).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 8)));
            break;
        case angle::EntryPoint::GLTexSubImage3D:
            context->texSubImage3D(
                params.getParam("targetPacked", ParamType::TTextureTarget, 0)
                    .value.TextureTargetVal,
                params.getParam("level", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("xoffset", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("yoffset", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("zoffset", ParamType::TGLint, 4).value.GLintVal,
                params.getParam("width", ParamType::TGLsizei, 5).value.GLsizeiVal,
                params.getParam("height", ParamType::TGLsizei, 6).value.GLsizeiVal,
                params.getParam("depth", ParamType::TGLsizei, 7).value.GLsizeiVal,
                params.getParam("format", ParamType::TGLenum, 8).value.GLenumVal,
                params.getParam("type", ParamType::TGLenum, 9).value.GLenumVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pixels", ParamType::TvoidConstPointer, 10)));
            break;
        case angle::EntryPoint::GLTransformFeedbackVaryings:
            context->transformFeedbackVaryings(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                replayContext->getAsPointerConstPointer<const GLchar *const *>(
                    params.getParam("varyings", ParamType::TGLcharConstPointerPointer, 2)),
                params.getParam("bufferMode", ParamType::TGLenum, 3).value.GLenumVal);
            break;
        case angle::EntryPoint::GLTranslatef:
            context->translatef(params.getParam("x", ParamType::TGLfloat, 0).value.GLfloatVal,
                                params.getParam("y", ParamType::TGLfloat, 1).value.GLfloatVal,
                                params.getParam("z", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLTranslatex:
            context->translatex(params.getParam("x", ParamType::TGLfixed, 0).value.GLfixedVal,
                                params.getParam("y", ParamType::TGLfixed, 1).value.GLfixedVal,
                                params.getParam("z", ParamType::TGLfixed, 2).value.GLfixedVal);
            break;
        case angle::EntryPoint::GLUniform1f:
            context->uniform1f(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLUniform1fv:
            context->uniform1fv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform1i:
            context->uniform1i(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal);
            break;
        case angle::EntryPoint::GLUniform1iv:
            context->uniform1iv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform1ui:
            context->uniform1ui(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLUniform1uiv:
            context->uniform1uiv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                     .value.UniformLocationVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform2f:
            context->uniform2f(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal,
                               params.getParam("v1", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLUniform2fv:
            context->uniform2fv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform2i:
            context->uniform2i(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal,
                               params.getParam("v1", ParamType::TGLint, 2).value.GLintVal);
            break;
        case angle::EntryPoint::GLUniform2iv:
            context->uniform2iv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform2ui:
            context->uniform2ui(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal,
                                params.getParam("v1", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case angle::EntryPoint::GLUniform2uiv:
            context->uniform2uiv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                     .value.UniformLocationVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform3f:
            context->uniform3f(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal,
                               params.getParam("v1", ParamType::TGLfloat, 2).value.GLfloatVal,
                               params.getParam("v2", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLUniform3fv:
            context->uniform3fv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform3i:
            context->uniform3i(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal,
                               params.getParam("v1", ParamType::TGLint, 2).value.GLintVal,
                               params.getParam("v2", ParamType::TGLint, 3).value.GLintVal);
            break;
        case angle::EntryPoint::GLUniform3iv:
            context->uniform3iv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform3ui:
            context->uniform3ui(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal,
                                params.getParam("v1", ParamType::TGLuint, 2).value.GLuintVal,
                                params.getParam("v2", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case angle::EntryPoint::GLUniform3uiv:
            context->uniform3uiv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                     .value.UniformLocationVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform4f:
            context->uniform4f(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLfloat, 1).value.GLfloatVal,
                               params.getParam("v1", ParamType::TGLfloat, 2).value.GLfloatVal,
                               params.getParam("v2", ParamType::TGLfloat, 3).value.GLfloatVal,
                               params.getParam("v3", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLUniform4fv:
            context->uniform4fv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLfloat *>(
                                    params.getParam("value", ParamType::TGLfloatConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform4i:
            context->uniform4i(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                   .value.UniformLocationVal,
                               params.getParam("v0", ParamType::TGLint, 1).value.GLintVal,
                               params.getParam("v1", ParamType::TGLint, 2).value.GLintVal,
                               params.getParam("v2", ParamType::TGLint, 3).value.GLintVal,
                               params.getParam("v3", ParamType::TGLint, 4).value.GLintVal);
            break;
        case angle::EntryPoint::GLUniform4iv:
            context->uniform4iv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                replayContext->getAsConstPointer<const GLint *>(
                                    params.getParam("value", ParamType::TGLintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniform4ui:
            context->uniform4ui(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                    .value.UniformLocationVal,
                                params.getParam("v0", ParamType::TGLuint, 1).value.GLuintVal,
                                params.getParam("v1", ParamType::TGLuint, 2).value.GLuintVal,
                                params.getParam("v2", ParamType::TGLuint, 3).value.GLuintVal,
                                params.getParam("v3", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case angle::EntryPoint::GLUniform4uiv:
            context->uniform4uiv(params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                                     .value.UniformLocationVal,
                                 params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                                 replayContext->getAsConstPointer<const GLuint *>(
                                     params.getParam("value", ParamType::TGLuintConstPointer, 2)));
            break;
        case angle::EntryPoint::GLUniformBlockBinding:
            context->uniformBlockBinding(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal,
                params.getParam("uniformBlockIndexPacked", ParamType::TUniformBlockIndex, 1)
                    .value.UniformBlockIndexVal,
                params.getParam("uniformBlockBinding", ParamType::TGLuint, 2).value.GLuintVal);
            break;
        case angle::EntryPoint::GLUniformMatrix2fv:
            context->uniformMatrix2fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix2x3fv:
            context->uniformMatrix2x3fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix2x4fv:
            context->uniformMatrix2x4fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix3fv:
            context->uniformMatrix3fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix3x2fv:
            context->uniformMatrix3x2fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix3x4fv:
            context->uniformMatrix3x4fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix4fv:
            context->uniformMatrix4fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix4x2fv:
            context->uniformMatrix4x2fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUniformMatrix4x3fv:
            context->uniformMatrix4x3fv(
                params.getParam("locationPacked", ParamType::TUniformLocation, 0)
                    .value.UniformLocationVal,
                params.getParam("count", ParamType::TGLsizei, 1).value.GLsizeiVal,
                params.getParam("transpose", ParamType::TGLboolean, 2).value.GLbooleanVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("value", ParamType::TGLfloatConstPointer, 3)));
            break;
        case angle::EntryPoint::GLUnmapBuffer:
            context->unmapBuffer(params.getParam("targetPacked", ParamType::TBufferBinding, 0)
                                     .value.BufferBindingVal);
            break;
        case angle::EntryPoint::GLUseProgram:
            context->useProgram(params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                                    .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLUseProgramStages:
            context->useProgramStages(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal,
                params.getParam("stages", ParamType::TGLbitfield, 1).value.GLbitfieldVal,
                params.getParam("programPacked", ParamType::TShaderProgramID, 2)
                    .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLValidateProgram:
            context->validateProgram(
                params.getParam("programPacked", ParamType::TShaderProgramID, 0)
                    .value.ShaderProgramIDVal);
            break;
        case angle::EntryPoint::GLValidateProgramPipeline:
            context->validateProgramPipeline(
                params.getParam("pipelinePacked", ParamType::TProgramPipelineID, 0)
                    .value.ProgramPipelineIDVal);
            break;
        case angle::EntryPoint::GLVertexAttrib1f:
            context->vertexAttrib1f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLVertexAttrib1fv:
            context->vertexAttrib1fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLVertexAttrib2f:
            context->vertexAttrib2f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                                    params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLVertexAttrib2fv:
            context->vertexAttrib2fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLVertexAttrib3f:
            context->vertexAttrib3f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                                    params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal,
                                    params.getParam("z", ParamType::TGLfloat, 3).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLVertexAttrib3fv:
            context->vertexAttrib3fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLVertexAttrib4f:
            context->vertexAttrib4f(params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                                    params.getParam("x", ParamType::TGLfloat, 1).value.GLfloatVal,
                                    params.getParam("y", ParamType::TGLfloat, 2).value.GLfloatVal,
                                    params.getParam("z", ParamType::TGLfloat, 3).value.GLfloatVal,
                                    params.getParam("w", ParamType::TGLfloat, 4).value.GLfloatVal);
            break;
        case angle::EntryPoint::GLVertexAttrib4fv:
            context->vertexAttrib4fv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLfloat *>(
                    params.getParam("v", ParamType::TGLfloatConstPointer, 1)));
            break;
        case angle::EntryPoint::GLVertexAttribBinding:
            context->vertexAttribBinding(
                params.getParam("attribindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("bindingindex", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLVertexAttribDivisor:
            context->vertexAttribDivisor(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("divisor", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLVertexAttribFormat:
            context->vertexAttribFormat(
                params.getParam("attribindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("normalized", ParamType::TGLboolean, 3).value.GLbooleanVal,
                params.getParam("relativeoffset", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case angle::EntryPoint::GLVertexAttribI4i:
            context->vertexAttribI4i(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("x", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("y", ParamType::TGLint, 2).value.GLintVal,
                params.getParam("z", ParamType::TGLint, 3).value.GLintVal,
                params.getParam("w", ParamType::TGLint, 4).value.GLintVal);
            break;
        case angle::EntryPoint::GLVertexAttribI4iv:
            context->vertexAttribI4iv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLint *>(
                    params.getParam("v", ParamType::TGLintConstPointer, 1)));
            break;
        case angle::EntryPoint::GLVertexAttribI4ui:
            context->vertexAttribI4ui(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("x", ParamType::TGLuint, 1).value.GLuintVal,
                params.getParam("y", ParamType::TGLuint, 2).value.GLuintVal,
                params.getParam("z", ParamType::TGLuint, 3).value.GLuintVal,
                params.getParam("w", ParamType::TGLuint, 4).value.GLuintVal);
            break;
        case angle::EntryPoint::GLVertexAttribI4uiv:
            context->vertexAttribI4uiv(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                replayContext->getAsConstPointer<const GLuint *>(
                    params.getParam("v", ParamType::TGLuintConstPointer, 1)));
            break;
        case angle::EntryPoint::GLVertexAttribIFormat:
            context->vertexAttribIFormat(
                params.getParam("attribindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("relativeoffset", ParamType::TGLuint, 3).value.GLuintVal);
            break;
        case angle::EntryPoint::GLVertexAttribIPointer:
            context->vertexAttribIPointer(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 3).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 4)));
            break;
        case angle::EntryPoint::GLVertexAttribPointer:
            context->vertexAttribPointer(
                params.getParam("index", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("size", ParamType::TGLint, 1).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 2)
                    .value.VertexAttribTypeVal,
                params.getParam("normalized", ParamType::TGLboolean, 3).value.GLbooleanVal,
                params.getParam("stride", ParamType::TGLsizei, 4).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 5)));
            break;
        case angle::EntryPoint::GLVertexBindingDivisor:
            context->vertexBindingDivisor(
                params.getParam("bindingindex", ParamType::TGLuint, 0).value.GLuintVal,
                params.getParam("divisor", ParamType::TGLuint, 1).value.GLuintVal);
            break;
        case angle::EntryPoint::GLVertexPointer:
            context->vertexPointer(
                params.getParam("size", ParamType::TGLint, 0).value.GLintVal,
                params.getParam("typePacked", ParamType::TVertexAttribType, 1)
                    .value.VertexAttribTypeVal,
                params.getParam("stride", ParamType::TGLsizei, 2).value.GLsizeiVal,
                replayContext->getAsConstPointer<const void *>(
                    params.getParam("pointer", ParamType::TvoidConstPointer, 3)));
            break;
        case angle::EntryPoint::GLViewport:
            context->viewport(params.getParam("x", ParamType::TGLint, 0).value.GLintVal,
                              params.getParam("y", ParamType::TGLint, 1).value.GLintVal,
                              params.getParam("width", ParamType::TGLsizei, 2).value.GLsizeiVal,
                              params.getParam("height", ParamType::TGLsizei, 3).value.GLsizeiVal);
            break;
        case angle::EntryPoint::GLWaitSync:
            context->waitSync(
                params.getParam("sync", ParamType::TGLsync, 0).value.GLsyncVal,
                params.getParam("flags", ParamType::TGLbitfield, 1).value.GLbitfieldVal,
                params.getParam("timeout", ParamType::TGLuint64, 2).value.GLuint64Val);
            break;
        default:
            UNREACHABLE();
    }
}

}  // namespace angle
