The trait `CoerceUnsized` may only be implemented for a coercion between
structures with the same definition.

Example of erroneous code:

```compile_fail,E0377
#![feature(coerce_unsized)]
use std::ops::CoerceUnsized;

pub struct Foo<T: ?Sized> {
    field_with_unsized_type: T,
}

pub struct Bar<T: ?Sized> {
    field_with_unsized_type: T,
}

// error: the trait `CoerceUnsized` may only be implemented for a coercion
//        between structures with the same definition
impl<T, U> CoerceUnsized<Bar<U>> for Foo<T> where T: CoerceUnsized<U> {}
```

When attempting to implement `CoerceUnsized`, the `impl` signature must look
like: `impl CoerceUnsized<Type<U>> for Type<T> where T: CoerceUnsized<U>`;
the *implementer* and *`CoerceUnsized` type parameter* must be the same
type. In this example, `Bar` and `Foo` (even though structurally identical)
are *not* the same type and are rejected. Learn more about the `CoerceUnsized`
trait and DST coercion in
[the `CoerceUnsized` docs](../std/ops/trait.CoerceUnsized.html).
