// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkehub/v1alpha/servicemesh/servicemesh.proto

package servicemesh

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The values here are chosen so that more severe messages get sorted higher,
// as well as leaving space in between to add more later
// See istio.analysis.v1alpha1.AnalysisMessageBase.Level
type AnalysisMessageBase_Level int32

const (
	// Illegal. Same istio.analysis.v1alpha1.AnalysisMessageBase.Level.UNKNOWN.
	AnalysisMessageBase_LEVEL_UNSPECIFIED AnalysisMessageBase_Level = 0
	// ERROR represents a misconfiguration that must be fixed.
	AnalysisMessageBase_ERROR AnalysisMessageBase_Level = 3
	// WARNING represents a misconfiguration that should be fixed.
	AnalysisMessageBase_WARNING AnalysisMessageBase_Level = 8
	// INFO represents an informational finding.
	AnalysisMessageBase_INFO AnalysisMessageBase_Level = 12
)

// Enum value maps for AnalysisMessageBase_Level.
var (
	AnalysisMessageBase_Level_name = map[int32]string{
		0:  "LEVEL_UNSPECIFIED",
		3:  "ERROR",
		8:  "WARNING",
		12: "INFO",
	}
	AnalysisMessageBase_Level_value = map[string]int32{
		"LEVEL_UNSPECIFIED": 0,
		"ERROR":             3,
		"WARNING":           8,
		"INFO":              12,
	}
)

func (x AnalysisMessageBase_Level) Enum() *AnalysisMessageBase_Level {
	p := new(AnalysisMessageBase_Level)
	*p = x
	return p
}

func (x AnalysisMessageBase_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalysisMessageBase_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_enumTypes[0].Descriptor()
}

func (AnalysisMessageBase_Level) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_enumTypes[0]
}

func (x AnalysisMessageBase_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalysisMessageBase_Level.Descriptor instead.
func (AnalysisMessageBase_Level) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescGZIP(), []int{2, 0}
}

// **Service Mesh**: State for the whole Hub, as analyzed by the Service Mesh
// Hub Controller.
type FeatureState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Results of running Service Mesh analyzers.
	AnalysisMessages []*AnalysisMessage `protobuf:"bytes,1,rep,name=analysis_messages,json=analysisMessages,proto3" json:"analysis_messages,omitempty"`
}

func (x *FeatureState) Reset() {
	*x = FeatureState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureState) ProtoMessage() {}

func (x *FeatureState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureState.ProtoReflect.Descriptor instead.
func (*FeatureState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescGZIP(), []int{0}
}

func (x *FeatureState) GetAnalysisMessages() []*AnalysisMessage {
	if x != nil {
		return x.AnalysisMessages
	}
	return nil
}

// **Service Mesh**: State for a single Membership, as analyzed by the Service
// Mesh Hub Controller.
type MembershipState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Results of running Service Mesh analyzers.
	AnalysisMessages []*AnalysisMessage `protobuf:"bytes,1,rep,name=analysis_messages,json=analysisMessages,proto3" json:"analysis_messages,omitempty"`
}

func (x *MembershipState) Reset() {
	*x = MembershipState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipState) ProtoMessage() {}

func (x *MembershipState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipState.ProtoReflect.Descriptor instead.
func (*MembershipState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescGZIP(), []int{1}
}

func (x *MembershipState) GetAnalysisMessages() []*AnalysisMessage {
	if x != nil {
		return x.AnalysisMessages
	}
	return nil
}

// AnalysisMessageBase describes some common information that is
// needed for all messages.
type AnalysisMessageBase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the specific type of a message.
	Type *AnalysisMessageBase_Type `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Represents how severe a message is.
	Level AnalysisMessageBase_Level `protobuf:"varint,2,opt,name=level,proto3,enum=google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase_Level" json:"level,omitempty"`
	// A url pointing to the Service Mesh or Istio documentation for this specific
	// error type.
	DocumentationUrl string `protobuf:"bytes,3,opt,name=documentation_url,json=documentationUrl,proto3" json:"documentation_url,omitempty"`
}

func (x *AnalysisMessageBase) Reset() {
	*x = AnalysisMessageBase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalysisMessageBase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalysisMessageBase) ProtoMessage() {}

func (x *AnalysisMessageBase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalysisMessageBase.ProtoReflect.Descriptor instead.
func (*AnalysisMessageBase) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescGZIP(), []int{2}
}

func (x *AnalysisMessageBase) GetType() *AnalysisMessageBase_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *AnalysisMessageBase) GetLevel() AnalysisMessageBase_Level {
	if x != nil {
		return x.Level
	}
	return AnalysisMessageBase_LEVEL_UNSPECIFIED
}

func (x *AnalysisMessageBase) GetDocumentationUrl() string {
	if x != nil {
		return x.DocumentationUrl
	}
	return ""
}

// AnalysisMessage is a single message produced by an analyzer, and
// it used to communicate to the end user about the state of their Service
// Mesh configuration.
type AnalysisMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details common to all types of Istio and ServiceMesh analysis messages.
	MessageBase *AnalysisMessageBase `protobuf:"bytes,1,opt,name=message_base,json=messageBase,proto3" json:"message_base,omitempty"`
	// A human readable description of what the error means. It is suitable for
	// non-internationalize display purposes.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// A list of strings specifying the resource identifiers that were the cause
	// of message generation.
	// A "path" here may be:
	// * MEMBERSHIP_ID if the cause is a specific member cluster
	// * MEMBERSHIP_ID/(NAMESPACE\/)?RESOURCETYPE/NAME if the cause is a resource
	// in a cluster
	ResourcePaths []string `protobuf:"bytes,3,rep,name=resource_paths,json=resourcePaths,proto3" json:"resource_paths,omitempty"`
	// A UI can combine these args with a template (based on message_base.type)
	// to produce an internationalized message.
	Args *structpb.Struct `protobuf:"bytes,4,opt,name=args,proto3" json:"args,omitempty"`
}

func (x *AnalysisMessage) Reset() {
	*x = AnalysisMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalysisMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalysisMessage) ProtoMessage() {}

func (x *AnalysisMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalysisMessage.ProtoReflect.Descriptor instead.
func (*AnalysisMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescGZIP(), []int{3}
}

func (x *AnalysisMessage) GetMessageBase() *AnalysisMessageBase {
	if x != nil {
		return x.MessageBase
	}
	return nil
}

func (x *AnalysisMessage) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AnalysisMessage) GetResourcePaths() []string {
	if x != nil {
		return x.ResourcePaths
	}
	return nil
}

func (x *AnalysisMessage) GetArgs() *structpb.Struct {
	if x != nil {
		return x.Args
	}
	return nil
}

// A unique identifier for the type of message. Display_name is intended to be
// human-readable, code is intended to be machine readable. There should be a
// one-to-one mapping between display_name and code. (i.e. do not re-use
// display_names or codes between message types.)
// See istio.analysis.v1alpha1.AnalysisMessageBase.Type
type AnalysisMessageBase_Type struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A human-readable name for the message type. e.g. "InternalError",
	// "PodMissingProxy". This should be the same for all messages of the same
	// type. (This corresponds to the `name` field in open-source Istio.)
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A 7 character code matching `^IST[0-9]{4}$` or `^ASM[0-9]{4}$`, intended
	// to uniquely identify the message type. (e.g. "IST0001" is mapped to the
	// "InternalError" message type.)
	Code string `protobuf:"bytes,2,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *AnalysisMessageBase_Type) Reset() {
	*x = AnalysisMessageBase_Type{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalysisMessageBase_Type) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalysisMessageBase_Type) ProtoMessage() {}

func (x *AnalysisMessageBase_Type) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalysisMessageBase_Type.ProtoReflect.Descriptor instead.
func (*AnalysisMessageBase_Type) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AnalysisMessageBase_Type) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AnalysisMessageBase_Type) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

var File_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto protoreflect.FileDescriptor

var file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x7a, 0x0a, 0x0c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x6a, 0x0a, 0x11, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68,
	0x75, 0x62, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0x7d, 0x0a,
	0x0f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x6a, 0x0a, 0x11, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x22, 0xf4, 0x02, 0x0a,
	0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x42, 0x61, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x58, 0x0a, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x72, 0x6c, 0x1a, 0x3d, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x22, 0x40, 0x0a, 0x05, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x45,
	0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07,
	0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46,
	0x4f, 0x10, 0x0c, 0x22, 0xe8, 0x01, 0x0a, 0x0f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x5f, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x52, 0x0b, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x73, 0x12, 0x2b, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x42, 0x97,
	0x02, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x10,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x68, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65,
	0x73, 0x68, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x68, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65,
	0x73, 0x68, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x48,
	0x75, 0x62, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x68, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescOnce sync.Once
	file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescData = file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDesc
)

func file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescGZIP() []byte {
	file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescData)
	})
	return file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDescData
}

var file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_goTypes = []interface{}{
	(AnalysisMessageBase_Level)(0),   // 0: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Level
	(*FeatureState)(nil),             // 1: google.cloud.gkehub.servicemesh.v1alpha.FeatureState
	(*MembershipState)(nil),          // 2: google.cloud.gkehub.servicemesh.v1alpha.MembershipState
	(*AnalysisMessageBase)(nil),      // 3: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase
	(*AnalysisMessage)(nil),          // 4: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage
	(*AnalysisMessageBase_Type)(nil), // 5: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Type
	(*structpb.Struct)(nil),          // 6: google.protobuf.Struct
}
var file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_depIdxs = []int32{
	4, // 0: google.cloud.gkehub.servicemesh.v1alpha.FeatureState.analysis_messages:type_name -> google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage
	4, // 1: google.cloud.gkehub.servicemesh.v1alpha.MembershipState.analysis_messages:type_name -> google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage
	5, // 2: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.type:type_name -> google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Type
	0, // 3: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.level:type_name -> google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase.Level
	3, // 4: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.message_base:type_name -> google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessageBase
	6, // 5: google.cloud.gkehub.servicemesh.v1alpha.AnalysisMessage.args:type_name -> google.protobuf.Struct
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_init() }
func file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_init() {
	if File_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalysisMessageBase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalysisMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalysisMessageBase_Type); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_msgTypes,
	}.Build()
	File_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto = out.File
	file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_rawDesc = nil
	file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_goTypes = nil
	file_google_cloud_gkehub_v1alpha_servicemesh_servicemesh_proto_depIdxs = nil
}
