// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/campaign_group_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [CampaignGroupService.GetCampaignGroup][google.ads.googleads.v0.services.CampaignGroupService.GetCampaignGroup].
type GetCampaignGroupRequest struct {
	// The resource name of the campaign group to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCampaignGroupRequest) Reset()         { *m = GetCampaignGroupRequest{} }
func (m *GetCampaignGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetCampaignGroupRequest) ProtoMessage()    {}
func (*GetCampaignGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_group_service_c6f1b213514585b6, []int{0}
}
func (m *GetCampaignGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCampaignGroupRequest.Unmarshal(m, b)
}
func (m *GetCampaignGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCampaignGroupRequest.Marshal(b, m, deterministic)
}
func (dst *GetCampaignGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCampaignGroupRequest.Merge(dst, src)
}
func (m *GetCampaignGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetCampaignGroupRequest.Size(m)
}
func (m *GetCampaignGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCampaignGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCampaignGroupRequest proto.InternalMessageInfo

func (m *GetCampaignGroupRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CampaignGroupService.MutateCampaignGroups][google.ads.googleads.v0.services.CampaignGroupService.MutateCampaignGroups].
type MutateCampaignGroupsRequest struct {
	// The ID of the customer whose campaign groups are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual campaign groups.
	Operations           []*CampaignGroupOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *MutateCampaignGroupsRequest) Reset()         { *m = MutateCampaignGroupsRequest{} }
func (m *MutateCampaignGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCampaignGroupsRequest) ProtoMessage()    {}
func (*MutateCampaignGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_group_service_c6f1b213514585b6, []int{1}
}
func (m *MutateCampaignGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCampaignGroupsRequest.Unmarshal(m, b)
}
func (m *MutateCampaignGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCampaignGroupsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateCampaignGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCampaignGroupsRequest.Merge(dst, src)
}
func (m *MutateCampaignGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCampaignGroupsRequest.Size(m)
}
func (m *MutateCampaignGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCampaignGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCampaignGroupsRequest proto.InternalMessageInfo

func (m *MutateCampaignGroupsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCampaignGroupsRequest) GetOperations() []*CampaignGroupOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, update, remove) on a campaign group.
type CampaignGroupOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CampaignGroupOperation_Create
	//	*CampaignGroupOperation_Update
	//	*CampaignGroupOperation_Remove
	Operation            isCampaignGroupOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *CampaignGroupOperation) Reset()         { *m = CampaignGroupOperation{} }
func (m *CampaignGroupOperation) String() string { return proto.CompactTextString(m) }
func (*CampaignGroupOperation) ProtoMessage()    {}
func (*CampaignGroupOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_group_service_c6f1b213514585b6, []int{2}
}
func (m *CampaignGroupOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignGroupOperation.Unmarshal(m, b)
}
func (m *CampaignGroupOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignGroupOperation.Marshal(b, m, deterministic)
}
func (dst *CampaignGroupOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignGroupOperation.Merge(dst, src)
}
func (m *CampaignGroupOperation) XXX_Size() int {
	return xxx_messageInfo_CampaignGroupOperation.Size(m)
}
func (m *CampaignGroupOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignGroupOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignGroupOperation proto.InternalMessageInfo

func (m *CampaignGroupOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCampaignGroupOperation_Operation interface {
	isCampaignGroupOperation_Operation()
}

type CampaignGroupOperation_Create struct {
	Create *resources.CampaignGroup `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CampaignGroupOperation_Update struct {
	Update *resources.CampaignGroup `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type CampaignGroupOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*CampaignGroupOperation_Create) isCampaignGroupOperation_Operation() {}

func (*CampaignGroupOperation_Update) isCampaignGroupOperation_Operation() {}

func (*CampaignGroupOperation_Remove) isCampaignGroupOperation_Operation() {}

func (m *CampaignGroupOperation) GetOperation() isCampaignGroupOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CampaignGroupOperation) GetCreate() *resources.CampaignGroup {
	if x, ok := m.GetOperation().(*CampaignGroupOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CampaignGroupOperation) GetUpdate() *resources.CampaignGroup {
	if x, ok := m.GetOperation().(*CampaignGroupOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *CampaignGroupOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*CampaignGroupOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CampaignGroupOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CampaignGroupOperation_OneofMarshaler, _CampaignGroupOperation_OneofUnmarshaler, _CampaignGroupOperation_OneofSizer, []interface{}{
		(*CampaignGroupOperation_Create)(nil),
		(*CampaignGroupOperation_Update)(nil),
		(*CampaignGroupOperation_Remove)(nil),
	}
}

func _CampaignGroupOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CampaignGroupOperation)
	// operation
	switch x := m.Operation.(type) {
	case *CampaignGroupOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *CampaignGroupOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *CampaignGroupOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("CampaignGroupOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _CampaignGroupOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CampaignGroupOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.CampaignGroup)
		err := b.DecodeMessage(msg)
		m.Operation = &CampaignGroupOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.CampaignGroup)
		err := b.DecodeMessage(msg)
		m.Operation = &CampaignGroupOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &CampaignGroupOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _CampaignGroupOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CampaignGroupOperation)
	// operation
	switch x := m.Operation.(type) {
	case *CampaignGroupOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CampaignGroupOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CampaignGroupOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for campaign group mutate.
type MutateCampaignGroupsResponse struct {
	// All results for the mutate.
	Results              []*MutateCampaignGroupResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MutateCampaignGroupsResponse) Reset()         { *m = MutateCampaignGroupsResponse{} }
func (m *MutateCampaignGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCampaignGroupsResponse) ProtoMessage()    {}
func (*MutateCampaignGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_group_service_c6f1b213514585b6, []int{3}
}
func (m *MutateCampaignGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCampaignGroupsResponse.Unmarshal(m, b)
}
func (m *MutateCampaignGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCampaignGroupsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateCampaignGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCampaignGroupsResponse.Merge(dst, src)
}
func (m *MutateCampaignGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCampaignGroupsResponse.Size(m)
}
func (m *MutateCampaignGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCampaignGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCampaignGroupsResponse proto.InternalMessageInfo

func (m *MutateCampaignGroupsResponse) GetResults() []*MutateCampaignGroupResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the campaign group mutate.
type MutateCampaignGroupResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCampaignGroupResult) Reset()         { *m = MutateCampaignGroupResult{} }
func (m *MutateCampaignGroupResult) String() string { return proto.CompactTextString(m) }
func (*MutateCampaignGroupResult) ProtoMessage()    {}
func (*MutateCampaignGroupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_group_service_c6f1b213514585b6, []int{4}
}
func (m *MutateCampaignGroupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCampaignGroupResult.Unmarshal(m, b)
}
func (m *MutateCampaignGroupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCampaignGroupResult.Marshal(b, m, deterministic)
}
func (dst *MutateCampaignGroupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCampaignGroupResult.Merge(dst, src)
}
func (m *MutateCampaignGroupResult) XXX_Size() int {
	return xxx_messageInfo_MutateCampaignGroupResult.Size(m)
}
func (m *MutateCampaignGroupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCampaignGroupResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCampaignGroupResult proto.InternalMessageInfo

func (m *MutateCampaignGroupResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCampaignGroupRequest)(nil), "google.ads.googleads.v0.services.GetCampaignGroupRequest")
	proto.RegisterType((*MutateCampaignGroupsRequest)(nil), "google.ads.googleads.v0.services.MutateCampaignGroupsRequest")
	proto.RegisterType((*CampaignGroupOperation)(nil), "google.ads.googleads.v0.services.CampaignGroupOperation")
	proto.RegisterType((*MutateCampaignGroupsResponse)(nil), "google.ads.googleads.v0.services.MutateCampaignGroupsResponse")
	proto.RegisterType((*MutateCampaignGroupResult)(nil), "google.ads.googleads.v0.services.MutateCampaignGroupResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CampaignGroupServiceClient is the client API for CampaignGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CampaignGroupServiceClient interface {
	// Returns the requested campaign group in full detail.
	GetCampaignGroup(ctx context.Context, in *GetCampaignGroupRequest, opts ...grpc.CallOption) (*resources.CampaignGroup, error)
	// Creates, updates, or removes campaign groups. Operation statuses are
	// returned.
	MutateCampaignGroups(ctx context.Context, in *MutateCampaignGroupsRequest, opts ...grpc.CallOption) (*MutateCampaignGroupsResponse, error)
}

type campaignGroupServiceClient struct {
	cc *grpc.ClientConn
}

func NewCampaignGroupServiceClient(cc *grpc.ClientConn) CampaignGroupServiceClient {
	return &campaignGroupServiceClient{cc}
}

func (c *campaignGroupServiceClient) GetCampaignGroup(ctx context.Context, in *GetCampaignGroupRequest, opts ...grpc.CallOption) (*resources.CampaignGroup, error) {
	out := new(resources.CampaignGroup)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.CampaignGroupService/GetCampaignGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *campaignGroupServiceClient) MutateCampaignGroups(ctx context.Context, in *MutateCampaignGroupsRequest, opts ...grpc.CallOption) (*MutateCampaignGroupsResponse, error) {
	out := new(MutateCampaignGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.CampaignGroupService/MutateCampaignGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CampaignGroupServiceServer is the server API for CampaignGroupService service.
type CampaignGroupServiceServer interface {
	// Returns the requested campaign group in full detail.
	GetCampaignGroup(context.Context, *GetCampaignGroupRequest) (*resources.CampaignGroup, error)
	// Creates, updates, or removes campaign groups. Operation statuses are
	// returned.
	MutateCampaignGroups(context.Context, *MutateCampaignGroupsRequest) (*MutateCampaignGroupsResponse, error)
}

func RegisterCampaignGroupServiceServer(s *grpc.Server, srv CampaignGroupServiceServer) {
	s.RegisterService(&_CampaignGroupService_serviceDesc, srv)
}

func _CampaignGroupService_GetCampaignGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCampaignGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignGroupServiceServer).GetCampaignGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.CampaignGroupService/GetCampaignGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignGroupServiceServer).GetCampaignGroup(ctx, req.(*GetCampaignGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CampaignGroupService_MutateCampaignGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCampaignGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CampaignGroupServiceServer).MutateCampaignGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.CampaignGroupService/MutateCampaignGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CampaignGroupServiceServer).MutateCampaignGroups(ctx, req.(*MutateCampaignGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CampaignGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.CampaignGroupService",
	HandlerType: (*CampaignGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCampaignGroup",
			Handler:    _CampaignGroupService_GetCampaignGroup_Handler,
		},
		{
			MethodName: "MutateCampaignGroups",
			Handler:    _CampaignGroupService_MutateCampaignGroups_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/campaign_group_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/campaign_group_service.proto", fileDescriptor_campaign_group_service_c6f1b213514585b6)
}

var fileDescriptor_campaign_group_service_c6f1b213514585b6 = []byte{
	// 597 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x41, 0x8b, 0xd3, 0x40,
	0x14, 0xc7, 0x4d, 0x2a, 0x2b, 0xfb, 0xa2, 0x20, 0xc3, 0xa2, 0xd9, 0xba, 0x60, 0x89, 0x1e, 0x4a,
	0x0f, 0x49, 0xe8, 0x82, 0xd4, 0x2d, 0x2d, 0xb6, 0x82, 0x5d, 0x85, 0xd5, 0x25, 0xe2, 0x22, 0x52,
	0x28, 0xb3, 0xcd, 0x6c, 0x08, 0xdb, 0x64, 0xe2, 0xcc, 0xa4, 0x97, 0x65, 0x2f, 0x7e, 0x05, 0x3d,
	0x78, 0xf6, 0xb8, 0xdf, 0xc0, 0xaf, 0xe0, 0x55, 0x3c, 0x78, 0xf7, 0x83, 0xc8, 0x64, 0x32, 0x75,
	0xbb, 0xb6, 0x54, 0x7b, 0x7b, 0x49, 0xde, 0xfb, 0xbd, 0xf7, 0xfe, 0xef, 0xbd, 0x40, 0x27, 0xa2,
	0x34, 0x9a, 0x10, 0x0f, 0x87, 0xdc, 0x53, 0xa6, 0xb4, 0xa6, 0xbe, 0xc7, 0x09, 0x9b, 0xc6, 0x63,
	0xc2, 0xbd, 0x31, 0x4e, 0x32, 0x1c, 0x47, 0xe9, 0x28, 0x62, 0x34, 0xcf, 0x46, 0xe5, 0x7b, 0x37,
	0x63, 0x54, 0x50, 0x54, 0x53, 0x31, 0x2e, 0x0e, 0xb9, 0x3b, 0x0b, 0x77, 0xa7, 0xbe, 0xab, 0xc3,
	0xab, 0x8f, 0x96, 0x25, 0x60, 0x84, 0xd3, 0x9c, 0xfd, 0x9d, 0x41, 0x91, 0xab, 0x3b, 0x3a, 0x2e,
	0x8b, 0x3d, 0x9c, 0xa6, 0x54, 0x60, 0x11, 0xd3, 0x94, 0x97, 0x5f, 0xcb, 0xbc, 0x5e, 0xf1, 0x74,
	0x9c, 0x9f, 0x78, 0x27, 0x31, 0x99, 0x84, 0xa3, 0x04, 0xf3, 0x53, 0xe5, 0xe1, 0x74, 0xe1, 0xee,
	0x80, 0x88, 0xa7, 0x25, 0x7a, 0x20, 0xc9, 0x01, 0x79, 0x9f, 0x13, 0x2e, 0xd0, 0x03, 0xb8, 0xa5,
	0x93, 0x8f, 0x52, 0x9c, 0x10, 0xdb, 0xa8, 0x19, 0xf5, 0xcd, 0xe0, 0xa6, 0x7e, 0xf9, 0x12, 0x27,
	0xc4, 0xf9, 0x6c, 0xc0, 0xbd, 0x83, 0x5c, 0x60, 0x41, 0xe6, 0x18, 0x5c, 0x43, 0xee, 0x83, 0x35,
	0xce, 0xb9, 0xa0, 0x09, 0x61, 0xa3, 0x38, 0x2c, 0x11, 0xa0, 0x5f, 0x3d, 0x0f, 0xd1, 0x5b, 0x00,
	0x9a, 0x11, 0xa6, 0xca, 0xb6, 0xcd, 0x5a, 0xa5, 0x6e, 0x35, 0x5b, 0xee, 0x2a, 0xbd, 0xdc, 0xb9,
	0x6c, 0xaf, 0x34, 0x20, 0xb8, 0xc4, 0x72, 0x3e, 0x99, 0x70, 0x67, 0xb1, 0x1b, 0x6a, 0x83, 0x95,
	0x67, 0x21, 0x16, 0xa4, 0x90, 0xc2, 0xbe, 0x5e, 0x33, 0xea, 0x56, 0xb3, 0xaa, 0xb3, 0x6a, 0xb5,
	0xdc, 0x67, 0x52, 0xad, 0x03, 0xcc, 0x4f, 0x03, 0x50, 0xee, 0xd2, 0x46, 0x2f, 0x60, 0x63, 0xcc,
	0x08, 0x16, 0x4a, 0x10, 0xab, 0xe9, 0x2f, 0xad, 0x76, 0x36, 0xbb, 0xf9, 0x72, 0xf7, 0xaf, 0x05,
	0x25, 0x41, 0xb2, 0x14, 0xd9, 0x36, 0xd7, 0x67, 0x29, 0x02, 0xb2, 0x61, 0x83, 0x91, 0x84, 0x4e,
	0x89, 0x5d, 0x91, 0x2a, 0xcb, 0x2f, 0xea, 0xb9, 0x6f, 0xc1, 0xe6, 0x4c, 0x17, 0x27, 0x87, 0x9d,
	0xc5, 0x03, 0xe3, 0x19, 0x4d, 0x39, 0x41, 0x6f, 0xe0, 0x06, 0x23, 0x3c, 0x9f, 0x08, 0x3d, 0x8d,
	0xf6, 0xea, 0x69, 0x2c, 0x00, 0x06, 0x05, 0x23, 0xd0, 0x2c, 0xe7, 0x09, 0x6c, 0x2f, 0xf5, 0xfa,
	0xa7, 0x55, 0x6b, 0x5e, 0x54, 0x60, 0x6b, 0x2e, 0xf8, 0xb5, 0x4a, 0x8f, 0xbe, 0x1a, 0x70, 0xfb,
	0xea, 0x12, 0xa3, 0xc7, 0xab, 0xab, 0x5e, 0xb2, 0xf8, 0xd5, 0xff, 0x1e, 0x82, 0xd3, 0xfa, 0xf0,
	0xfd, 0xd7, 0x47, 0xb3, 0x89, 0x7c, 0x79, 0xb1, 0x67, 0x73, 0xad, 0x74, 0xf4, 0xae, 0x73, 0xaf,
	0x31, 0x3b, 0x61, 0x25, 0xb9, 0xd7, 0x38, 0x47, 0x3f, 0x0c, 0xd8, 0x5a, 0x34, 0x0e, 0xd4, 0x59,
	0x4b, 0x75, 0x7d, 0x77, 0xd5, 0xee, 0xba, 0xe1, 0x6a, 0x0b, 0x9c, 0x6e, 0xd1, 0x51, 0xcb, 0xd9,
	0x95, 0x1d, 0xfd, 0x69, 0xe1, 0xec, 0xd2, 0x31, 0x77, 0x1a, 0xe7, 0x57, 0x1a, 0xda, 0x4b, 0x0a,
	0xe4, 0x9e, 0xd1, 0xe8, 0xff, 0x34, 0xe0, 0xe1, 0x98, 0x26, 0x2b, 0xab, 0xe8, 0x6f, 0x2f, 0x1a,
	0xe9, 0xa1, 0xbc, 0xc0, 0x43, 0xe3, 0xdd, 0x7e, 0x19, 0x1e, 0xd1, 0x09, 0x4e, 0x23, 0x97, 0xb2,
	0xc8, 0x8b, 0x48, 0x5a, 0xdc, 0xa7, 0xfe, 0x4b, 0x66, 0x31, 0x5f, 0xfe, 0x57, 0x6e, 0x6b, 0xe3,
	0x8b, 0x59, 0x19, 0xf4, 0x7a, 0x17, 0x66, 0x6d, 0xa0, 0x80, 0xbd, 0x90, 0xbb, 0xca, 0x94, 0xd6,
	0x91, 0xef, 0x96, 0x89, 0xf9, 0x37, 0xed, 0x32, 0xec, 0x85, 0x7c, 0x38, 0x73, 0x19, 0x1e, 0xf9,
	0x43, 0xed, 0x72, 0xbc, 0x51, 0x14, 0xb0, 0xfb, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x61, 0x8d, 0x4c,
	0x3f, 0x15, 0x06, 0x00, 0x00,
}
