# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the cisco.ios_ospfv3 module
"""


class Ospfv3Args(object):  # pylint: disable=R0903
    """The arg spec for the cisco.ios_ospfv3 module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "processes": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "process_id": {"required": True, "type": "int"},
                        "address_family": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "afi": {
                                    "type": "str",
                                    "choices": ["ipv4", "ipv6"],
                                },
                                "unicast": {"type": "bool"},
                                "vrf": {"type": "str"},
                                "adjacency": {
                                    "type": "dict",
                                    "options": {
                                        "min_adjacency": {"type": "int"},
                                        "none": {"type": "bool"},
                                        "max_adjacency": {"type": "int"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                                "areas": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "area_id": {"type": "str"},
                                        "authentication": {
                                            "type": "dict",
                                            "options": {
                                                "key_chain": {"type": "str"},
                                                "null": {"type": "bool"},
                                            },
                                        },
                                        "default_cost": {"type": "int"},
                                        "filter_list": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "name": {"type": "str"},
                                                "direction": {
                                                    "type": "str",
                                                    "choices": ["in", "out"],
                                                    "required": True,
                                                },
                                            },
                                        },
                                        "normal": {"type": "bool"},
                                        "nssa": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "default_information_originate": {
                                                    "type": "dict",
                                                    "options": {
                                                        "metric": {
                                                            "type": "int"
                                                        },
                                                        "metric_type": {
                                                            "type": "int",
                                                            "choices": [1, 2],
                                                        },
                                                        "nssa_only": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                                "no_redistribution": {
                                                    "type": "bool"
                                                },
                                                "no_summary": {"type": "bool"},
                                                "translate": {
                                                    "type": "str",
                                                    "choices": [
                                                        "always",
                                                        "suppress-fa",
                                                    ],
                                                },
                                            },
                                        },
                                        "ranges": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "address": {"type": "str"},
                                                "netmask": {"type": "str"},
                                                "advertise": {"type": "bool"},
                                                "cost": {"type": "int"},
                                                "not_advertise": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "sham_link": {
                                            "type": "dict",
                                            "options": {
                                                "source": {"type": "str"},
                                                "destination": {"type": "str"},
                                                "authentication": {
                                                    "type": "dict",
                                                    "options": {
                                                        "key_chain": {
                                                            "type": "str"
                                                        },
                                                        "null": {
                                                            "type": "bool"
                                                        },
                                                    },
                                                },
                                                "cost": {"type": "int"},
                                                "ttl_security": {
                                                    "type": "int"
                                                },
                                            },
                                        },
                                        "stub": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "no_summary": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "authentication": {
                                    "type": "dict",
                                    "options": {
                                        "deployment": {"type": "bool"},
                                        "normal": {"type": "bool"},
                                    },
                                },
                                "auto_cost": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "reference_bandwidth": {"type": "int"},
                                    },
                                },
                                "bfd": {
                                    "type": "dict",
                                    "options": {
                                        "all_interfaces": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                                "capability": {"type": "bool"},
                                "compatible": {
                                    "type": "dict",
                                    "options": {
                                        "rfc1583": {"type": "bool"},
                                        "rfc1587": {"type": "bool"},
                                        "rfc5243": {"type": "bool"},
                                    },
                                },
                                "default_information": {
                                    "type": "dict",
                                    "options": {
                                        "originate": {"type": "bool"},
                                        "always": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_map": {"type": "str"},
                                    },
                                },
                                "default_metric": {"type": "int"},
                                "discard_route": {
                                    "type": "dict",
                                    "options": {
                                        "sham_link": {"type": "bool"},
                                        "external": {"type": "bool"},
                                        "internal": {"type": "bool"},
                                    },
                                },
                                "distance": {"type": "int"},
                                "distribute_list": {
                                    "type": "dict",
                                    "options": {
                                        "acls": {
                                            "type": "list",
                                            "elements": "dict",
                                            "options": {
                                                "name": {
                                                    "type": "str",
                                                    "required": True,
                                                },
                                                "direction": {
                                                    "type": "str",
                                                    "required": True,
                                                    "choices": ["in", "out"],
                                                },
                                                "interface": {"type": "str"},
                                                "protocol": {"type": "str"},
                                            },
                                        },
                                        "prefix": {
                                            "type": "dict",
                                            "options": {
                                                "name": {
                                                    "type": "str",
                                                    "required": True,
                                                },
                                                "gateway_name": {
                                                    "type": "str"
                                                },
                                                "direction": {
                                                    "type": "str",
                                                    "required": True,
                                                    "choices": ["in", "out"],
                                                },
                                                "interface": {"type": "str"},
                                                "protocol": {"type": "str"},
                                            },
                                        },
                                        "route_map": {
                                            "type": "dict",
                                            "options": {
                                                "name": {
                                                    "type": "str",
                                                    "required": True,
                                                }
                                            },
                                        },
                                    },
                                },
                                "event_log": {
                                    "type": "dict",
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "one_shot": {"type": "bool"},
                                        "pause": {"type": "bool"},
                                        "size": {"type": "int"},
                                    },
                                },
                                "graceful_restart": {
                                    "type": "dict",
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                        "strict_lsa_checking": {
                                            "type": "bool"
                                        },
                                    },
                                },
                                "interface_id": {
                                    "type": "dict",
                                    "options": {
                                        "ios_if_index": {"type": "bool"},
                                        "snmp_if_index": {"type": "bool"},
                                    },
                                },
                                "limit": {
                                    "type": "dict",
                                    "options": {
                                        "dc": {
                                            "type": "dict",
                                            "options": {
                                                "number": {"type": "int"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                        "non_dc": {
                                            "type": "dict",
                                            "options": {
                                                "number": {"type": "int"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "local_rib_criteria": {
                                    "type": "dict",
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "forwarding_address": {"type": "bool"},
                                        "inter_area_summary": {"type": "bool"},
                                        "nssa_translation": {"type": "bool"},
                                    },
                                },
                                "log_adjacency_changes": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "detail": {"type": "bool"},
                                    },
                                },
                                "manet": {
                                    "type": "dict",
                                    "options": {
                                        "cache": {
                                            "type": "dict",
                                            "options": {
                                                "acknowledgement": {
                                                    "type": "int"
                                                },
                                                "update": {"type": "int"},
                                            },
                                        },
                                        "hello": {
                                            "type": "dict",
                                            "options": {
                                                "multicast": {"type": "bool"},
                                                "unicast": {"type": "bool"},
                                            },
                                        },
                                        "peering": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                                "per_interface": {
                                                    "type": "bool"
                                                },
                                                "redundancy": {"type": "int"},
                                            },
                                        },
                                        "willingness": {"type": "int"},
                                    },
                                },
                                "max_lsa": {
                                    "type": "dict",
                                    "options": {
                                        "number": {"type": "int"},
                                        "threshold_value": {"type": "int"},
                                        "ignore_count": {"type": "int"},
                                        "ignore_time": {"type": "int"},
                                        "reset_time": {"type": "int"},
                                        "warning_only": {"type": "bool"},
                                    },
                                },
                                "max_metric": {
                                    "type": "dict",
                                    "options": {
                                        "disable": {"type": "bool"},
                                        "external_lsa": {"type": "int"},
                                        "inter_area_lsas": {"type": "int"},
                                        "on_startup": {
                                            "type": "dict",
                                            "options": {
                                                "time": {"type": "int"},
                                                "wait_for_bgp": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "stub_prefix_lsa": {"type": "bool"},
                                    },
                                },
                                "maximum_paths": {"type": "int"},
                                "passive_interface": {"type": "str"},
                                "prefix_suppression": {
                                    "type": "dict",
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                                "queue_depth": {
                                    "type": "dict",
                                    "options": {
                                        "hello": {
                                            "type": "dict",
                                            "options": {
                                                "max_packets": {"type": "int"},
                                                "unlimited": {"type": "bool"},
                                            },
                                        },
                                        "update": {
                                            "type": "dict",
                                            "options": {
                                                "max_packets": {"type": "int"},
                                                "unlimited": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "router_id": {"type": "str"},
                                "shutdown": {
                                    "type": "dict",
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                                "summary_prefix": {
                                    "type": "dict",
                                    "options": {
                                        "address": {"type": "str"},
                                        "mask": {"type": "str"},
                                        "not_advertise": {"type": "bool"},
                                        "nssa_only": {"type": "bool"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "timers": {
                                    "type": "dict",
                                    "options": {
                                        "lsa": {"type": "int"},
                                        "manet": {
                                            "type": "dict",
                                            "options": {
                                                "cache": {
                                                    "type": "dict",
                                                    "options": {
                                                        "acknowledgement": {
                                                            "type": "int"
                                                        },
                                                        "redundancy": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                                "hello": {"type": "bool"},
                                                "peering": {
                                                    "type": "dict",
                                                    "options": {
                                                        "set": {
                                                            "type": "bool"
                                                        },
                                                        "per_interface": {
                                                            "type": "bool"
                                                        },
                                                        "redundancy": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                                "willingness": {"type": "int"},
                                            },
                                        },
                                        "pacing": {
                                            "type": "dict",
                                            "options": {
                                                "flood": {"type": "int"},
                                                "lsa_group": {"type": "int"},
                                                "retransmission": {
                                                    "type": "int"
                                                },
                                            },
                                        },
                                        "throttle": {
                                            "type": "dict",
                                            "options": {
                                                "lsa": {
                                                    "type": "dict",
                                                    "options": {
                                                        "first_delay": {
                                                            "type": "int"
                                                        },
                                                        "min_delay": {
                                                            "type": "int"
                                                        },
                                                        "max_delay": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                                "spf": {
                                                    "type": "dict",
                                                    "options": {
                                                        "receive_delay": {
                                                            "type": "int"
                                                        },
                                                        "between_delay": {
                                                            "type": "int"
                                                        },
                                                        "max_delay": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "adjacency": {
                            "type": "dict",
                            "options": {
                                "min_adjacency": {"type": "int"},
                                "max_adjacency": {"type": "int"},
                                "none": {"type": "bool"},
                            },
                        },
                        "areas": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "area_id": {"type": "str"},
                                "authentication": {
                                    "type": "dict",
                                    "options": {
                                        "key_chain": {"type": "str"},
                                        "ipsec": {
                                            "type": "dict",
                                            "options": {
                                                "spi": {"type": "int"},
                                                "md5": {"type": "int"},
                                                "sha1": {"type": "int"},
                                                "hex_string": {"type": "str"},
                                            },
                                        },
                                    },
                                },
                                "default_cost": {"type": "int"},
                                "nssa": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "default_information_originate": {
                                            "type": "dict",
                                            "options": {
                                                "metric": {"type": "int"},
                                                "metric_type": {
                                                    "type": "int",
                                                    "choices": [1, 2],
                                                },
                                                "nssa_only": {"type": "bool"},
                                            },
                                        },
                                        "no_redistribution": {"type": "bool"},
                                        "no_summary": {"type": "bool"},
                                        "translate": {
                                            "type": "str",
                                            "choices": [
                                                "always",
                                                "suppress-fa",
                                            ],
                                        },
                                    },
                                },
                                "stub": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "no_summary": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "authentication": {"type": "bool"},
                        "auto_cost": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "reference_bandwidth": {"type": "int"},
                            },
                        },
                        "bfd": {"type": "bool"},
                        "compatible": {
                            "type": "dict",
                            "options": {
                                "rfc1583": {"type": "bool"},
                                "rfc1587": {"type": "bool"},
                                "rfc5243": {"type": "bool"},
                            },
                        },
                        "event_log": {
                            "type": "dict",
                            "options": {
                                "enable": {"type": "bool"},
                                "one_shot": {"type": "bool"},
                                "pause": {"type": "bool"},
                                "size": {"type": "int"},
                            },
                        },
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "disable": {"type": "bool"},
                                "strict_lsa_checking": {"type": "bool"},
                            },
                        },
                        "help": {"type": "bool"},
                        "interface_id": {"type": "bool"},
                        "limit": {
                            "type": "dict",
                            "options": {
                                "dc": {
                                    "type": "dict",
                                    "options": {
                                        "number": {"type": "int"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                                "non_dc": {
                                    "type": "dict",
                                    "options": {
                                        "number": {"type": "int"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "local_rib_criteria": {
                            "type": "dict",
                            "options": {
                                "enable": {"type": "bool"},
                                "forwarding_address": {"type": "bool"},
                                "inter_area_summary": {"type": "bool"},
                                "nssa_translation": {"type": "bool"},
                            },
                        },
                        "log_adjacency_changes": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "detail": {"type": "bool"},
                            },
                        },
                        "manet": {
                            "type": "dict",
                            "options": {
                                "cache": {
                                    "type": "dict",
                                    "options": {
                                        "acknowledgement": {"type": "int"},
                                        "redundancy": {"type": "int"},
                                    },
                                },
                                "hello": {"type": "bool"},
                                "peering": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "per_interface": {"type": "bool"},
                                        "redundancy": {"type": "int"},
                                    },
                                },
                                "willingness": {"type": "int"},
                            },
                        },
                        "max_lsa": {
                            "type": "dict",
                            "options": {
                                "number": {"type": "int"},
                                "threshold_value": {"type": "int"},
                                "ignore_count": {"type": "int"},
                                "ignore_time": {"type": "int"},
                                "reset_time": {"type": "int"},
                                "warning_only": {"type": "bool"},
                            },
                        },
                        "max_metric": {
                            "type": "dict",
                            "options": {
                                "router_lsa": {
                                    "type": "bool",
                                    "required": True,
                                },
                                "external_lsa": {"type": "int"},
                                "include_stub": {"type": "bool"},
                                "on_startup": {
                                    "type": "dict",
                                    "options": {
                                        "time": {"type": "int"},
                                        "wait_for_bgp": {"type": "bool"},
                                    },
                                },
                                "summary_lsa": {"type": "int"},
                            },
                        },
                        "passive_interface": {"type": "str"},
                        "prefix_suppression": {"type": "bool"},
                        "queue_depth": {
                            "type": "dict",
                            "options": {
                                "hello": {
                                    "type": "dict",
                                    "options": {
                                        "max_packets": {"type": "int"},
                                        "unlimited": {"type": "bool"},
                                    },
                                }
                            },
                        },
                        "router_id": {"type": "str"},
                        "shutdown": {"type": "bool"},
                        "timers": {
                            "type": "dict",
                            "options": {
                                "lsa": {"type": "int"},
                                "manet": {
                                    "type": "dict",
                                    "options": {
                                        "cache": {
                                            "type": "dict",
                                            "options": {
                                                "acknowledgement": {
                                                    "type": "int"
                                                },
                                                "redundancy": {"type": "int"},
                                            },
                                        },
                                        "hello": {"type": "bool"},
                                        "peering": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "per_interface": {
                                                    "type": "bool"
                                                },
                                                "redundancy": {"type": "int"},
                                            },
                                        },
                                        "willingness": {"type": "int"},
                                    },
                                },
                                "pacing": {
                                    "type": "dict",
                                    "options": {
                                        "flood": {"type": "int"},
                                        "lsa_group": {"type": "int"},
                                        "retransmission": {"type": "int"},
                                    },
                                },
                                "throttle": {
                                    "type": "dict",
                                    "options": {
                                        "lsa": {
                                            "type": "dict",
                                            "options": {
                                                "first_delay": {"type": "int"},
                                                "min_delay": {"type": "int"},
                                                "max_delay": {"type": "int"},
                                            },
                                        },
                                        "spf": {
                                            "type": "dict",
                                            "options": {
                                                "receive_delay": {
                                                    "type": "int"
                                                },
                                                "between_delay": {
                                                    "type": "int"
                                                },
                                                "max_delay": {"type": "int"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    },
                }
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
