use Test2::V0;

BEGIN {
  skip_all 'Inline::C not installed or too old'
    unless eval { require Inline::C; Inline->VERSION('0.56') };

  require Path::Tiny;
  our $inline_dir = Path::Tiny->tempdir('neo4j-client-inline-XXXXXX');
  $ENV{PERL_INLINE_DIRECTORY} = $inline_dir->absolute->stringify;
}

use Inline with => 'Neo4j::Client';

use Inline C => 'DATA';

is log_level_4_as_string(), 'TRACE', 'indirect call';

done_testing;

__DATA__
__C__

const char *log_level_4_as_string() {
  return neo4j_log_level_str(4);
}
