package Amazon::API::ECS;

use strict;
use warnings;

use parent qw( Amazon::API );

our $VERSION = '1.3.5';

our @API_METHODS = qw{
  CreateCapacityProvider
  CreateCluster
  CreateService
  CreateTaskSet
  DeleteAccountSetting
  DeleteAttributes
  DeleteCapacityProvider
  DeleteCluster
  DeleteService
  DeleteTaskSet
  DeregisterContainerInstance
  DeregisterTaskDefinition
  DescribeCapacityProviders
  DescribeClusters
  DescribeContainerInstances
  DescribeServices
  DescribeTaskDefinition
  DescribeTasks
  DescribeTaskSets
  DiscoverPollEndpoint
  ExecuteCommand
  ListAccountSettings
  ListAttributes
  ListClusters
  ListContainerInstances
  ListServices
  ListTagsForResource
  ListTaskDefinitionFamilies
  ListTaskDefinitions
  ListTasks
  PutAccountSetting
  PutAccountSettingDefault
  PutAttributes
  PutClusterCapacityProviders
  RegisterContainerInstance
  RegisterTaskDefinition
  RunTask
  StartTask
  StopTask
  SubmitAttachmentStateChanges
  SubmitContainerStateChange
  SubmitTaskStateChange
  TagResource
  UntagResource
  UpdateCapacityProvider
  UpdateCluster
  UpdateClusterSettings
  UpdateContainerAgent
  UpdateContainerInstancesState
  UpdateService
  UpdateServicePrimaryTaskSet
  UpdateTaskSet
};

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref( $options[0] ) ? %{ $options[0] } : @options;

  return $class->SUPER::new(
    { service     => 'ecs',
      api         => 'AmazonEC2ContainerServiceV20141113',
      api_methods => \@API_METHODS,
      %options,
    }
  );
} ## end sub new

1;
