/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.css.CSSHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.Messages;
import java.io.StringReader;
import org.idpf.epubcheck.util.css.CssParser;
import org.idpf.epubcheck.util.css.CssSource;

public class CSSChecker
implements ContentChecker {
    private OCFPackage ocf;
    private Report report;
    private String path;
    private XRefChecker xrefChecker;
    private EPUBVersion version;
    private Mode mode;
    private String value;
    private int line;
    private int col;
    private boolean isStyleAttribute = false;

    public CSSChecker(OCFPackage ocf, Report report, String path, XRefChecker xrefChecker, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.version = version;
        this.mode = Mode.FILE;
    }

    public CSSChecker(OCFPackage ocf, Report report, String value, boolean isStyleAttribute, String path, int line, int col, XRefChecker xrefChecker, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.version = version;
        this.value = value;
        this.line = line;
        this.col = col;
        this.isStyleAttribute = isStyleAttribute;
        this.mode = Mode.STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runChecks() {
        CssSource source = null;
        try {
            if (this.mode == Mode.FILE && !this.ocf.hasEntry(this.path)) {
                this.report.error(null, 0, 0, String.format(Messages.MISSING_FILE, this.path));
                return;
            }
            if (this.mode == Mode.FILE) {
                String charset;
                source = new CssSource(this.path, this.ocf.getInputStream(this.path));
                if (source.getInputStream().getBomCharset().isPresent() && !(charset = ((String)source.getInputStream().getBomCharset().get()).toLowerCase()).equals("utf-8") && !charset.startsWith("utf-16")) {
                    this.report.error(this.path, -1, -1, String.format(Messages.UTF_NOT_SUPPORTED_BOM, charset));
                }
                if (source.getInputStream().getCssCharset().isPresent() && !(charset = ((String)source.getInputStream().getCssCharset().get()).toLowerCase()).equals("utf-8") && !charset.startsWith("utf-16")) {
                    this.report.error(this.path, 0, 0, String.format(Messages.UTF_NOT_SUPPORTED, charset));
                }
            }
            CSSHandler handler = new CSSHandler(this.path, this.xrefChecker, this.report, this.version);
            if (this.mode == Mode.STRING && this.line > -1) {
                handler.setLineOffset(this.line);
            }
            if (!this.isStyleAttribute) {
                if (this.mode == Mode.FILE) {
                    new CssParser().parse(source, handler, handler);
                } else {
                    new CssParser().parse(new StringReader(this.value), this.path, handler, handler);
                }
            } else {
                new CssParser().parseStyleAttribute(new StringReader(this.value), this.path, handler, handler);
            }
        }
        catch (Exception e) {
            this.report.error(this.path, -1, 0, e.getMessage());
        }
        finally {
            if (source != null) {
                try {
                    source.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static enum Mode {
        FILE,
        STRING;

    }
}

