/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.EarlyAccessRegistryManagerKt;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryManager;
import org.jetbrains.kotlin.com.intellij.util.text.StringKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bJ\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/EarlyAccessRegistryManager;", "", "()V", "DISABLE_SAVE_PROPERTY", "", "fileName", "getFileName$annotations", "getBoolean", "", "key", "getOrLoadMap", "", "getString", "invalidate", "", "setAndFlush", "data", "setBoolean", "value", "syncAndFlush", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEarlyAccessRegistryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManagerKt\n*L\n1#1,188:1\n51#2:189\n59#2:208\n59#2:209\n1#3:190\n172#4,17:191\n172#4,17:210\n*S KotlinDebug\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManager\n*L\n90#1:189\n123#1:208\n131#1:209\n114#1:191,17\n133#1:210,17\n*E\n"})
public final class EarlyAccessRegistryManager {
    @NotNull
    public static final EarlyAccessRegistryManager INSTANCE = new EarlyAccessRegistryManager();

    private EarlyAccessRegistryManager() {
    }

    public final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Boolean.parseBoolean(this.getString(key));
    }

    @Nullable
    public final String getString(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (((CharSequence)key).length() == 0) {
            EarlyAccessRegistryManagerKt.access$getLOG().error("Empty key");
            return null;
        }
        ConcurrentHashMap map = (ConcurrentHashMap)EarlyAccessRegistryManagerKt.access$getLazyMap$p().getValue();
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return StringKt.nullize$default(EarlyAccessRegistryManagerKt.access$getOrFromSystemProperty(map, key), false, 1, null);
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$serviceOrNull$iv = application;
        boolean $i$f$serviceOrNull = false;
        RegistryManager registryManager = $this$serviceOrNull$iv.getService(RegistryManager.class);
        if (registryManager == null) {
            return EarlyAccessRegistryManagerKt.access$getOrFromSystemProperty(map, key);
        }
        RegistryManager registryManager2 = registryManager;
        try {
            string = registryManager2.stringValue(key);
        }
        catch (MissingResourceException ignore) {
            string = null;
        }
        String value2 = string;
        if (value2 == null) {
            return null;
        }
        map.putIfAbsent(key, value2);
        String it = string = value2;
        boolean bl = false;
        return ((CharSequence)it).length() > 0 ? string : null;
    }
}

