﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sms-voice/PinpointSMSVoice_EXPORTS.h>
#include <aws/sms-voice/model/CloudWatchLogsDestination.h>
#include <aws/sms-voice/model/EventType.h>
#include <aws/sms-voice/model/KinesisFirehoseDestination.h>
#include <aws/sms-voice/model/SnsDestination.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoice {
namespace Model {

/**
 * An object that defines a single event destination.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/EventDestinationDefinition">AWS
 * API Reference</a></p>
 */
class EventDestinationDefinition {
 public:
  AWS_PINPOINTSMSVOICE_API EventDestinationDefinition() = default;
  AWS_PINPOINTSMSVOICE_API EventDestinationDefinition(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICE_API EventDestinationDefinition& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const CloudWatchLogsDestination& GetCloudWatchLogsDestination() const { return m_cloudWatchLogsDestination; }
  inline bool CloudWatchLogsDestinationHasBeenSet() const { return m_cloudWatchLogsDestinationHasBeenSet; }
  template <typename CloudWatchLogsDestinationT = CloudWatchLogsDestination>
  void SetCloudWatchLogsDestination(CloudWatchLogsDestinationT&& value) {
    m_cloudWatchLogsDestinationHasBeenSet = true;
    m_cloudWatchLogsDestination = std::forward<CloudWatchLogsDestinationT>(value);
  }
  template <typename CloudWatchLogsDestinationT = CloudWatchLogsDestination>
  EventDestinationDefinition& WithCloudWatchLogsDestination(CloudWatchLogsDestinationT&& value) {
    SetCloudWatchLogsDestination(std::forward<CloudWatchLogsDestinationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Indicates whether or not the event destination is enabled. If the event
   * destination is enabled, then Amazon Pinpoint sends response data to the
   * specified event destination.
   */
  inline bool GetEnabled() const { return m_enabled; }
  inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }
  inline void SetEnabled(bool value) {
    m_enabledHasBeenSet = true;
    m_enabled = value;
  }
  inline EventDestinationDefinition& WithEnabled(bool value) {
    SetEnabled(value);
    return *this;
  }
  ///@}

  ///@{

  inline const KinesisFirehoseDestination& GetKinesisFirehoseDestination() const { return m_kinesisFirehoseDestination; }
  inline bool KinesisFirehoseDestinationHasBeenSet() const { return m_kinesisFirehoseDestinationHasBeenSet; }
  template <typename KinesisFirehoseDestinationT = KinesisFirehoseDestination>
  void SetKinesisFirehoseDestination(KinesisFirehoseDestinationT&& value) {
    m_kinesisFirehoseDestinationHasBeenSet = true;
    m_kinesisFirehoseDestination = std::forward<KinesisFirehoseDestinationT>(value);
  }
  template <typename KinesisFirehoseDestinationT = KinesisFirehoseDestination>
  EventDestinationDefinition& WithKinesisFirehoseDestination(KinesisFirehoseDestinationT&& value) {
    SetKinesisFirehoseDestination(std::forward<KinesisFirehoseDestinationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<EventType>& GetMatchingEventTypes() const { return m_matchingEventTypes; }
  inline bool MatchingEventTypesHasBeenSet() const { return m_matchingEventTypesHasBeenSet; }
  template <typename MatchingEventTypesT = Aws::Vector<EventType>>
  void SetMatchingEventTypes(MatchingEventTypesT&& value) {
    m_matchingEventTypesHasBeenSet = true;
    m_matchingEventTypes = std::forward<MatchingEventTypesT>(value);
  }
  template <typename MatchingEventTypesT = Aws::Vector<EventType>>
  EventDestinationDefinition& WithMatchingEventTypes(MatchingEventTypesT&& value) {
    SetMatchingEventTypes(std::forward<MatchingEventTypesT>(value));
    return *this;
  }
  inline EventDestinationDefinition& AddMatchingEventTypes(EventType value) {
    m_matchingEventTypesHasBeenSet = true;
    m_matchingEventTypes.push_back(value);
    return *this;
  }
  ///@}

  ///@{

  inline const SnsDestination& GetSnsDestination() const { return m_snsDestination; }
  inline bool SnsDestinationHasBeenSet() const { return m_snsDestinationHasBeenSet; }
  template <typename SnsDestinationT = SnsDestination>
  void SetSnsDestination(SnsDestinationT&& value) {
    m_snsDestinationHasBeenSet = true;
    m_snsDestination = std::forward<SnsDestinationT>(value);
  }
  template <typename SnsDestinationT = SnsDestination>
  EventDestinationDefinition& WithSnsDestination(SnsDestinationT&& value) {
    SetSnsDestination(std::forward<SnsDestinationT>(value));
    return *this;
  }
  ///@}
 private:
  CloudWatchLogsDestination m_cloudWatchLogsDestination;
  bool m_cloudWatchLogsDestinationHasBeenSet = false;

  bool m_enabled{false};
  bool m_enabledHasBeenSet = false;

  KinesisFirehoseDestination m_kinesisFirehoseDestination;
  bool m_kinesisFirehoseDestinationHasBeenSet = false;

  Aws::Vector<EventType> m_matchingEventTypes;
  bool m_matchingEventTypesHasBeenSet = false;

  SnsDestination m_snsDestination;
  bool m_snsDestinationHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoice
}  // namespace Aws
