﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datasync/DataSync_EXPORTS.h>

namespace Aws {
namespace DataSync {
namespace Model {
enum class HdfsDataTransferProtection { NOT_SET, DISABLED, AUTHENTICATION, INTEGRITY, PRIVACY };

namespace HdfsDataTransferProtectionMapper {
AWS_DATASYNC_API HdfsDataTransferProtection GetHdfsDataTransferProtectionForName(const Aws::String& name);

AWS_DATASYNC_API Aws::String GetNameForHdfsDataTransferProtection(HdfsDataTransferProtection value);
}  // namespace HdfsDataTransferProtectionMapper
}  // namespace Model
}  // namespace DataSync
}  // namespace Aws
