/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetUserResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetUserRequest
extends RequestBase {
    private final List<String> username;
    @Nullable
    private final Boolean withProfileUid;
    public static final Endpoint<GetUserRequest, GetUserResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetUserRequest, GetUserResponse>("es/security.get_user", request -> "GET", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.username())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _username = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.username())) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("username", request.username.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.withProfileUid != null) {
            params.put("with_profile_uid", String.valueOf(request.withProfileUid));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetUserResponse._DESERIALIZER);

    private GetUserRequest(Builder builder) {
        this.username = ApiTypeHelper.unmodifiable(builder.username);
        this.withProfileUid = builder.withProfileUid;
    }

    public static GetUserRequest of(Function<Builder, ObjectBuilder<GetUserRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> username() {
        return this.username;
    }

    @Nullable
    public final Boolean withProfileUid() {
        return this.withProfileUid;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetUserRequest> {
        @Nullable
        private List<String> username;
        @Nullable
        private Boolean withProfileUid;

        public final Builder username(List<String> list) {
            this.username = Builder._listAddAll(this.username, list);
            return this;
        }

        public final Builder username(String value, String ... values) {
            this.username = Builder._listAdd(this.username, value, values);
            return this;
        }

        public final Builder withProfileUid(@Nullable Boolean value) {
            this.withProfileUid = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetUserRequest build() {
            this._checkSingleUse();
            return new GetUserRequest(this);
        }
    }
}

