/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.util.List;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.web.client.RestClient;

public class RestClientBuilderConfigurer {
    private List<RestClientCustomizer> customizers;

    void setRestClientCustomizers(List<RestClientCustomizer> customizers) {
        this.customizers = customizers;
    }

    public RestClient.Builder configure(RestClient.Builder builder) {
        this.applyCustomizers(builder);
        return builder;
    }

    private void applyCustomizers(RestClient.Builder builder) {
        if (this.customizers != null) {
            for (RestClientCustomizer customizer : this.customizers) {
                customizer.customize(builder);
            }
        }
    }
}

