/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.utils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ResponseUtils {
    private static final String CHUNKED = "chunked";

    private ResponseUtils() {
    }

    public static CachedBodyOutputMessage newCachedBodyOutputMessage(ServerWebExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        headers.putAll((Map)exchange.getRequest().getHeaders());
        headers.remove((Object)"Content-Length");
        return new CachedBodyOutputMessage(exchange, headers);
    }

    public static ClientResponse buildClientResponse(ServerHttpResponse response, Publisher<? extends DataBuffer> body) {
        ClientResponse.Builder builder = ClientResponse.create((HttpStatusCode)Objects.requireNonNull(response.getStatusCode()), ResponseUtils.getReaders());
        return builder.headers(headers -> headers.putAll((Map)response.getHeaders())).cookies(cookies -> response.getCookies()).body(Flux.from(body)).build();
    }

    public static Mono<DataBuffer> fixBodyMessage(ServerHttpResponse response, CachedBodyOutputMessage outputMessage) {
        ResponseUtils.fixHeaders(response.getHeaders());
        return DataBufferUtils.join(outputMessage.getBody());
    }

    public static <T> Mono<T> release(CachedBodyOutputMessage outputMessage, Throwable throwable) {
        if (Boolean.TRUE.equals(outputMessage.getCache())) {
            return outputMessage.getBody().map(DataBufferUtils::release).then(Mono.error((Throwable)throwable));
        }
        return Mono.error((Throwable)throwable);
    }

    public static HttpHeaders chunkedHeader(HttpHeaders headers) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll((Map)headers);
        ResponseUtils.fixHeaders(httpHeaders);
        return httpHeaders;
    }

    public static <T, P extends Publisher<T>> Mono<Void> writeWith(ClientResponse clientResponse, ServerWebExchange exchange, P publisher, Class<T> elementClass) {
        BodyInserter bodyInserter = BodyInserters.fromPublisher(publisher, elementClass);
        CachedBodyOutputMessage outputMessage = ResponseUtils.newCachedBodyOutputMessage(exchange);
        return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
            Mono<DataBuffer> messageBody = ResponseUtils.fixBodyMessage(exchange.getResponse(), outputMessage);
            exchange.getAttributes().put("webHandlerClientResponse", clientResponse);
            return exchange.getResponse().writeWith(messageBody);
        })).onErrorResume(throwable -> ResponseUtils.release(outputMessage, throwable));
    }

    private static List<HttpMessageReader<?>> getReaders() {
        return ((ServerCodecConfigurer)SpringBeanUtils.getInstance().getBean(ServerCodecConfigurer.class)).getReaders();
    }

    private static void fixHeaders(HttpHeaders httpHeaders) {
        httpHeaders.remove((Object)"Content-Length");
        httpHeaders.set("Transfer-Encoding", CHUNKED);
    }
}

