/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.kafka.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.logging.kafka.client.KafkaLogCollectClient;
import org.apache.shenyu.plugin.logging.kafka.config.KafkaLogCollectConfig;

public class KafkaClientCache {
    private static final Map<String, KafkaLogCollectClient> CLIENT_CACHE = Maps.newConcurrentMap();

    public static KafkaClientCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void initKafkaClient(String selectorId, KafkaLogCollectConfig.LogApiConfig kafkaUpstream) {
        KafkaLogCollectConfig.KafkaLogConfig globalLogConfig = (KafkaLogCollectConfig.KafkaLogConfig)((Object)Singleton.INST.get(KafkaLogCollectConfig.KafkaLogConfig.class));
        if (Objects.nonNull((Object)kafkaUpstream) && Objects.nonNull(kafkaUpstream.getBootstrapServer())) {
            globalLogConfig = KafkaClientCache.copyConfig(kafkaUpstream);
        }
        KafkaLogCollectClient kafkaLogCollectClient = new KafkaLogCollectClient();
        kafkaLogCollectClient.initClient(globalLogConfig);
        CLIENT_CACHE.put(selectorId, kafkaLogCollectClient);
    }

    public KafkaLogCollectClient getKafkaClient(String selectorId) {
        return CLIENT_CACHE.get(selectorId);
    }

    public Map<String, KafkaLogCollectClient> getClientCache() {
        return CLIENT_CACHE;
    }

    public void invalidate(String path) {
        KafkaLogCollectClient client = CLIENT_CACHE.get(path);
        if (Objects.nonNull((Object)client)) {
            client.close();
            CLIENT_CACHE.remove(path);
        }
    }

    public void invalidateAll() {
        if (CLIENT_CACHE.isEmpty()) {
            return;
        }
        CLIENT_CACHE.values().forEach(client -> {
            try {
                if (Objects.nonNull(client)) {
                    client.close();
                }
            }
            catch (Exception e) {
                ShenyuPlugin.LOG.error("Failed to close client {}", (Object)client, (Object)e);
            }
        });
        CLIENT_CACHE.clear();
    }

    public static KafkaLogCollectConfig.KafkaLogConfig copyConfig(KafkaLogCollectConfig.LogApiConfig rabbitmqLogUpstream) {
        KafkaLogCollectConfig.KafkaLogConfig kafkaLogConfig = new KafkaLogCollectConfig.KafkaLogConfig();
        kafkaLogConfig.setTopic(rabbitmqLogUpstream.getTopic());
        kafkaLogConfig.setBootstrapServer(rabbitmqLogUpstream.getBootstrapServer());
        kafkaLogConfig.setProducerGroup(rabbitmqLogUpstream.getProducerGroup());
        kafkaLogConfig.setCompressAlg(rabbitmqLogUpstream.getCompressAlg());
        kafkaLogConfig.setSecurityProtocol(rabbitmqLogUpstream.getSecurityProtocol());
        kafkaLogConfig.setSaslMechanism(rabbitmqLogUpstream.getSaslMechanism());
        kafkaLogConfig.setUserName(rabbitmqLogUpstream.getUserName());
        kafkaLogConfig.setPassWord(rabbitmqLogUpstream.getPassWord());
        return kafkaLogConfig;
    }

    static final class ApplicationConfigCacheInstance {
        static final KafkaClientCache INSTANCE = new KafkaClientCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

