/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ClusterStateFailureException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ClusterNodeResourceProvider;
import org.springframework.data.redis.connection.ClusterTopology;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisClientUtils;
import org.springframework.data.redis.connection.jedis.JedisClusterGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterHashCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterKeyCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterListCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterScriptingCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterServerCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterSetCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterStreamCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterStringCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisExceptionConverter;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.providers.ClusterConnectionProvider;

public class JedisClusterConnection
implements RedisClusterConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisExceptionConverter.INSTANCE);
    private final Log log = LogFactory.getLog(this.getClass());
    private final JedisCluster cluster;
    private final JedisClusterGeoCommands geoCommands = new JedisClusterGeoCommands(this);
    private final JedisClusterHashCommands hashCommands = new JedisClusterHashCommands(this);
    private final JedisClusterHyperLogLogCommands hllCommands = new JedisClusterHyperLogLogCommands(this);
    private final JedisClusterKeyCommands keyCommands = new JedisClusterKeyCommands(this);
    private final JedisClusterListCommands listCommands = new JedisClusterListCommands(this);
    private final JedisClusterSetCommands setCommands = new JedisClusterSetCommands(this);
    private final JedisClusterServerCommands serverCommands = new JedisClusterServerCommands(this);
    private final JedisClusterStreamCommands streamCommands = new JedisClusterStreamCommands(this);
    private final JedisClusterStringCommands stringCommands = new JedisClusterStringCommands(this);
    private final JedisClusterZSetCommands zSetCommands = new JedisClusterZSetCommands(this);
    private boolean closed;
    private final ClusterTopologyProvider topologyProvider;
    private final ClusterCommandExecutor clusterCommandExecutor;
    private final boolean disposeClusterCommandExecutorOnClose;
    @Nullable
    private volatile JedisSubscription subscription;

    public JedisClusterConnection(JedisCluster cluster) {
        Assert.notNull((Object)cluster, (String)"JedisCluster must not be null");
        this.cluster = cluster;
        this.closed = false;
        this.topologyProvider = new JedisClusterTopologyProvider(cluster);
        this.clusterCommandExecutor = new ClusterCommandExecutor(this.topologyProvider, new JedisClusterNodeResourceProvider(cluster, this.topologyProvider), EXCEPTION_TRANSLATION);
        this.disposeClusterCommandExecutorOnClose = true;
        try {
            DirectFieldAccessor executorDfa = new DirectFieldAccessor((Object)cluster);
            Object custerCommandExecutor = executorDfa.getPropertyValue("executor");
            DirectFieldAccessor dfa = new DirectFieldAccessor(custerCommandExecutor);
            this.clusterCommandExecutor.setMaxRedirects((Integer)dfa.getPropertyValue("maxRedirects"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JedisClusterConnection(JedisCluster cluster, ClusterCommandExecutor executor) {
        this(cluster, executor, new JedisClusterTopologyProvider(cluster));
    }

    public JedisClusterConnection(JedisCluster cluster, ClusterCommandExecutor executor, ClusterTopologyProvider topologyProvider) {
        Assert.notNull((Object)cluster, (String)"JedisCluster must not be null");
        Assert.notNull((Object)executor, (String)"ClusterCommandExecutor must not be null");
        Assert.notNull((Object)topologyProvider, (String)"ClusterTopologyProvider must not be null");
        this.closed = false;
        this.cluster = cluster;
        this.topologyProvider = topologyProvider;
        this.clusterCommandExecutor = executor;
        this.disposeClusterCommandExecutorOnClose = false;
    }

    @Override
    @Nullable
    public Object execute(String command, byte[] ... args) {
        Assert.notNull((Object)command, (String)"Command must not be null");
        Assert.notNull((Object)args, (String)"Args must not be null");
        JedisClusterCommandCallback commandCallback = jedis -> jedis.sendCommand(JedisClientUtils.getCommand(command), args);
        return this.clusterCommandExecutor.executeCommandOnArbitraryNode(commandCallback).getValue();
    }

    @Override
    @Nullable
    public <T> T execute(String command, byte[] key, Collection<byte[]> args) {
        Assert.notNull((Object)command, (String)"Command must not be null");
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(args, (String)"Args must not be null");
        byte[][] commandArgs = JedisClusterConnection.getCommandArguments(key, args);
        RedisClusterNode keyMaster = this.topologyProvider.getTopology().getKeyServingMasterNode(key);
        JedisClusterCommandCallback commandCallback = jedis -> jedis.sendCommand(JedisClientUtils.getCommand(command), commandArgs);
        return this.clusterCommandExecutor.executeCommandOnSingleNode(commandCallback, keyMaster).getValue();
    }

    private static byte[][] getCommandArguments(byte[] key, Collection<byte[]> args) {
        byte[][] commandArgs = new byte[args.size() + 1][];
        commandArgs[0] = key;
        int targetIndex = 1;
        for (byte[] binaryArgument : args) {
            commandArgs[targetIndex++] = binaryArgument;
        }
        return commandArgs;
    }

    @Nullable
    public <T> List<T> execute(String command, Collection<byte[]> keys, Collection<byte[]> args) {
        Assert.notNull((Object)command, (String)"Command must not be null");
        Assert.notNull(keys, (String)"Key must not be null");
        Assert.notNull(args, (String)"Args must not be null");
        JedisMultiKeyClusterCommandCallback commandCallback = (jedis, key) -> jedis.sendCommand(JedisClientUtils.getCommand(command), JedisClusterConnection.getCommandArguments(key, args));
        return this.clusterCommandExecutor.executeMultiKeyCommand(commandCallback, keys).resultsAsList();
    }

    @Override
    public RedisCommands commands() {
        return this;
    }

    @Override
    public RedisClusterCommands clusterCommands() {
        return this;
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return this.geoCommands;
    }

    @Override
    public RedisHashCommands hashCommands() {
        return this.hashCommands;
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this.hllCommands;
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return this.keyCommands;
    }

    @Override
    public RedisListCommands listCommands() {
        return this.listCommands;
    }

    @Override
    public RedisSetCommands setCommands() {
        return this.setCommands;
    }

    @Override
    public RedisClusterServerCommands serverCommands() {
        return this.serverCommands;
    }

    @Override
    public RedisStreamCommands streamCommands() {
        return this.streamCommands;
    }

    @Override
    public RedisStringCommands stringCommands() {
        return this.stringCommands;
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return this.zSetCommands;
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return new JedisClusterScriptingCommands(this);
    }

    @Override
    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return this.keyCommands.keys(node, pattern);
    }

    @Override
    public Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        return this.keyCommands.scan(node, options);
    }

    @Override
    public byte[] randomKey(RedisClusterNode node) {
        return this.keyCommands.randomKey(node);
    }

    @Override
    public void multi() {
        throw new InvalidDataAccessApiUsageException("MULTI is currently not supported in cluster mode");
    }

    @Override
    public List<Object> exec() {
        throw new InvalidDataAccessApiUsageException("EXEC is currently not supported in cluster mode");
    }

    @Override
    public void discard() {
        throw new InvalidDataAccessApiUsageException("DISCARD is currently not supported in cluster mode");
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new InvalidDataAccessApiUsageException("WATCH is currently not supported in cluster mode");
    }

    @Override
    public void unwatch() {
        throw new InvalidDataAccessApiUsageException("UNWATCH is currently not supported in cluster mode");
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            return this.cluster.publish(channel, message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            String message = "Connection already subscribed; use the connection Subscription to cancel or add new channels";
            throw new RedisSubscribedConnectionException(message);
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            this.cluster.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            String message = "Connection already subscribed; use the connection Subscription to cancel or add new channels";
            throw new RedisSubscribedConnectionException(message);
        }
        try {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            this.cluster.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        if (dbIndex != 0) {
            throw new InvalidDataAccessApiUsageException("Cannot SELECT non zero index in cluster mode");
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        throw new InvalidDataAccessApiUsageException("Echo not supported in cluster mode");
    }

    @Override
    @Nullable
    public String ping() {
        JedisClusterCommandCallback command = Jedis::ping;
        return !this.clusterCommandExecutor.executeCommandOnAllNodes(command).resultsAsList().isEmpty() ? "PONG" : null;
    }

    @Override
    public String ping(RedisClusterNode node) {
        JedisClusterCommandCallback command = Jedis::ping;
        return (String)this.clusterCommandExecutor.executeCommandOnSingleNode(command, node).getValue();
    }

    @Override
    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        Assert.notNull((Object)node, (String)"Node must not be null");
        Assert.notNull((Object)((Object)mode), (String)"AddSlots mode must not be null");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(node);
        String nodeId = nodeToUse.getId();
        JedisClusterCommandCallback command = jedis -> switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case RedisClusterCommands.AddSlots.IMPORTING -> jedis.clusterSetSlotImporting(slot, nodeId);
            case RedisClusterCommands.AddSlots.MIGRATING -> jedis.clusterSetSlotMigrating(slot, nodeId);
            case RedisClusterCommands.AddSlots.STABLE -> jedis.clusterSetSlotStable(slot);
            case RedisClusterCommands.AddSlots.NODE -> jedis.clusterSetSlotNode(slot, nodeId);
        };
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, node);
    }

    @Override
    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        JedisClusterCommandCallback command = jedis -> JedisConverters.stringListToByteList().convert(jedis.clusterGetKeysInSlot(slot, this.nullSafeIntValue(count)));
        ClusterCommandExecutor.NodeResult result = this.clusterCommandExecutor.executeCommandOnSingleNode(command, node);
        return (List)result.getValue();
    }

    private int nullSafeIntValue(@Nullable Integer value) {
        return value != null ? value : Integer.MAX_VALUE;
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        JedisClusterCommandCallback command = jedis -> jedis.clusterAddSlots(slots);
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, node);
    }

    @Override
    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null");
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        JedisClusterCommandCallback command = jedis -> jedis.clusterCountKeysInSlot(slot);
        return (Long)this.clusterCommandExecutor.executeCommandOnSingleNode(command, node).getValue();
    }

    @Override
    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        JedisClusterCommandCallback command = jedis -> jedis.clusterDelSlots(slots);
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, node);
    }

    @Override
    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)range, (String)"Range must not be null");
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    @Override
    public void clusterForget(RedisClusterNode node) {
        LinkedHashSet<RedisClusterNode> nodes = new LinkedHashSet<RedisClusterNode>(this.topologyProvider.getTopology().getActiveMasterNodes());
        RedisClusterNode nodeToRemove = this.topologyProvider.getTopology().lookup(node);
        nodes.remove(nodeToRemove);
        JedisClusterCommandCallback command = jedis -> jedis.clusterForget(node.getId());
        this.clusterCommandExecutor.executeCommandAsyncOnNodes(command, nodes);
    }

    @Override
    public void clusterMeet(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0");
        JedisClusterCommandCallback command = jedis -> jedis.clusterMeet(node.getHost(), node.getPort().intValue());
        this.clusterCommandExecutor.executeCommandOnAllNodes(command);
    }

    @Override
    public void clusterReplicate(RedisClusterNode master, RedisClusterNode replica) {
        RedisClusterNode masterNode = this.topologyProvider.getTopology().lookup(master);
        JedisClusterCommandCallback command = jedis -> jedis.clusterReplicate(masterNode.getId());
        this.clusterCommandExecutor.executeCommandOnSingleNode(command, replica);
    }

    @Override
    public Integer clusterGetSlotForKey(byte[] key) {
        JedisClusterCommandCallback command = jedis -> Long.valueOf(jedis.clusterKeySlot(JedisConverters.toString(key))).intValue();
        return (Integer)this.clusterCommandExecutor.executeCommandOnArbitraryNode(command).getValue();
    }

    @Override
    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.topologyProvider.getTopology().getKeyServingMasterNode(key);
    }

    @Override
    @Nullable
    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        for (RedisClusterNode node : this.topologyProvider.getTopology().getSlotServingNodes(slot)) {
            if (!node.isMaster()) continue;
            return node;
        }
        return null;
    }

    public Set<RedisClusterNode> clusterGetNodes() {
        return this.topologyProvider.getTopology().getNodes();
    }

    public Set<RedisClusterNode> clusterGetReplicas(RedisClusterNode master) {
        Assert.notNull((Object)master, (String)"Master cannot be null");
        RedisClusterNode nodeToUse = this.topologyProvider.getTopology().lookup(master);
        JedisClusterCommandCallback command = jedis -> jedis.clusterSlaves(nodeToUse.getId());
        List clusterNodes = (List)this.clusterCommandExecutor.executeCommandOnSingleNode(command, master).getValue();
        return JedisConverters.toSetOfRedisClusterNodes(clusterNodes);
    }

    @Override
    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterReplicaMap() {
        JedisClusterCommandCallback command = jedis -> JedisConverters.toSetOfRedisClusterNodes(jedis.clusterSlaves(jedis.clusterMyId()));
        Set<RedisClusterNode> activeMasterNodes = this.topologyProvider.getTopology().getActiveMasterNodes();
        List nodeResults = this.clusterCommandExecutor.executeCommandAsyncOnNodes(command, activeMasterNodes).getResults();
        LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new LinkedHashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (ClusterCommandExecutor.NodeResult nodeResult : nodeResults) {
            result.put(nodeResult.getNode(), (Collection)nodeResult.getValue());
        }
        return result;
    }

    @Override
    public ClusterInfo clusterGetClusterInfo() {
        JedisClusterCommandCallback command = Jedis::clusterInfo;
        String source = (String)this.clusterCommandExecutor.executeCommandOnArbitraryNode(command).getValue();
        return new ClusterInfo(JedisConverters.toProperties(source));
    }

    protected DataAccessException convertJedisAccessException(Exception cause) {
        DataAccessException translated = EXCEPTION_TRANSLATION.translate(cause);
        return translated != null ? translated : new RedisSystemException(cause.getMessage(), cause);
    }

    @Override
    public void close() throws DataAccessException {
        if (!this.closed && this.disposeClusterCommandExecutorOnClose) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public JedisCluster getNativeConnection() {
        return this.cluster;
    }

    @Override
    public boolean isQueueing() {
        return false;
    }

    @Override
    public boolean isPipelined() {
        return false;
    }

    @Override
    public void openPipeline() {
        throw new InvalidDataAccessApiUsageException("Pipeline is not supported for JedisClusterConnection");
    }

    @Override
    public List<Object> closePipeline() throws RedisPipelineException {
        throw new InvalidDataAccessApiUsageException("Pipeline is not supported for JedisClusterConnection");
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        throw new InvalidDataAccessApiUsageException("Sentinel is not supported for JedisClusterConnection");
    }

    @Override
    public void rewriteConfig() {
        this.serverCommands().rewriteConfig();
    }

    protected JedisCluster getCluster() {
        return this.cluster;
    }

    protected ClusterCommandExecutor getClusterCommandExecutor() {
        return this.clusterCommandExecutor;
    }

    protected ClusterTopologyProvider getTopologyProvider() {
        return this.topologyProvider;
    }

    public static class JedisClusterTopologyProvider
    implements ClusterTopologyProvider {
        private long time = 0L;
        private final long cacheTimeMs;
        @Nullable
        private ClusterTopology cached;
        private final JedisCluster cluster;

        public JedisClusterTopologyProvider(JedisCluster cluster) {
            this(cluster, Duration.ofMillis(100L));
        }

        public JedisClusterTopologyProvider(JedisCluster cluster, Duration cacheTimeout) {
            Assert.notNull((Object)cluster, (String)"JedisCluster must not be null");
            Assert.notNull((Object)cacheTimeout, (String)"Cache timeout must not be null");
            Assert.isTrue((!cacheTimeout.isNegative() ? 1 : 0) != 0, (String)"Cache timeout must not be negative");
            this.cluster = cluster;
            this.cacheTimeMs = cacheTimeout.toMillis();
        }

        @Override
        public ClusterTopology getTopology() {
            if (this.cached != null && this.shouldUseCachedValue()) {
                return this.cached;
            }
            LinkedHashMap<String, Exception> errors = new LinkedHashMap<String, Exception>();
            ArrayList list = new ArrayList(this.cluster.getClusterNodes().entrySet());
            Collections.shuffle(list);
            for (Map.Entry entry : list) {
                ClusterTopology throwable2;
                block11: {
                    Connection connection = ((ConnectionPool)entry.getValue()).getResource();
                    try {
                        this.time = System.currentTimeMillis();
                        Set<RedisClusterNode> nodes = Converters.toSetOfRedisClusterNodes(new Jedis(connection).clusterNodes());
                        throwable2 = this.cached = new ClusterTopology(nodes);
                        if (connection == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            errors.put((String)entry.getKey(), ex);
                        }
                    }
                    connection.close();
                }
                return throwable2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : errors.entrySet()) {
                stringBuilder.append(String.format("\r\n\t- %s failed: %s", entry.getKey(), ((Exception)entry.getValue()).getMessage()));
            }
            throw new ClusterStateFailureException("Could not retrieve cluster information; CLUSTER NODES returned with error" + stringBuilder);
        }

        protected boolean shouldUseCachedValue() {
            return this.time + this.cacheTimeMs > System.currentTimeMillis();
        }
    }

    static class JedisClusterNodeResourceProvider
    implements ClusterNodeResourceProvider {
        private final JedisCluster cluster;
        private final ClusterTopologyProvider topologyProvider;
        private final ClusterConnectionProvider connectionHandler;

        JedisClusterNodeResourceProvider(JedisCluster cluster, ClusterTopologyProvider topologyProvider) {
            DirectFieldAccessFallbackBeanWrapper accessor;
            this.cluster = cluster;
            this.topologyProvider = topologyProvider;
            this.connectionHandler = cluster != null ? ((accessor = new DirectFieldAccessFallbackBeanWrapper((Object)cluster)).isReadableProperty("connectionHandler") ? (ClusterConnectionProvider)accessor.getPropertyValue("connectionHandler") : null) : null;
        }

        public Jedis getResourceForSpecificNode(RedisClusterNode node) {
            Assert.notNull((Object)node, (String)"Cannot get Pool for 'null' node");
            ConnectionPool pool = this.getResourcePoolForSpecificNode(node);
            if (pool != null) {
                return new Jedis(pool.getResource());
            }
            Connection connection = this.getConnectionForSpecificNode(node);
            if (connection != null) {
                return new Jedis(connection);
            }
            throw new DataAccessResourceFailureException(String.format("Node %s is unknown to cluster", node));
        }

        private ConnectionPool getResourcePoolForSpecificNode(RedisClusterNode node) {
            Map clusterNodes = this.cluster.getClusterNodes();
            if (clusterNodes.containsKey(node.asString())) {
                return (ConnectionPool)clusterNodes.get(node.asString());
            }
            return null;
        }

        private Connection getConnectionForSpecificNode(RedisClusterNode node) {
            RedisClusterNode member = this.topologyProvider.getTopology().lookup(node);
            if (!member.hasValidHost()) {
                throw new DataAccessResourceFailureException(String.format("Cannot obtain connection to node %ss as it is not associated with a hostname", node.getId()));
            }
            if (member != null && this.connectionHandler != null) {
                return this.connectionHandler.getConnection(new HostAndPort(member.getHost(), member.getPort().intValue()));
            }
            return null;
        }

        @Override
        public void returnResourceForSpecificNode(RedisClusterNode node, Object client) {
            ((Jedis)client).close();
        }
    }

    protected static interface JedisClusterCommandCallback<T>
    extends ClusterCommandExecutor.ClusterCommandCallback<Jedis, T> {
    }

    protected static interface JedisMultiKeyClusterCommandCallback<T>
    extends ClusterCommandExecutor.MultiKeyClusterCommandCallback<Jedis, T> {
    }
}

