/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mode.cluster.filter;

import jakarta.annotation.Resource;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.admin.model.dto.ClusterMasterDTO;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public class ClusterForwardFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterForwardFilter.class);
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    private final RestTemplate restTemplate;
    @Resource
    private ClusterSelectMasterService clusterSelectMasterService;
    @Resource
    private ClusterProperties clusterProperties;

    public ClusterForwardFilter(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String requestContextPath = request.getContextPath();
        String simpleUri = uri.replaceAll(requestContextPath, "");
        if (StringUtils.equals((CharSequence)HttpMethod.OPTIONS.name(), (CharSequence)method)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("method is OPTIONS or GET, no forward :{}", (Object)simpleUri);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.clusterSelectMasterService.isMaster()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("this node is master, no forward :{}", (Object)simpleUri);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean shouldIgnore = this.clusterProperties.getIgnoredList().stream().anyMatch(x -> PATH_MATCHER.match(x, simpleUri));
        if (shouldIgnore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("shouldIgnore, no forward :{}", (Object)simpleUri);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean shouldForward = this.clusterProperties.getForwardList().stream().anyMatch(x -> PATH_MATCHER.match(x, simpleUri));
        if (!shouldForward) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("!shouldForward, no forward :{}", (Object)simpleUri);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.forwardRequest(request, response);
    }

    private void forwardRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String targetUrl = this.getForwardingUrl(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("forwarding current uri: {} method: {} request to target url: {}", new Object[]{request.getRequestURI(), request.getMethod(), targetUrl});
        }
        HttpHeaders headers = new HttpHeaders();
        this.copyHeaders(request, headers);
        HttpEntity requestEntity = new HttpEntity((Object)this.getBody(request), (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.valueOf((String)request.getMethod()), requestEntity, byte[].class, new Object[0]);
        response.setStatus(responseEntity.getStatusCode().value());
        this.copyHeaders(responseEntity.getHeaders(), response);
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
        IOUtils.copy((InputStream)new ByteArrayInputStream(Objects.requireNonNull((byte[])responseEntity.getBody())), (OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
    }

    @NotNull
    private String getForwardingUrl(HttpServletRequest request) {
        String currentContextPath;
        ClusterMasterDTO master = this.clusterSelectMasterService.getMaster();
        String host = master.getMasterHost();
        String port = master.getMasterPort();
        String masterContextPath = master.getContextPath();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)URI.create(request.getRequestURI())).scheme(request.getScheme()).host(host).port(port).query(request.getQueryString());
        Object originalPath = builder.build().getPath();
        if (StringUtils.isNotEmpty((CharSequence)originalPath) && StringUtils.isNotEmpty((CharSequence)(currentContextPath = request.getContextPath())) && ((String)originalPath).startsWith(currentContextPath)) {
            originalPath = ((String)originalPath).substring(((String)originalPath).indexOf(currentContextPath) + currentContextPath.length());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{masterContextPath})) {
            originalPath = masterContextPath + (String)originalPath;
        }
        builder.replacePath((String)originalPath);
        return builder.toUriString();
    }

    private void copyHeaders(HttpServletRequest request, HttpHeaders headers) {
        Collections.list(request.getHeaderNames()).forEach(headerName -> headers.add(headerName, this.removeSpecial(request.getHeader(headerName))));
    }

    private void copyHeaders(HttpHeaders sourceHeaders, HttpServletResponse response) {
        sourceHeaders.forEach((headerName, headerValues) -> {
            String name = this.removeSpecial((String)headerName);
            if (!response.containsHeader(name)) {
                headerValues.forEach(headerValue -> response.addHeader(name, this.removeSpecial((String)headerValue)));
            }
        });
    }

    private String removeSpecial(String str) {
        return str.replaceAll("\r", "").replaceAll("\n", "");
    }

    private byte[] getBody(HttpServletRequest request) throws IOException {
        int bytesRead;
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        return baos.toByteArray();
    }
}

