/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.qpid.server.security.access.util.AbstractTreeBranch;
import org.apache.qpid.server.security.access.util.FinalBranch;
import org.apache.qpid.server.security.access.util.PrefixTree;
import org.apache.qpid.server.security.access.util.TreeRoot;
import org.apache.qpid.server.security.access.util.WildCardBranch;
import org.apache.qpid.server.util.Strings;

class TreeBranch
extends AbstractTreeBranch {
    final Map<Character, AbstractTreeBranch> _branches;

    TreeBranch(String prefix) {
        super(prefix);
        this._branches = Collections.emptyMap();
    }

    TreeBranch(Map<Character, AbstractTreeBranch> branches) {
        this._branches = new HashMap<Character, AbstractTreeBranch>(branches);
    }

    TreeBranch(String prefix, Map<Character, AbstractTreeBranch> branches) {
        super(prefix);
        this._branches = new HashMap<Character, AbstractTreeBranch>(branches);
    }

    TreeBranch(String prefix, AbstractTreeBranch first) {
        super(prefix);
        this._branches = Collections.singletonMap(Character.valueOf(first.firstPrefixCharacter()), first);
    }

    TreeBranch(String prefix, AbstractTreeBranch first, AbstractTreeBranch second) {
        super(prefix);
        this._branches = new HashMap<Character, AbstractTreeBranch>(2);
        this._branches.put(Character.valueOf(first.firstPrefixCharacter()), first);
        this._branches.put(Character.valueOf(second.firstPrefixCharacter()), second);
    }

    TreeBranch(AbstractTreeBranch first, AbstractTreeBranch second) {
        this._branches = new HashMap<Character, AbstractTreeBranch>(2);
        this._branches.put(Character.valueOf(first.firstPrefixCharacter()), first);
        this._branches.put(Character.valueOf(second.firstPrefixCharacter()), second);
    }

    @Override
    public Map<Character, PrefixTree> branches() {
        return Collections.unmodifiableMap(this._branches);
    }

    @Override
    public int size() {
        return this._branches.values().stream().mapToInt(PrefixTree::size).sum();
    }

    @Override
    boolean contains(String str) {
        String subString;
        PrefixTree subTree;
        int length = str.length();
        if (length > this._length && str.startsWith(this._prefix) && (subTree = (PrefixTree)this._branches.get(Character.valueOf((subString = str.substring(this._length, length)).charAt(0)))) != null) {
            return subTree.match(subString);
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return new IteratorImpl(this);
    }

    @Override
    AbstractTreeBranch mergeString(String str) {
        String common = Strings.commonPrefix((CharSequence)str, (CharSequence)this._prefix);
        if (common.isEmpty()) {
            return new TreeRoot(this, (AbstractTreeBranch)new FinalBranch(str));
        }
        int commonLength = common.length();
        if (commonLength == str.length()) {
            if (commonLength == this._length) {
                return this.newFinalBranch();
            }
            return new FinalBranch(str, (AbstractTreeBranch)this.newTree(this._prefix.substring(commonLength), this._branches));
        }
        if (commonLength == this._length) {
            HashMap<Character, AbstractTreeBranch> branches = new HashMap<Character, AbstractTreeBranch>(this._branches);
            String subString = str.substring(commonLength);
            char key = subString.charAt(0);
            AbstractTreeBranch branch = (AbstractTreeBranch)branches.get(Character.valueOf(key));
            if (branch != null) {
                branches.put(Character.valueOf(key), branch.mergeString(subString));
            } else {
                branches.put(Character.valueOf(key), new FinalBranch(subString));
            }
            return this.newTree(common, branches);
        }
        return new TreeBranch(common, this.newTree(this._prefix.substring(commonLength), this._branches), new FinalBranch(str.substring(commonLength)));
    }

    @Override
    AbstractTreeBranch mergeWildCard(String prefix) {
        String common = Strings.commonPrefix((CharSequence)prefix, (CharSequence)this._prefix);
        if (common.isEmpty()) {
            return new TreeRoot(this, (AbstractTreeBranch)new WildCardBranch(prefix));
        }
        int commonLength = common.length();
        if (commonLength == prefix.length()) {
            return new WildCardBranch(prefix);
        }
        if (commonLength == this._length) {
            HashMap<Character, AbstractTreeBranch> branches = new HashMap<Character, AbstractTreeBranch>(this._branches);
            String subString = prefix.substring(commonLength);
            char key = subString.charAt(0);
            AbstractTreeBranch branch = (AbstractTreeBranch)branches.get(Character.valueOf(key));
            if (branch != null) {
                branches.put(Character.valueOf(key), branch.mergeWildCard(subString));
            } else {
                branches.put(Character.valueOf(key), new WildCardBranch(subString));
            }
            return this.newTree(this._prefix, branches);
        }
        return new TreeBranch(common, this.newTree(this._prefix.substring(commonLength), this._branches), new WildCardBranch(prefix.substring(commonLength)));
    }

    FinalBranch newFinalBranch() {
        return new FinalBranch(this._prefix, this._branches);
    }

    TreeBranch newTree(String prefix, Map<Character, AbstractTreeBranch> branches) {
        return new TreeBranch(prefix, branches);
    }

    static final class IteratorImpl
    implements Iterator<String> {
        private final String _prefix;
        private final Iterator<AbstractTreeBranch> _tree;
        private Iterator<String> _branch;

        IteratorImpl(TreeBranch root) {
            this._prefix = root.prefix();
            this._tree = new TreeMap<Character, AbstractTreeBranch>(root._branches).values().iterator();
            this._branch = Collections.emptyIterator();
        }

        IteratorImpl(TreeBranch root, String firstValue) {
            this._prefix = root.prefix();
            this._tree = new TreeMap<Character, AbstractTreeBranch>(root._branches).values().iterator();
            this._branch = Stream.of(firstValue).iterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasBranch = this._branch.hasNext();
            while (!hasBranch && this._tree.hasNext()) {
                this._branch = this._tree.next().iterator();
                hasBranch = this._branch.hasNext();
            }
            return hasBranch;
        }

        @Override
        public String next() {
            while (!this._branch.hasNext() && this._tree.hasNext()) {
                this._branch = this._tree.next().iterator();
            }
            return this._prefix + this._branch.next();
        }
    }
}

