/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.server.consumer.AbstractConsumerTarget;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQPConnection_0_8;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.ClientDeliveryMethod;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.FlowCreditManager_0_8;
import org.apache.qpid.server.protocol.v0_8.ProtocolOutputConverter;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.StateChangeListener;

public abstract class ConsumerTarget_0_8
extends AbstractConsumerTarget<ConsumerTarget_0_8> {
    private final ClientDeliveryMethod _deliveryMethod;
    private final String _targetAddress;
    private final AMQChannel _channel;
    private final AMQShortString _consumerTag;
    private final FlowCreditManager_0_8 _creditManager;
    private final Boolean _autoClose;
    private final StateChangeListener<MessageInstance, MessageInstance.EntryState> _unacknowledgedMessageListener = new StateChangeListener<MessageInstance, MessageInstance.EntryState>(){

        public void stateChanged(MessageInstance entry, MessageInstance.EntryState oldState, MessageInstance.EntryState newState) {
            if (this.isConsumerAcquiredStateForThis(oldState) && !this.isConsumerAcquiredStateForThis(newState)) {
                ConsumerTarget_0_8.this.removeUnacknowledgedMessage(entry);
                entry.removeStateChangeListener((StateChangeListener)this);
            }
        }

        private boolean isConsumerAcquiredStateForThis(MessageInstance.EntryState state) {
            return state instanceof MessageInstance.ConsumerAcquiredState && ((MessageInstance.ConsumerAcquiredState)state).getConsumer().getTarget() == ConsumerTarget_0_8.this;
        }
    };

    public static ConsumerTarget_0_8 createBrowserTarget(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, boolean multiQueue) {
        return new BrowserConsumer(channel, consumerTag, filters, creditManager, channel.getClientDeliveryMethod(), multiQueue);
    }

    public static ConsumerTarget_0_8 createGetNoAckTarget(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, ClientDeliveryMethod deliveryMethod) {
        return new GetNoAckConsumer(channel, consumerTag, filters, creditManager, deliveryMethod);
    }

    public static ConsumerTarget_0_8 createNoAckTarget(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, boolean multiQueue) {
        return new NoAckConsumer(channel, consumerTag, filters, creditManager, channel.getClientDeliveryMethod(), multiQueue);
    }

    public static ConsumerTarget_0_8 createAckTarget(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, boolean multiQueue) {
        return new AckConsumer(channel, consumerTag, filters, creditManager, channel.getClientDeliveryMethod(), multiQueue, true);
    }

    public static ConsumerTarget_0_8 createGetAckTarget(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, ClientDeliveryMethod deliveryMethod) {
        return new AckConsumer(channel, consumerTag, filters, creditManager, deliveryMethod, false, false);
    }

    public ConsumerTarget_0_8(AMQChannel channel, AMQShortString consumerTag, FieldTable arguments, FlowCreditManager_0_8 creditManager, ClientDeliveryMethod deliveryMethod, boolean multiQueue) {
        super(multiQueue, channel.getAMQPConnection());
        this._channel = channel;
        this._consumerTag = consumerTag;
        this._creditManager = creditManager;
        this._deliveryMethod = deliveryMethod;
        if (arguments != null) {
            Object autoClose = arguments.get(AMQPFilterTypes.AUTO_CLOSE.getValue());
            this._autoClose = autoClose != null ? (Boolean)autoClose : Boolean.valueOf(false);
            this._targetAddress = arguments.containsKey("local-address") ? String.valueOf(arguments.get("local-address")) : consumerTag.toString();
        } else {
            this._autoClose = false;
            this._targetAddress = consumerTag.toString();
        }
    }

    public String getTargetAddress() {
        return this._targetAddress;
    }

    public AMQChannel getSession() {
        return this._channel;
    }

    public String toString() {
        return "ConsumerTarget_0_8[channel=" + String.valueOf(this._channel) + ", consumerTag=" + String.valueOf(this._consumerTag) + ", session=" + this.getConnection().getRemoteAddressString() + "]";
    }

    public void updateNotifyWorkDesired() {
        AMQPConnection_0_8 amqpConnection = (AMQPConnection_0_8)this._channel.getAMQPConnection();
        boolean state = this._channel.isChannelFlow() && !amqpConnection.isTransportBlockedForWriting() && this.getCreditManager().hasCredit();
        this.setNotifyWorkDesired(state);
    }

    public boolean isAutoClose() {
        return this._autoClose;
    }

    public FlowCreditManager getCreditManager() {
        return this._creditManager;
    }

    public boolean allocateCredit(ServerMessage msg) {
        boolean hasCredit = this._creditManager.hasCredit();
        boolean allocated = this._creditManager.useCreditForMessage(msg.getSize());
        if (hasCredit != this._creditManager.hasCredit()) {
            this._channel.updateAllConsumerNotifyWorkDesired();
        }
        return allocated;
    }

    public AMQChannel getChannel() {
        return this._channel;
    }

    public AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    private AMQPConnection_0_8 getConnection() {
        return this._channel.getConnection();
    }

    public void restoreCredit(ServerMessage message) {
        this._creditManager.restoreCredit(1L, message.getSize());
        this.updateNotifyWorkDesired();
    }

    protected long sendToClient(MessageInstanceConsumer consumer, AMQMessage message, InstanceProperties props, long deliveryTag) {
        return this._deliveryMethod.deliverToClient(this, message, props, deliveryTag);
    }

    public void confirmAutoClose() {
        ProtocolOutputConverter converter = this.getChannel().getConnection().getProtocolOutputConverter();
        converter.confirmConsumerAutoClose(this.getChannel().getChannelId(), this.getConsumerTag());
    }

    public void noMessagesAvailable() {
        if (this.isAutoClose() && this.getState() != ConsumerTarget.State.CLOSED) {
            this.close();
            this.confirmAutoClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doSend(MessageInstanceConsumer consumer, MessageInstance entry, boolean batch) {
        AMQMessage msg;
        ServerMessage serverMessage = entry.getMessage();
        MessageConverter messageConverter = null;
        if (serverMessage instanceof AMQMessage) {
            msg = (AMQMessage)serverMessage;
        } else {
            if (!serverMessage.checkValid()) {
                throw new MessageConversionException(String.format("Cannot convert malformed message '%s'", serverMessage));
            }
            messageConverter = MessageConverterRegistry.getConverter(serverMessage.getClass(), AMQMessage.class);
            msg = (AMQMessage)messageConverter.convert(serverMessage, this.getConnection().getAddressSpace());
        }
        try {
            this.doSendInternal(consumer, entry, msg, batch);
        }
        finally {
            if (messageConverter != null) {
                messageConverter.dispose((ServerMessage)msg);
            }
        }
    }

    protected abstract void doSendInternal(MessageInstanceConsumer var1, MessageInstance var2, AMQMessage var3, boolean var4);

    public void flushBatched() {
        this._channel.getConnection().setDeferFlush(false);
    }

    protected void addUnacknowledgedMessage(MessageInstance entry) {
        this._unacknowledgedBytes.addAndGet(entry.getMessage().getSizeIncludingHeader());
        this._unacknowledgedCount.incrementAndGet();
        entry.addStateChangeListener(this._unacknowledgedMessageListener);
    }

    private void removeUnacknowledgedMessage(MessageInstance entry) {
        this._unacknowledgedBytes.addAndGet(-entry.getMessage().getSizeIncludingHeader());
        this._unacknowledgedCount.decrementAndGet();
    }

    static final class BrowserConsumer
    extends ConsumerTarget_0_8 {
        public BrowserConsumer(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, ClientDeliveryMethod deliveryMethod, boolean multiQueue) {
            super(channel, consumerTag, filters, creditManager, deliveryMethod, multiQueue);
        }

        @Override
        protected void doSendInternal(MessageInstanceConsumer consumer, MessageInstance entry, AMQMessage message, boolean batch) {
            long deliveryTag = this.getChannel().getNextDeliveryTag();
            this.sendToClient(consumer, message, entry.getInstanceProperties(), deliveryTag);
        }
    }

    public static final class GetNoAckConsumer
    extends NoAckConsumer {
        public GetNoAckConsumer(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, ClientDeliveryMethod deliveryMethod) {
            super(channel, consumerTag, filters, creditManager, deliveryMethod, false);
        }
    }

    public static class NoAckConsumer
    extends ConsumerTarget_0_8 {
        private final AutoCommitTransaction _txn;
        private static final ServerTransaction.Action NOOP = new ServerTransaction.Action(){

            public void postCommit() {
            }

            public void onRollback() {
            }
        };

        public NoAckConsumer(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, ClientDeliveryMethod deliveryMethod, boolean multiQueue) {
            super(channel, consumerTag, filters, creditManager, deliveryMethod, multiQueue);
            this._txn = new AutoCommitTransaction(channel.getAddressSpace().getMessageStore());
        }

        @Override
        protected void doSendInternal(MessageInstanceConsumer consumer, MessageInstance entry, AMQMessage message, boolean batch) {
            this._txn.dequeue(entry.getEnqueueRecord(), NOOP);
            try (MessageReference ref = entry.getMessage().newReference();){
                InstanceProperties props = entry.getInstanceProperties();
                entry.delete();
                this.getChannel().getConnection().setDeferFlush(batch);
                long deliveryTag = this.getChannel().getNextDeliveryTag();
                this.sendToClient(consumer, message, props, deliveryTag);
            }
        }
    }

    static final class AckConsumer
    extends ConsumerTarget_0_8 {
        private final boolean _usesCredit;

        public AckConsumer(AMQChannel channel, AMQShortString consumerTag, FieldTable filters, FlowCreditManager_0_8 creditManager, ClientDeliveryMethod deliveryMethod, boolean multiQueue, boolean usesCredit) {
            super(channel, consumerTag, filters, creditManager, deliveryMethod, multiQueue);
            this._usesCredit = usesCredit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doSendInternal(MessageInstanceConsumer consumer, MessageInstance entry, AMQMessage message, boolean batch) {
            AMQChannel aMQChannel = this.getChannel();
            synchronized (aMQChannel) {
                this.getChannel().getConnection().setDeferFlush(batch);
                long deliveryTag = this.getChannel().getNextDeliveryTag();
                this.addUnacknowledgedMessage(entry);
                this.getChannel().addUnacknowledgedMessage(entry, deliveryTag, consumer, this._usesCredit);
                this.sendToClient(consumer, message, entry.getInstanceProperties(), deliveryTag);
                entry.incrementDeliveryCount();
            }
        }
    }
}

