/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode.jdbc;

import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.store.preferences.PreferenceStoreProvider;

public interface JDBCVirtualHostNode<X extends JDBCVirtualHostNode<X>>
extends VirtualHostNode<X>,
JDBCSettings,
PreferenceStoreProvider {
    @ManagedContextDefault(name="jdbcvirtualhostnode.tableNamePrefix", description="Default value for optional database table prefix")
    public static final String DEFAULT_JDBC_VIRTUALHOSTNODE_TABLE_NAME_PREFIX = "";

    @Override
    @ManagedAttribute(mandatory=true)
    public String getConnectionUrl();

    @Override
    @ManagedAttribute(defaultValue="NONE", validValues={"org.apache.qpid.server.store.jdbc.DefaultConnectionProviderFactory#getAllAvailableConnectionProviderTypes()"})
    public String getConnectionPoolType();

    @Override
    @ManagedAttribute
    public String getUsername();

    @Override
    @ManagedAttribute(secure=true)
    public String getPassword();

    @ManagedAttribute(description="Configuration for the preference store, e.g. type, path, etc.", defaultValue="{\"type\": \"Provided\"}")
    public PreferenceStoreAttributes getPreferenceStoreAttributes();

    @Override
    @ManagedAttribute(description="Optional database table prefix so multiple VirtualHostNodes can share the same database", defaultValue="${jdbcvirtualhostnode.tableNamePrefix}", validValuePattern="[a-zA-Z_0-9]*", immutable=true)
    public String getTableNamePrefix();

    @ManagedAttribute(description="Optional keystore holding the key for secure database connection")
    public FileKeyStore<?> getKeyStore();

    @Override
    @ManagedAttribute(description="Name of the database vendor specific keystore path property, property value is taken from the keystore")
    public String getKeyStorePathPropertyName();

    @Override
    @ManagedAttribute(description="Name of the database vendor specific keystore password property, property value is taken from the keystore")
    public String getKeyStorePasswordPropertyName();

    @ManagedAttribute(description="Optional truststore holding the certificate for secure database connection")
    public FileTrustStore<?> getTrustStore();

    @Override
    @ManagedAttribute(description="Name of the database vendor specific truststore path property, property value is taken from the truststore")
    public String getTrustStorePathPropertyName();

    @Override
    @ManagedAttribute(description="Name of the database vendor specific truststore password property, property value is taken from the truststore")
    public String getTrustStorePasswordPropertyName();
}

