/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.boot.autoconfigure.data.redis.RedisUrlSyntaxException;
import org.springframework.util.StringUtils;

record RedisUrl(URI uri, boolean useSsl, Credentials credentials, int database) {
    static RedisUrl of(String url) {
        return url != null ? RedisUrl.of(RedisUrl.toUri(url)) : null;
    }

    private static RedisUrl of(URI uri) {
        boolean useSsl = "rediss".equals(uri.getScheme());
        Credentials credentials = Credentials.fromUserInfo(uri.getUserInfo());
        int database = RedisUrl.getDatabase(uri);
        return new RedisUrl(uri, useSsl, credentials, database);
    }

    private static int getDatabase(URI uri) {
        String path = uri.getPath();
        String[] split = !StringUtils.hasText((String)path) ? new String[]{} : path.split("/", 2);
        return split.length > 1 && !split[1].isEmpty() ? Integer.parseInt(split[1]) : 0;
    }

    private static URI toUri(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (!"redis".equals(scheme) && !"rediss".equals(scheme)) {
                throw new RedisUrlSyntaxException(url);
            }
            return uri;
        }
        catch (URISyntaxException ex) {
            throw new RedisUrlSyntaxException(url, ex);
        }
    }

    record Credentials(String username, String password) {
        private static final Credentials NONE = new Credentials(null, null);

        private static Credentials fromUserInfo(String userInfo) {
            if (userInfo == null) {
                return NONE;
            }
            int index = userInfo.indexOf(58);
            if (index != -1) {
                return new Credentials(userInfo.substring(0, index), userInfo.substring(index + 1));
            }
            return new Credentials(null, userInfo);
        }
    }
}

