/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;

public class FileResourceReference
implements ResourceReference {
    private final File file;
    private final ResourceType resourceType;

    public FileResourceReference(File file) {
        this.file = Objects.requireNonNull(file);
        this.resourceType = file.isDirectory() ? ResourceType.DIRECTORY : ResourceType.FILE;
    }

    @Override
    public File asFile() {
        return this.file;
    }

    @Override
    public URL asURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("File " + this.file.getAbsolutePath() + " cannot be represented as a URL"));
        }
    }

    @Override
    public InputStream read() throws IOException {
        if (this.resourceType != ResourceType.FILE) {
            throw new FileNotFoundException("Could not read from file with name " + this.file.getAbsolutePath() + " because that references a directory");
        }
        return new FileInputStream(this.file);
    }

    @Override
    public boolean isAccessible() {
        return this.file.exists() && this.file.canRead();
    }

    @Override
    public String getLocation() {
        return this.file.getAbsolutePath();
    }

    @Override
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileResourceReference that = (FileResourceReference)o;
        return Objects.equals(this.file, that.file) && this.resourceType == that.resourceType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.file, this.resourceType});
    }

    public String toString() {
        return "FileResourceReference[file=" + String.valueOf(this.file) + ", resourceType=" + String.valueOf((Object)this.resourceType) + "]";
    }
}

