/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class AddIndexesTask
extends PerfTask {
    public static final String ADDINDEXES_INPUT_DIR = "addindexes.input.dir";
    private boolean useAddIndexesDir = true;
    private FSDirectory inputDir;

    public AddIndexesTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        String inputDirProp = this.getRunData().getConfig().get(ADDINDEXES_INPUT_DIR, null);
        if (inputDirProp == null) {
            throw new IllegalArgumentException("config parameter addindexes.input.dir not specified in configuration");
        }
        this.inputDir = FSDirectory.open((Path)Paths.get(inputDirProp, new String[0]));
    }

    @Override
    public int doLogic() throws Exception {
        IndexWriter writer = this.getRunData().getIndexWriter();
        if (this.useAddIndexesDir) {
            writer.addIndexes(new Directory[]{this.inputDir});
        } else {
            try (DirectoryReader r = DirectoryReader.open((Directory)this.inputDir);){
                CodecReader[] leaves = new CodecReader[r.leaves().size()];
                int i = 0;
                for (LeafReaderContext leaf : r.leaves()) {
                    leaves[i++] = SlowCodecReaderWrapper.wrap((LeafReader)leaf.reader());
                }
                writer.addIndexes(leaves);
            }
        }
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        this.useAddIndexesDir = Boolean.parseBoolean(params);
    }

    @Override
    public boolean supportsParams() {
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        this.inputDir.close();
        super.tearDown();
    }
}

