/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.lang.reflect.Constructor;
import java.util.Map;
import opennlp.tools.commons.Trainer;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.maxent.quasinewton.QNTrainer;
import opennlp.tools.ml.naivebayes.NaiveBayesTrainer;
import opennlp.tools.ml.perceptron.PerceptronTrainer;
import opennlp.tools.ml.perceptron.SimplePerceptronSequenceTrainer;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.ext.ExtensionNotLoadedException;

public class TrainerFactory {
    private static final Map<String, Class<? extends Trainer>> BUILTIN_TRAINERS = Map.of("MAXENT", GISTrainer.class, "MAXENT_QN", QNTrainer.class, "PERCEPTRON", PerceptronTrainer.class, "PERCEPTRON_SEQUENCE", SimplePerceptronSequenceTrainer.class, "NAIVEBAYES", NaiveBayesTrainer.class);

    public static TrainerType getTrainerType(TrainingParameters trainParams) {
        String algorithmValue = trainParams.getStringParameter("Algorithm", null);
        if (algorithmValue == null) {
            return TrainerType.EVENT_MODEL_TRAINER;
        }
        Class<? extends Trainer> trainerClass = BUILTIN_TRAINERS.get(algorithmValue);
        if (trainerClass != null) {
            if (EventTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.EVENT_MODEL_TRAINER;
            }
            if (EventModelSequenceTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.EVENT_MODEL_SEQUENCE_TRAINER;
            }
            if (SequenceTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.SEQUENCE_TRAINER;
            }
        }
        try {
            ExtensionLoader.instantiateExtension(EventTrainer.class, algorithmValue);
            return TrainerType.EVENT_MODEL_TRAINER;
        }
        catch (ExtensionNotLoadedException extensionNotLoadedException) {
            try {
                ExtensionLoader.instantiateExtension(EventModelSequenceTrainer.class, algorithmValue);
                return TrainerType.EVENT_MODEL_SEQUENCE_TRAINER;
            }
            catch (ExtensionNotLoadedException extensionNotLoadedException2) {
                try {
                    ExtensionLoader.instantiateExtension(SequenceTrainer.class, algorithmValue);
                    return TrainerType.SEQUENCE_TRAINER;
                }
                catch (ExtensionNotLoadedException extensionNotLoadedException3) {
                    return null;
                }
            }
        }
    }

    public static SequenceTrainer getSequenceModelTrainer(TrainingParameters trainParams, Map<String, String> reportMap) {
        String trainerType = trainParams.getStringParameter("Algorithm", null);
        if (trainerType != null) {
            SequenceTrainer trainer = BUILTIN_TRAINERS.containsKey(trainerType) ? (SequenceTrainer)TrainerFactory.createBuiltinTrainer(BUILTIN_TRAINERS.get(trainerType)) : ExtensionLoader.instantiateExtension(SequenceTrainer.class, trainerType);
            trainer.init(trainParams, reportMap);
            return trainer;
        }
        throw new IllegalArgumentException("Trainer type couldn't be determined!");
    }

    public static <T> EventModelSequenceTrainer<T> getEventModelSequenceTrainer(TrainingParameters trainParams, Map<String, String> reportMap) {
        String trainerType = trainParams.getStringParameter("Algorithm", null);
        if (trainerType != null) {
            EventModelSequenceTrainer trainer = BUILTIN_TRAINERS.containsKey(trainerType) ? (EventModelSequenceTrainer)TrainerFactory.createBuiltinTrainer(BUILTIN_TRAINERS.get(trainerType)) : ExtensionLoader.instantiateExtension(EventModelSequenceTrainer.class, trainerType);
            trainer.init(trainParams, reportMap);
            return trainer;
        }
        throw new IllegalArgumentException("Trainer type couldn't be determined!");
    }

    public static EventTrainer getEventTrainer(TrainingParameters trainParams, Map<String, String> reportMap) {
        String trainerType = trainParams.getStringParameter("Algorithm", "MAXENT");
        EventTrainer trainer = BUILTIN_TRAINERS.containsKey(trainerType) ? (EventTrainer)TrainerFactory.createBuiltinTrainer(BUILTIN_TRAINERS.get(trainerType)) : ExtensionLoader.instantiateExtension(EventTrainer.class, trainerType);
        trainer.init(trainParams, reportMap);
        return trainer;
    }

    public static boolean isValid(TrainingParameters trainParams) {
        String algorithmName = trainParams.getStringParameter("Algorithm", null);
        if (algorithmName != null && !BUILTIN_TRAINERS.containsKey(algorithmName) && TrainerFactory.getTrainerType(trainParams) == null) {
            return false;
        }
        try {
            trainParams.getIntParameter("Cutoff", 5);
            trainParams.getIntParameter("Iterations", 100);
        }
        catch (NumberFormatException e) {
            return false;
        }
        trainParams.getStringParameter("DataIndexer", null);
        return true;
    }

    private static <T extends Trainer> T createBuiltinTrainer(Class<? extends Trainer> trainerClass) {
        Trainer theTrainer = null;
        if (trainerClass != null) {
            try {
                Constructor<? extends Trainer> c = trainerClass.getConstructor(new Class[0]);
                theTrainer = c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + trainerClass.getCanonicalName() + ". The initialization threw an exception.";
                throw new IllegalArgumentException(msg, e);
            }
        }
        return (T)theTrainer;
    }

    public static enum TrainerType {
        EVENT_MODEL_TRAINER,
        EVENT_MODEL_SEQUENCE_TRAINER,
        SEQUENCE_TRAINER;

    }
}

