/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryWindowStore
implements WindowStore<Bytes, byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryWindowStore.class);
    private static final int SEQNUM_SIZE = 4;
    private final String name;
    private final String metricScope;
    private final long retentionPeriod;
    private final long windowSize;
    private final boolean retainDuplicates;
    private final ConcurrentNavigableMap<Long, ConcurrentNavigableMap<Bytes, byte[]>> segmentMap = new ConcurrentSkipListMap<Long, ConcurrentNavigableMap<Bytes, byte[]>>();
    private final Set<InMemoryWindowStoreIteratorWrapper> openIterators = ConcurrentHashMap.newKeySet();
    private InternalProcessorContext internalProcessorContext;
    private Sensor expiredRecordSensor;
    private int seqnum = 0;
    private long observedStreamTime = -1L;
    private volatile boolean open = false;
    private final Position position;

    public InMemoryWindowStore(String name, long retentionPeriod, long windowSize, boolean retainDuplicates, String metricScope) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.windowSize = windowSize;
        this.retainDuplicates = retainDuplicates;
        this.metricScope = metricScope;
        this.position = Position.emptyPosition();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        this.internalProcessorContext = ProcessorContextUtils.asInternalProcessorContext(stateStoreContext);
        StreamsMetricsImpl metrics = ProcessorContextUtils.metricsImpl(stateStoreContext);
        String threadId = Thread.currentThread().getName();
        String taskName = stateStoreContext.taskId().toString();
        this.expiredRecordSensor = TaskMetrics.droppedRecordsSensor(threadId, taskName, metrics);
        if (root != null) {
            boolean consistencyEnabled = StreamsConfig.InternalConfig.getBoolean(stateStoreContext.appConfigs(), "__iq.consistency.offset.vector.enabled__", false);
            stateStoreContext.register(root, records -> {
                Position position = this.position;
                synchronized (position) {
                    for (ConsumerRecord record : records) {
                        this.put(Bytes.wrap((byte[])WindowKeySchema.extractStoreKeyBytes((byte[])record.key())), (byte[])record.value(), WindowKeySchema.extractStoreTimestamp((byte[])record.key()));
                        ChangelogRecordDeserializationHelper.applyChecksAndUpdatePosition((ConsumerRecord<byte[], byte[]>)record, consistencyEnabled, this.position);
                    }
                }
            });
        }
        this.open = true;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Bytes key, byte[] value, long windowStartTimestamp) {
        this.removeExpiredSegments();
        this.observedStreamTime = Math.max(this.observedStreamTime, windowStartTimestamp);
        Position position = this.position;
        synchronized (position) {
            if (windowStartTimestamp <= this.observedStreamTime - this.retentionPeriod) {
                this.expiredRecordSensor.record(1.0, this.internalProcessorContext.currentSystemTimeMs());
                LOG.warn("Skipping record for expired segment.");
            } else if (value != null) {
                this.maybeUpdateSeqnumForDups();
                Bytes keyBytes = this.retainDuplicates ? InMemoryWindowStore.wrapForDups(key, this.seqnum) : key;
                this.segmentMap.computeIfAbsent(windowStartTimestamp, t -> new ConcurrentSkipListMap());
                ((ConcurrentNavigableMap)this.segmentMap.get(windowStartTimestamp)).put(keyBytes, value);
            } else if (!this.retainDuplicates) {
                this.segmentMap.computeIfPresent(windowStartTimestamp, (t, kvMap) -> {
                    kvMap.remove(key);
                    if (kvMap.isEmpty()) {
                        this.segmentMap.remove(windowStartTimestamp);
                    }
                    return kvMap;
                });
            }
            StoreQueryUtils.updatePosition(this.position, this.internalProcessorContext);
        }
    }

    @Override
    public byte[] fetch(Bytes key, long windowStartTimestamp) {
        Objects.requireNonNull(key, "key cannot be null");
        this.removeExpiredSegments();
        if (windowStartTimestamp <= this.observedStreamTime - this.retentionPeriod) {
            return null;
        }
        ConcurrentNavigableMap kvMap = (ConcurrentNavigableMap)this.segmentMap.get(windowStartTimestamp);
        if (kvMap == null) {
            return null;
        }
        return (byte[])kvMap.get(key);
    }

    @Override
    @Deprecated
    public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        return this.fetch(key, timeFrom, timeTo, true);
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        return this.fetch(key, timeFrom, timeTo, false);
    }

    WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo, boolean forward) {
        Objects.requireNonNull(key, "key cannot be null");
        this.removeExpiredSegments();
        long minTime = Math.max(timeFrom, this.observedStreamTime - this.retentionPeriod + 1L);
        if (timeTo < minTime) {
            return WrappedInMemoryWindowStoreIterator.emptyIterator();
        }
        if (forward) {
            return this.registerNewWindowStoreIterator(key, this.segmentMap.subMap((Object)minTime, true, (Object)timeTo, true).entrySet().iterator(), true);
        }
        return this.registerNewWindowStoreIterator(key, this.segmentMap.subMap((Object)minTime, true, (Object)timeTo, true).descendingMap().entrySet().iterator(), false);
    }

    @Override
    @Deprecated
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        return this.fetch(keyFrom, keyTo, timeFrom, timeTo, true);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        return this.fetch(keyFrom, keyTo, timeFrom, timeTo, false);
    }

    KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to, long timeFrom, long timeTo, boolean forward) {
        this.removeExpiredSegments();
        if (from != null && to != null && from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        long minTime = Math.max(timeFrom, this.observedStreamTime - this.retentionPeriod + 1L);
        if (timeTo < minTime) {
            return KeyValueIterators.emptyIterator();
        }
        if (forward) {
            return this.registerNewWindowedKeyValueIterator(from, to, this.segmentMap.subMap((Object)minTime, true, (Object)timeTo, true).entrySet().iterator(), true);
        }
        return this.registerNewWindowedKeyValueIterator(from, to, this.segmentMap.subMap((Object)minTime, true, (Object)timeTo, true).descendingMap().entrySet().iterator(), false);
    }

    @Override
    @Deprecated
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        return this.fetchAll(timeFrom, timeTo, true);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        return this.fetchAll(timeFrom, timeTo, false);
    }

    KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo, boolean forward) {
        this.removeExpiredSegments();
        long minTime = Math.max(timeFrom, this.observedStreamTime - this.retentionPeriod + 1L);
        if (timeTo < minTime) {
            return KeyValueIterators.emptyIterator();
        }
        if (forward) {
            return this.registerNewWindowedKeyValueIterator(null, null, this.segmentMap.subMap((Object)minTime, true, (Object)timeTo, true).entrySet().iterator(), true);
        }
        return this.registerNewWindowedKeyValueIterator(null, null, this.segmentMap.subMap((Object)minTime, true, (Object)timeTo, true).descendingMap().entrySet().iterator(), false);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        this.removeExpiredSegments();
        long minTime = this.observedStreamTime - this.retentionPeriod;
        return this.registerNewWindowedKeyValueIterator(null, null, this.segmentMap.tailMap((Object)minTime, false).entrySet().iterator(), true);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        this.removeExpiredSegments();
        long minTime = this.observedStreamTime - this.retentionPeriod;
        return this.registerNewWindowedKeyValueIterator(null, null, this.segmentMap.tailMap((Object)minTime, false).descendingMap().entrySet().iterator(), false);
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return StoreQueryUtils.handleBasicQueries(query, positionBound, config, this, this.position, this.internalProcessorContext);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.openIterators.size() != 0) {
            LOG.warn("Closing {} open iterators for store {}", (Object)this.openIterators.size(), (Object)this.name);
            for (InMemoryWindowStoreIteratorWrapper it : this.openIterators) {
                it.close();
            }
        }
        this.segmentMap.clear();
        this.open = false;
    }

    private void removeExpiredSegments() {
        long minLiveTime = Math.max(0L, this.observedStreamTime - this.retentionPeriod + 1L);
        for (InMemoryWindowStoreIteratorWrapper it : this.openIterators) {
            minLiveTime = Math.min(minLiveTime, it.minTime());
        }
        this.segmentMap.headMap((Object)minLiveTime, false).clear();
    }

    private void maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
    }

    private static Bytes wrapForDups(Bytes key, int seqnum) {
        ByteBuffer buf = ByteBuffer.allocate(key.get().length + 4);
        buf.put(key.get());
        buf.putInt(seqnum);
        return Bytes.wrap((byte[])buf.array());
    }

    private static Bytes getKey(Bytes keyBytes) {
        byte[] bytes = new byte[keyBytes.get().length - 4];
        System.arraycopy(keyBytes.get(), 0, bytes, 0, bytes.length);
        return Bytes.wrap((byte[])bytes);
    }

    private WrappedInMemoryWindowStoreIterator registerNewWindowStoreIterator(Bytes key, Iterator<Map.Entry<Long, ConcurrentNavigableMap<Bytes, byte[]>>> segmentIterator, boolean forward) {
        Bytes keyFrom = this.retainDuplicates ? InMemoryWindowStore.wrapForDups(key, 0) : key;
        Bytes keyTo = this.retainDuplicates ? InMemoryWindowStore.wrapForDups(key, Integer.MAX_VALUE) : key;
        WrappedInMemoryWindowStoreIterator iterator = new WrappedInMemoryWindowStoreIterator(keyFrom, keyTo, segmentIterator, this.openIterators::remove, this.retainDuplicates, forward);
        this.openIterators.add(iterator);
        return iterator;
    }

    private WrappedWindowedKeyValueIterator registerNewWindowedKeyValueIterator(Bytes keyFrom, Bytes keyTo, Iterator<Map.Entry<Long, ConcurrentNavigableMap<Bytes, byte[]>>> segmentIterator, boolean forward) {
        Bytes from = this.retainDuplicates && keyFrom != null ? InMemoryWindowStore.wrapForDups(keyFrom, 0) : keyFrom;
        Bytes to = this.retainDuplicates && keyTo != null ? InMemoryWindowStore.wrapForDups(keyTo, Integer.MAX_VALUE) : keyTo;
        WrappedWindowedKeyValueIterator iterator = new WrappedWindowedKeyValueIterator(from, to, segmentIterator, this.openIterators::remove, this.retainDuplicates, this.windowSize, forward);
        this.openIterators.add(iterator);
        return iterator;
    }

    private static class WrappedInMemoryWindowStoreIterator
    extends InMemoryWindowStoreIteratorWrapper
    implements WindowStoreIterator<byte[]> {
        WrappedInMemoryWindowStoreIterator(Bytes keyFrom, Bytes keyTo, Iterator<Map.Entry<Long, ConcurrentNavigableMap<Bytes, byte[]>>> segmentIterator, ClosingCallback callback, boolean retainDuplicates, boolean forward) {
            super(keyFrom, keyTo, segmentIterator, callback, retainDuplicates, forward);
        }

        @Override
        public Long peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentTime;
        }

        @Override
        public KeyValue<Long, byte[]> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyValue<Long, byte[]> result = new KeyValue<Long, byte[]>(this.currentTime, (byte[])this.next.value);
            this.next = null;
            return result;
        }

        public static WrappedInMemoryWindowStoreIterator emptyIterator() {
            return new WrappedInMemoryWindowStoreIterator(null, null, null, it -> {}, false, true);
        }
    }

    private static class WrappedWindowedKeyValueIterator
    extends InMemoryWindowStoreIteratorWrapper
    implements KeyValueIterator<Windowed<Bytes>, byte[]> {
        private final long windowSize;

        WrappedWindowedKeyValueIterator(Bytes keyFrom, Bytes keyTo, Iterator<Map.Entry<Long, ConcurrentNavigableMap<Bytes, byte[]>>> segmentIterator, ClosingCallback callback, boolean retainDuplicates, long windowSize, boolean forward) {
            super(keyFrom, keyTo, segmentIterator, callback, retainDuplicates, forward);
            this.windowSize = windowSize;
        }

        @Override
        public Windowed<Bytes> peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.getWindowedKey();
        }

        @Override
        public KeyValue<Windowed<Bytes>, byte[]> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyValue<Windowed<Bytes>, byte[]> result = new KeyValue<Windowed<Bytes>, byte[]>(this.getWindowedKey(), (byte[])this.next.value);
            this.next = null;
            return result;
        }

        private Windowed<Bytes> getWindowedKey() {
            Bytes key = this.retainDuplicates ? InMemoryWindowStore.getKey((Bytes)this.next.key) : (Bytes)this.next.key;
            long endTime = this.currentTime + this.windowSize;
            if (endTime < 0L) {
                LOG.warn("Warning: window end time was truncated to Long.MAX");
                endTime = Long.MAX_VALUE;
            }
            TimeWindow timeWindow = new TimeWindow(this.currentTime, endTime);
            return new Windowed<Bytes>(key, timeWindow);
        }
    }

    private static abstract class InMemoryWindowStoreIteratorWrapper {
        private Iterator<Map.Entry<Bytes, byte[]>> recordIterator;
        private KeyValue<Bytes, byte[]> next;
        private long currentTime;
        private final boolean allKeys;
        private final Bytes keyFrom;
        private final Bytes keyTo;
        private final Iterator<Map.Entry<Long, ConcurrentNavigableMap<Bytes, byte[]>>> segmentIterator;
        private final ClosingCallback callback;
        private final boolean retainDuplicates;
        private final boolean forward;

        InMemoryWindowStoreIteratorWrapper(Bytes keyFrom, Bytes keyTo, Iterator<Map.Entry<Long, ConcurrentNavigableMap<Bytes, byte[]>>> segmentIterator, ClosingCallback callback, boolean retainDuplicates, boolean forward) {
            this.keyFrom = keyFrom;
            this.keyTo = keyTo;
            this.allKeys = keyFrom == null && keyTo == null;
            this.retainDuplicates = retainDuplicates;
            this.forward = forward;
            this.segmentIterator = segmentIterator;
            this.callback = callback;
            this.recordIterator = segmentIterator == null ? null : this.setRecordIterator();
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.recordIterator == null || !this.recordIterator.hasNext() && !this.segmentIterator.hasNext()) {
                return false;
            }
            this.next = this.getNext();
            if (this.next == null) {
                return false;
            }
            if (this.allKeys || !this.retainDuplicates) {
                return true;
            }
            Bytes key = InMemoryWindowStore.getKey((Bytes)this.next.key);
            if (this.isKeyWithinRange(key)) {
                return true;
            }
            this.next = null;
            return this.hasNext();
        }

        private boolean isKeyWithinRange(Bytes key) {
            if (this.keyFrom == null && this.keyTo == null) {
                return true;
            }
            if (this.keyFrom == null) {
                return key.compareTo(InMemoryWindowStore.getKey(this.keyTo)) <= 0;
            }
            if (this.keyTo == null) {
                return key.compareTo(InMemoryWindowStore.getKey(this.keyFrom)) >= 0;
            }
            return key.compareTo(InMemoryWindowStore.getKey(this.keyFrom)) >= 0 && key.compareTo(InMemoryWindowStore.getKey(this.keyTo)) <= 0;
        }

        public void close() {
            this.next = null;
            this.recordIterator = null;
            this.callback.deregisterIterator(this);
        }

        protected KeyValue<Bytes, byte[]> getNext() {
            while (!this.recordIterator.hasNext()) {
                this.recordIterator = this.setRecordIterator();
                if (this.recordIterator != null) continue;
                return null;
            }
            Map.Entry<Bytes, byte[]> nextRecord = this.recordIterator.next();
            return new KeyValue<Bytes, byte[]>(nextRecord.getKey(), nextRecord.getValue());
        }

        Iterator<Map.Entry<Bytes, byte[]>> setRecordIterator() {
            if (!this.segmentIterator.hasNext()) {
                return null;
            }
            Map.Entry<Long, ConcurrentNavigableMap<Bytes, byte[]>> currentSegment = this.segmentIterator.next();
            this.currentTime = currentSegment.getKey();
            NavigableMap<Object, Object> subMap = this.allKeys ? currentSegment.getValue() : (this.keyFrom == null ? currentSegment.getValue().headMap((Object)this.keyTo, true) : (this.keyTo == null ? currentSegment.getValue().tailMap((Object)this.keyFrom, true) : currentSegment.getValue().subMap((Object)this.keyFrom, true, (Object)this.keyTo, true)));
            if (this.forward) {
                return subMap.entrySet().iterator();
            }
            return subMap.descendingMap().entrySet().iterator();
        }

        Long minTime() {
            return this.currentTime;
        }
    }

    static interface ClosingCallback {
        public void deregisterIterator(InMemoryWindowStoreIteratorWrapper var1);
    }
}

