/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.InMemorySessionStore;

public class InMemorySessionBytesStoreSupplier
implements SessionBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;

    public InMemorySessionBytesStoreSupplier(String name, long retentionPeriod) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SessionStore<Bytes, byte[]> get() {
        return new InMemorySessionStore(this.name, this.retentionPeriod, this.metricsScope());
    }

    @Override
    public String metricsScope() {
        return "in-memory-session";
    }

    @Override
    public long segmentIntervalMs() {
        return 1L;
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

