/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import org.apache.kafka.common.config.ConfigDef;

public class DelegationTokenManagerConfigs {
    public static final String DELEGATION_TOKEN_SECRET_KEY_CONFIG = "delegation.token.secret.key";
    public static final String DELEGATION_TOKEN_SECRET_KEY_DOC = "Secret key to generate and verify delegation tokens. The same key must be configured across all the brokers.  If using Kafka with KRaft, the key must also be set across all controllers.  If the key is not set or set to empty string, brokers will disable the delegation token support.";
    public static final String DELEGATION_TOKEN_MAX_LIFETIME_CONFIG = "delegation.token.max.lifetime.ms";
    public static final long DELEGATION_TOKEN_MAX_LIFE_TIME_MS_DEFAULT = 604800000L;
    public static final String DELEGATION_TOKEN_MAX_LIFE_TIME_DOC = "The token has a maximum lifetime beyond which it cannot be renewed anymore. Default value 7 days.";
    public static final String DELEGATION_TOKEN_EXPIRY_TIME_MS_CONFIG = "delegation.token.expiry.time.ms";
    public static final long DELEGATION_TOKEN_EXPIRY_TIME_MS_DEFAULT = 86400000L;
    public static final String DELEGATION_TOKEN_EXPIRY_TIME_MS_DOC = "The token validity time in milliseconds before the token needs to be renewed. Default value 1 day.";
    public static final String DELEGATION_TOKEN_EXPIRY_CHECK_INTERVAL_MS_CONFIG = "delegation.token.expiry.check.interval.ms";
    public static final long DELEGATION_TOKEN_EXPIRY_CHECK_INTERVAL_MS_DEFAULT = 3600000L;
    public static final String DELEGATION_TOKEN_EXPIRY_CHECK_INTERVAL_DOC = "Scan interval to remove expired delegation tokens.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("delegation.token.secret.key", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "Secret key to generate and verify delegation tokens. The same key must be configured across all the brokers.  If using Kafka with KRaft, the key must also be set across all controllers.  If the key is not set or set to empty string, brokers will disable the delegation token support.").define("delegation.token.max.lifetime.ms", ConfigDef.Type.LONG, (Object)604800000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The token has a maximum lifetime beyond which it cannot be renewed anymore. Default value 7 days.").define("delegation.token.expiry.time.ms", ConfigDef.Type.LONG, (Object)86400000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The token validity time in milliseconds before the token needs to be renewed. Default value 1 day.").define("delegation.token.expiry.check.interval.ms", ConfigDef.Type.LONG, (Object)3600000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Scan interval to remove expired delegation tokens.");
}

