/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kafka.cluster.PartitionListener;
import kafka.server.ReplicaManager;
import kafka.server.share.DelayedShareFetch;
import kafka.server.share.ShareFetchUtils;
import kafka.server.share.SharePartition;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedStateEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareRequestMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.acknowledge.ShareAcknowledgementBatch;
import org.apache.kafka.server.share.context.FinalContext;
import org.apache.kafka.server.share.context.ShareFetchContext;
import org.apache.kafka.server.share.context.ShareSessionContext;
import org.apache.kafka.server.share.fetch.DelayedShareFetchGroupKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchPartitionKey;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.share.persister.Persister;
import org.apache.kafka.server.share.session.ShareSession;
import org.apache.kafka.server.share.session.ShareSessionCache;
import org.apache.kafka.server.share.session.ShareSessionKey;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.util.FutureUtils;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.SystemTimerReaper;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharePartitionManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SharePartitionManager.class);
    private final Map<SharePartitionKey, SharePartition> partitionCacheMap;
    private final ReplicaManager replicaManager;
    private final Time time;
    private final ShareSessionCache cache;
    private final GroupConfigManager groupConfigManager;
    private final int defaultRecordLockDurationMs;
    private final Timer timer;
    private final int maxInFlightMessages;
    private final int maxDeliveryCount;
    private final Persister persister;
    private final ShareGroupMetrics shareGroupMetrics;
    private final int maxFetchRecords;

    public SharePartitionManager(ReplicaManager replicaManager, Time time, ShareSessionCache cache, int defaultRecordLockDurationMs, int maxDeliveryCount, int maxInFlightMessages, int maxFetchRecords, Persister persister, GroupConfigManager groupConfigManager, Metrics metrics) {
        this(replicaManager, time, cache, new ConcurrentHashMap<SharePartitionKey, SharePartition>(), defaultRecordLockDurationMs, maxDeliveryCount, maxInFlightMessages, maxFetchRecords, persister, groupConfigManager, metrics);
    }

    private SharePartitionManager(ReplicaManager replicaManager, Time time, ShareSessionCache cache, Map<SharePartitionKey, SharePartition> partitionCacheMap, int defaultRecordLockDurationMs, int maxDeliveryCount, int maxInFlightMessages, int maxFetchRecords, Persister persister, GroupConfigManager groupConfigManager, Metrics metrics) {
        this(replicaManager, time, cache, partitionCacheMap, defaultRecordLockDurationMs, (Timer)new SystemTimerReaper("share-group-lock-timeout-reaper", (Timer)new SystemTimer("share-group-lock-timeout")), maxDeliveryCount, maxInFlightMessages, maxFetchRecords, persister, groupConfigManager, metrics);
    }

    SharePartitionManager(ReplicaManager replicaManager, Time time, ShareSessionCache cache, Map<SharePartitionKey, SharePartition> partitionCacheMap, int defaultRecordLockDurationMs, Timer timer, int maxDeliveryCount, int maxInFlightMessages, int maxFetchRecords, Persister persister, GroupConfigManager groupConfigManager, Metrics metrics) {
        this.replicaManager = replicaManager;
        this.time = time;
        this.cache = cache;
        this.partitionCacheMap = partitionCacheMap;
        this.defaultRecordLockDurationMs = defaultRecordLockDurationMs;
        this.timer = timer;
        this.maxDeliveryCount = maxDeliveryCount;
        this.maxInFlightMessages = maxInFlightMessages;
        this.persister = persister;
        this.groupConfigManager = groupConfigManager;
        this.shareGroupMetrics = new ShareGroupMetrics(Objects.requireNonNull(metrics), time);
        this.maxFetchRecords = maxFetchRecords;
    }

    public CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> fetchMessages(String groupId, String memberId, FetchParams fetchParams, Map<TopicIdPartition, Integer> partitionMaxBytes) {
        log.trace("Fetch request for topicIdPartitions: {} with groupId: {} fetch params: {}", new Object[]{partitionMaxBytes.keySet(), groupId, fetchParams});
        CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> future = new CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>>();
        this.processShareFetch(new ShareFetch(fetchParams, groupId, memberId, future, partitionMaxBytes, this.maxFetchRecords));
        return future;
    }

    public CompletableFuture<Map<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData>> acknowledge(String memberId, String groupId, Map<TopicIdPartition, List<ShareAcknowledgementBatch>> acknowledgeTopics) {
        log.trace("Acknowledge request for topicIdPartitions: {} with groupId: {}", acknowledgeTopics.keySet(), (Object)groupId);
        this.shareGroupMetrics.shareAcknowledgement();
        HashMap<TopicIdPartition, CompletableFuture<Throwable>> futures = new HashMap<TopicIdPartition, CompletableFuture<Throwable>>();
        acknowledgeTopics.forEach((topicIdPartition, acknowledgePartitionBatches) -> {
            SharePartitionKey sharePartitionKey = this.sharePartitionKey(groupId, (TopicIdPartition)topicIdPartition);
            SharePartition sharePartition = this.partitionCacheMap.get(sharePartitionKey);
            if (sharePartition != null) {
                CompletableFuture future = new CompletableFuture();
                sharePartition.acknowledge(memberId, (List<ShareAcknowledgementBatch>)acknowledgePartitionBatches).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        this.fencedSharePartitionHandler().accept(sharePartitionKey, (Throwable)throwable);
                        future.complete(throwable);
                        return;
                    }
                    acknowledgePartitionBatches.forEach(batch -> batch.acknowledgeTypes().forEach(this.shareGroupMetrics::recordAcknowledgement));
                    future.complete(null);
                });
                DelayedShareFetchGroupKey delayedShareFetchKey = new DelayedShareFetchGroupKey(groupId, topicIdPartition.topicId(), topicIdPartition.partition());
                this.replicaManager.completeDelayedShareFetchRequest((DelayedShareFetchKey)delayedShareFetchKey);
                futures.put((TopicIdPartition)topicIdPartition, future);
            } else {
                futures.put((TopicIdPartition)topicIdPartition, (CompletableFuture<Throwable>)CompletableFuture.completedFuture(Errors.UNKNOWN_TOPIC_OR_PARTITION.exception()));
            }
        });
        return this.mapAcknowledgementFutures(futures);
    }

    public CompletableFuture<Map<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData>> releaseSession(String groupId, String memberId) {
        log.trace("Release session request for groupId: {}, memberId: {}", (Object)groupId, (Object)memberId);
        Uuid memberIdUuid = Uuid.fromString((String)memberId);
        List<TopicIdPartition> topicIdPartitions = this.cachedTopicIdPartitionsInShareSession(groupId, memberIdUuid);
        ShareSessionKey key = this.shareSessionKey(groupId, memberIdUuid);
        if (this.cache.remove(key) == null) {
            log.error("Share session error for {}: no such share session found", (Object)key);
            return FutureUtils.failedFuture((Throwable)Errors.SHARE_SESSION_NOT_FOUND.exception());
        }
        log.debug("Removed share session with key " + String.valueOf(key));
        if (topicIdPartitions.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        HashMap<TopicIdPartition, CompletableFuture<Throwable>> futuresMap = new HashMap<TopicIdPartition, CompletableFuture<Throwable>>();
        topicIdPartitions.forEach(topicIdPartition -> {
            SharePartitionKey sharePartitionKey = this.sharePartitionKey(groupId, (TopicIdPartition)topicIdPartition);
            SharePartition sharePartition = this.partitionCacheMap.get(sharePartitionKey);
            if (sharePartition == null) {
                log.error("No share partition found for groupId {} topicPartition {} while releasing acquired topic partitions", (Object)groupId, topicIdPartition);
                futuresMap.put((TopicIdPartition)topicIdPartition, (CompletableFuture<Throwable>)CompletableFuture.completedFuture(Errors.UNKNOWN_TOPIC_OR_PARTITION.exception()));
            } else {
                CompletableFuture future = new CompletableFuture();
                sharePartition.releaseAcquiredRecords(memberId).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        this.fencedSharePartitionHandler().accept(sharePartitionKey, (Throwable)throwable);
                        future.complete(throwable);
                        return;
                    }
                    future.complete(null);
                });
                DelayedShareFetchGroupKey delayedShareFetchKey = new DelayedShareFetchGroupKey(groupId, topicIdPartition.topicId(), topicIdPartition.partition());
                this.replicaManager.completeDelayedShareFetchRequest((DelayedShareFetchKey)delayedShareFetchKey);
                futuresMap.put((TopicIdPartition)topicIdPartition, future);
            }
        });
        return this.mapAcknowledgementFutures(futuresMap);
    }

    private CompletableFuture<Map<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData>> mapAcknowledgementFutures(Map<TopicIdPartition, CompletableFuture<Throwable>> futuresMap) {
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futuresMap.values().toArray(new CompletableFuture[0]));
        return allFutures.thenApply(v -> {
            HashMap result = new HashMap();
            futuresMap.forEach((topicIdPartition, future) -> {
                ShareAcknowledgeResponseData.PartitionData partitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition());
                Throwable t = (Throwable)future.join();
                if (t != null) {
                    partitionData.setErrorCode(Errors.forException((Throwable)t).code()).setErrorMessage(t.getMessage());
                }
                result.put(topicIdPartition, partitionData);
            });
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFetchContext newContext(String groupId, Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData, List<TopicIdPartition> toForget, ShareRequestMetadata reqMetadata, Boolean isAcknowledgeDataPresent) {
        FinalContext context;
        HashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchDataWithMaxBytes = new HashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        shareFetchData.forEach((tp, sharePartitionData) -> {
            if (sharePartitionData.maxBytes > 0) {
                shareFetchDataWithMaxBytes.put((TopicIdPartition)tp, (ShareFetchRequest.SharePartitionData)sharePartitionData);
            }
        });
        if (reqMetadata.isFull()) {
            ShareSessionKey key = this.shareSessionKey(groupId, reqMetadata.memberId());
            if (reqMetadata.epoch() == -1) {
                if (!shareFetchDataWithMaxBytes.isEmpty()) {
                    throw Errors.INVALID_REQUEST.exception();
                }
                if (this.cache.get(key) == null) {
                    log.error("Share session error for {}: no such share session found", (Object)key);
                    throw Errors.SHARE_SESSION_NOT_FOUND.exception();
                }
                context = new FinalContext();
            } else {
                if (isAcknowledgeDataPresent.booleanValue()) {
                    log.error("Acknowledge data present in Initial Fetch Request for group {} member {}", (Object)groupId, (Object)reqMetadata.memberId());
                    throw Errors.INVALID_REQUEST.exception();
                }
                if (this.cache.remove(key) != null) {
                    log.debug("Removed share session with key {}", (Object)key);
                }
                ImplicitLinkedHashCollection cachedSharePartitions = new ImplicitLinkedHashCollection(shareFetchDataWithMaxBytes.size());
                shareFetchDataWithMaxBytes.forEach((topicIdPartition, reqData) -> cachedSharePartitions.mustAdd((ImplicitLinkedHashCollection.Element)new CachedSharePartition(topicIdPartition, reqData, false)));
                ShareSessionKey responseShareSessionKey = this.cache.maybeCreateSession(groupId, reqMetadata.memberId(), this.time.milliseconds(), cachedSharePartitions);
                if (responseShareSessionKey == null) {
                    log.error("Could not create a share session for group {} member {}", (Object)groupId, (Object)reqMetadata.memberId());
                    throw Errors.SHARE_SESSION_NOT_FOUND.exception();
                }
                context = new ShareSessionContext(reqMetadata, shareFetchDataWithMaxBytes);
                log.debug("Created a new ShareSessionContext with key {} isSubsequent {} returning {}. A new share session will be started.", new Object[]{responseShareSessionKey, false, SharePartitionManager.partitionsToLogString(shareFetchDataWithMaxBytes.keySet())});
            }
        } else {
            ShareSessionCache shareSessionCache = this.cache;
            synchronized (shareSessionCache) {
                ShareSessionKey key = this.shareSessionKey(groupId, reqMetadata.memberId());
                ShareSession shareSession = this.cache.get(key);
                if (shareSession == null) {
                    log.error("Share session error for {}: no such share session found", (Object)key);
                    throw Errors.SHARE_SESSION_NOT_FOUND.exception();
                }
                if (shareSession.epoch != reqMetadata.epoch()) {
                    log.debug("Share session error for {}: expected epoch {}, but got {} instead", new Object[]{key, shareSession.epoch, reqMetadata.epoch()});
                    throw Errors.INVALID_SHARE_SESSION_EPOCH.exception();
                }
                Map modifiedTopicIdPartitions = shareSession.update(shareFetchDataWithMaxBytes, toForget);
                this.cache.touch(shareSession, this.time.milliseconds());
                shareSession.epoch = ShareRequestMetadata.nextEpoch((int)shareSession.epoch);
                log.debug("Created a new ShareSessionContext for session key {}, epoch {}: added {}, updated {}, removed {}", new Object[]{shareSession.key(), shareSession.epoch, SharePartitionManager.partitionsToLogString((Collection)modifiedTopicIdPartitions.get(ShareSession.ModifiedTopicIdPartitionType.ADDED)), SharePartitionManager.partitionsToLogString((Collection)modifiedTopicIdPartitions.get(ShareSession.ModifiedTopicIdPartitionType.UPDATED)), SharePartitionManager.partitionsToLogString((Collection)modifiedTopicIdPartitions.get(ShareSession.ModifiedTopicIdPartitionType.REMOVED))});
                context = new ShareSessionContext(reqMetadata, shareSession);
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSessionUpdate(String groupId, ShareRequestMetadata reqMetadata) {
        if (reqMetadata.epoch() == 0) {
            throw Errors.INVALID_SHARE_SESSION_EPOCH.exception();
        }
        ShareSessionCache shareSessionCache = this.cache;
        synchronized (shareSessionCache) {
            ShareSessionKey key = this.shareSessionKey(groupId, reqMetadata.memberId());
            ShareSession shareSession = this.cache.get(key);
            if (shareSession == null) {
                log.debug("Share session error for {}: no such share session found", (Object)key);
                throw Errors.SHARE_SESSION_NOT_FOUND.exception();
            }
            if (reqMetadata.epoch() == -1) {
                return;
            }
            if (shareSession.epoch != reqMetadata.epoch()) {
                log.debug("Share session error for {}: expected epoch {}, but got {} instead", new Object[]{key, shareSession.epoch, reqMetadata.epoch()});
                throw Errors.INVALID_SHARE_SESSION_EPOCH.exception();
            }
            this.cache.touch(shareSession, this.time.milliseconds());
            shareSession.epoch = ShareRequestMetadata.nextEpoch((int)shareSession.epoch);
        }
    }

    List<TopicIdPartition> cachedTopicIdPartitionsInShareSession(String groupId, Uuid memberId) {
        ShareSessionKey key = this.shareSessionKey(groupId, memberId);
        ShareSession shareSession = this.cache.get(key);
        if (shareSession == null) {
            return Collections.emptyList();
        }
        ArrayList<TopicIdPartition> cachedTopicIdPartitions = new ArrayList<TopicIdPartition>();
        shareSession.partitionMap().forEach(cachedSharePartition -> cachedTopicIdPartitions.add(new TopicIdPartition(cachedSharePartition.topicId(), new TopicPartition(cachedSharePartition.topic(), cachedSharePartition.partition()))));
        return cachedTopicIdPartitions;
    }

    private void addDelayedShareFetch(DelayedShareFetch delayedShareFetch, List<DelayedShareFetchKey> keys) {
        this.replicaManager.addDelayedShareFetchRequest(delayedShareFetch, keys);
    }

    @Override
    public void close() throws Exception {
        this.timer.close();
    }

    private ShareSessionKey shareSessionKey(String groupId, Uuid memberId) {
        return new ShareSessionKey(groupId, memberId);
    }

    private static String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return ShareSession.partitionsToLogString(partitions, (Boolean)log.isTraceEnabled());
    }

    void processShareFetch(ShareFetch shareFetch) {
        if (shareFetch.partitionMaxBytes().isEmpty()) {
            shareFetch.maybeComplete(Collections.emptyMap());
            return;
        }
        ArrayList<DelayedShareFetchKey> delayedShareFetchWatchKeys = new ArrayList<DelayedShareFetchKey>();
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        for (TopicIdPartition topicIdPartition : shareFetch.partitionMaxBytes().keySet()) {
            SharePartition sharePartition;
            SharePartitionKey sharePartitionKey = this.sharePartitionKey(shareFetch.groupId(), topicIdPartition);
            try {
                sharePartition = this.getOrCreateSharePartition(sharePartitionKey);
            }
            catch (Exception e) {
                log.debug("Error processing share fetch request", (Throwable)e);
                shareFetch.addErroneous(topicIdPartition, (Throwable)e);
                continue;
            }
            DelayedShareFetchGroupKey delayedShareFetchKey = new DelayedShareFetchGroupKey(shareFetch.groupId(), topicIdPartition.topicId(), topicIdPartition.partition());
            delayedShareFetchWatchKeys.add((DelayedShareFetchKey)delayedShareFetchKey);
            delayedShareFetchWatchKeys.add((DelayedShareFetchKey)new DelayedShareFetchPartitionKey(topicIdPartition.topicId(), topicIdPartition.partition()));
            CompletableFuture<Void> initializationFuture = sharePartition.maybeInitialize();
            boolean initialized = initializationFuture.isDone();
            initializationFuture.whenComplete((arg_0, arg_1) -> this.lambda$processShareFetch$10(sharePartitionKey, shareFetch, initialized, (DelayedShareFetchKey)delayedShareFetchKey, arg_0, arg_1));
            sharePartitions.put(topicIdPartition, sharePartition);
        }
        if (shareFetch.errorInAllPartitions()) {
            shareFetch.maybeComplete(Collections.emptyMap());
            return;
        }
        this.addDelayedShareFetch(new DelayedShareFetch(shareFetch, this.replicaManager, this.fencedSharePartitionHandler(), sharePartitions), delayedShareFetchWatchKeys);
    }

    private SharePartition getOrCreateSharePartition(SharePartitionKey sharePartitionKey) {
        return this.partitionCacheMap.computeIfAbsent(sharePartitionKey, k -> {
            long start = this.time.hiResClockMs();
            int leaderEpoch = ShareFetchUtils.leaderEpoch(this.replicaManager, sharePartitionKey.topicIdPartition().topicPartition());
            SharePartitionListener listener = new SharePartitionListener(sharePartitionKey, this.replicaManager, this.partitionCacheMap);
            this.replicaManager.maybeAddListener(sharePartitionKey.topicIdPartition().topicPartition(), listener);
            SharePartition partition = new SharePartition(sharePartitionKey.groupId(), sharePartitionKey.topicIdPartition(), leaderEpoch, this.maxInFlightMessages, this.maxDeliveryCount, this.defaultRecordLockDurationMs, this.timer, this.time, this.persister, this.replicaManager, this.groupConfigManager, listener);
            this.shareGroupMetrics.partitionLoadTime(start);
            return partition;
        });
    }

    private void handleInitializationException(SharePartitionKey sharePartitionKey, ShareFetch shareFetch, Throwable throwable) {
        if (throwable instanceof LeaderNotAvailableException) {
            log.debug("The share partition with key {} is not initialized yet", (Object)sharePartitionKey);
            return;
        }
        SharePartitionManager.removeSharePartitionFromCache(sharePartitionKey, this.partitionCacheMap, this.replicaManager);
        log.debug("Error initializing share partition with key {}", (Object)sharePartitionKey, (Object)throwable);
        shareFetch.addErroneous(sharePartitionKey.topicIdPartition(), throwable);
    }

    private BiConsumer<SharePartitionKey, Throwable> fencedSharePartitionHandler() {
        return (sharePartitionKey, throwable) -> {
            if (throwable instanceof NotLeaderOrFollowerException || throwable instanceof FencedStateEpochException || throwable instanceof GroupIdNotFoundException || throwable instanceof UnknownTopicOrPartitionException) {
                log.info("The share partition with key {} is fenced: {}", sharePartitionKey, (Object)throwable.getMessage());
                SharePartitionManager.removeSharePartitionFromCache(sharePartitionKey, this.partitionCacheMap, this.replicaManager);
            }
        };
    }

    private SharePartitionKey sharePartitionKey(String groupId, TopicIdPartition topicIdPartition) {
        return new SharePartitionKey(groupId, topicIdPartition);
    }

    private static void removeSharePartitionFromCache(SharePartitionKey sharePartitionKey, Map<SharePartitionKey, SharePartition> map, ReplicaManager replicaManager) {
        SharePartition sharePartition = map.remove(sharePartitionKey);
        if (sharePartition != null) {
            sharePartition.markFenced();
            replicaManager.removeListener(sharePartitionKey.topicIdPartition().topicPartition(), sharePartition.listener());
        }
    }

    private /* synthetic */ void lambda$processShareFetch$10(SharePartitionKey sharePartitionKey, ShareFetch shareFetch, boolean initialized, DelayedShareFetchKey delayedShareFetchKey, Void result, Throwable throwable) {
        if (throwable != null) {
            this.handleInitializationException(sharePartitionKey, shareFetch, throwable);
        }
        if (!initialized) {
            this.replicaManager.completeDelayedShareFetchRequest(delayedShareFetchKey);
        }
    }

    static class ShareGroupMetrics {
        public static final String METRICS_GROUP_NAME = "share-group-metrics";
        public static final String SHARE_ACK_SENSOR = "share-acknowledgement-sensor";
        public static final String SHARE_ACK_RATE = "share-acknowledgement-rate";
        public static final String SHARE_ACK_COUNT = "share-acknowledgement-count";
        public static final String RECORD_ACK_SENSOR_PREFIX = "record-acknowledgement";
        public static final String RECORD_ACK_RATE = "record-acknowledgement-rate";
        public static final String RECORD_ACK_COUNT = "record-acknowledgement-count";
        public static final String ACK_TYPE = "ack-type";
        public static final String PARTITION_LOAD_TIME_SENSOR = "partition-load-time-sensor";
        public static final String PARTITION_LOAD_TIME_AVG = "partition-load-time-avg";
        public static final String PARTITION_LOAD_TIME_MAX = "partition-load-time-max";
        public static final Map<Byte, String> RECORD_ACKS_MAP = new HashMap<Byte, String>();
        private final Time time;
        private final Sensor shareAcknowledgementSensor;
        private final Map<Byte, Sensor> recordAcksSensorMap = new HashMap<Byte, Sensor>();
        private final Sensor partitionLoadTimeSensor;

        public ShareGroupMetrics(Metrics metrics, Time time) {
            this.time = time;
            this.shareAcknowledgementSensor = metrics.sensor(SHARE_ACK_SENSOR);
            this.shareAcknowledgementSensor.add((CompoundStat)new Meter(metrics.metricName(SHARE_ACK_RATE, METRICS_GROUP_NAME, "Rate of acknowledge requests."), metrics.metricName(SHARE_ACK_COUNT, METRICS_GROUP_NAME, "The number of acknowledge requests.")));
            for (Map.Entry<Byte, String> entry : RECORD_ACKS_MAP.entrySet()) {
                this.recordAcksSensorMap.put(entry.getKey(), metrics.sensor(String.format("%s-%s-sensor", RECORD_ACK_SENSOR_PREFIX, entry.getValue())));
                this.recordAcksSensorMap.get(entry.getKey()).add((CompoundStat)new Meter(metrics.metricName(RECORD_ACK_RATE, METRICS_GROUP_NAME, "Rate of records acknowledged per acknowledgement type.", new String[]{ACK_TYPE, entry.getValue()}), metrics.metricName(RECORD_ACK_COUNT, METRICS_GROUP_NAME, "The number of records acknowledged per acknowledgement type.", new String[]{ACK_TYPE, entry.getValue()})));
            }
            this.partitionLoadTimeSensor = metrics.sensor(PARTITION_LOAD_TIME_SENSOR);
            this.partitionLoadTimeSensor.add(metrics.metricName(PARTITION_LOAD_TIME_AVG, METRICS_GROUP_NAME, "The average time in milliseconds to load the share partitions."), (MeasurableStat)new Avg());
            this.partitionLoadTimeSensor.add(metrics.metricName(PARTITION_LOAD_TIME_MAX, METRICS_GROUP_NAME, "The maximum time in milliseconds to load the share partitions."), (MeasurableStat)new Max());
        }

        void shareAcknowledgement() {
            this.shareAcknowledgementSensor.record();
        }

        void recordAcknowledgement(byte ackType) {
            if (this.recordAcksSensorMap.containsKey(ackType)) {
                this.recordAcksSensorMap.get(ackType).record();
            }
        }

        void partitionLoadTime(long start) {
            this.partitionLoadTimeSensor.record((double)(this.time.hiResClockMs() - start));
        }

        static {
            RECORD_ACKS_MAP.put((byte)1, AcknowledgeType.ACCEPT.toString());
            RECORD_ACKS_MAP.put((byte)2, AcknowledgeType.RELEASE.toString());
            RECORD_ACKS_MAP.put((byte)3, AcknowledgeType.REJECT.toString());
        }
    }

    static class SharePartitionListener
    implements PartitionListener {
        private final SharePartitionKey sharePartitionKey;
        private final ReplicaManager replicaManager;
        private final Map<SharePartitionKey, SharePartition> partitionCacheMap;

        SharePartitionListener(SharePartitionKey sharePartitionKey, ReplicaManager replicaManager, Map<SharePartitionKey, SharePartition> partitionCacheMap) {
            this.sharePartitionKey = sharePartitionKey;
            this.replicaManager = replicaManager;
            this.partitionCacheMap = partitionCacheMap;
        }

        @Override
        public void onFailed(TopicPartition topicPartition) {
            log.debug("The share partition failed listener is invoked for the topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
            this.onUpdate(topicPartition);
        }

        @Override
        public void onDeleted(TopicPartition topicPartition) {
            log.debug("The share partition delete listener is invoked for the topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
            this.onUpdate(topicPartition);
        }

        @Override
        public void onBecomingFollower(TopicPartition topicPartition) {
            log.debug("The share partition becoming follower listener is invoked for the topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
            this.onUpdate(topicPartition);
        }

        private void onUpdate(TopicPartition topicPartition) {
            if (!this.sharePartitionKey.topicIdPartition().topicPartition().equals((Object)topicPartition)) {
                log.error("The share partition listener is invoked for the wrong topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
                return;
            }
            SharePartitionManager.removeSharePartitionFromCache(this.sharePartitionKey, this.partitionCacheMap, this.replicaManager);
        }
    }
}

