/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import java.util.Arrays;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class NameListResponse
extends BaseResponse {
    @JsonProperty(value="names")
    private final String[] names;

    public NameListResponse(String[] names) {
        this.names = names;
    }

    public NameListResponse() {
        this.names = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.names != null, "\"names\" must not be null");
        Arrays.stream(this.names).forEach(name -> Preconditions.checkArgument(StringUtils.isNotBlank(name), "name must not be null"));
    }

    public String[] getNames() {
        return this.names;
    }

    @Override
    public String toString() {
        return "NameListResponse(names=" + Arrays.deepToString(this.getNames()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameListResponse)) {
            return false;
        }
        NameListResponse other = (NameListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getNames(), other.getNames());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NameListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getNames());
        return result;
    }
}

