/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.file;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class FilesetDTO
implements Fileset {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="type")
    private Fileset.Type type;
    @JsonProperty(value="storageLocation")
    private String storageLocation;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String comment() {
        return this.comment;
    }

    @Override
    public Fileset.Type type() {
        return this.type;
    }

    @Override
    public String storageLocation() {
        return this.storageLocation;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public AuditDTO auditInfo() {
        return this.audit;
    }

    private static FilesetDTO internalBuilder(String name, String comment, Fileset.Type type, String storageLocation, Map<String, String> properties, AuditDTO audit) {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "name cannot be null or empty");
        Preconditions.checkNotNull(type, "type cannot be null");
        Preconditions.checkNotNull(audit, "audit cannot be null");
        return new FilesetDTO(name, comment, type, storageLocation, properties, audit);
    }

    public static FilesetDTOBuilder builder() {
        return new FilesetDTOBuilder();
    }

    private FilesetDTO() {
    }

    private FilesetDTO(String name, String comment, Fileset.Type type, String storageLocation, Map<String, String> properties, AuditDTO audit) {
        this.name = name;
        this.comment = comment;
        this.type = type;
        this.storageLocation = storageLocation;
        this.properties = properties;
        this.audit = audit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesetDTO)) {
            return false;
        }
        FilesetDTO other = (FilesetDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Fileset.Type this$type = this.type;
        Fileset.Type other$type = other.type;
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$storageLocation = this.storageLocation;
        String other$storageLocation = other.storageLocation;
        if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        AuditDTO this$audit = this.audit;
        AuditDTO other$audit = other.audit;
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilesetDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Fileset.Type $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $storageLocation = this.storageLocation;
        result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        AuditDTO $audit = this.audit;
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public static class FilesetDTOBuilder {
        private String name;
        private String comment;
        private Fileset.Type type;
        private String storageLocation;
        private Map<String, String> properties;
        private AuditDTO audit;

        FilesetDTOBuilder() {
        }

        public FilesetDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FilesetDTOBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public FilesetDTOBuilder type(Fileset.Type type) {
            this.type = type;
            return this;
        }

        public FilesetDTOBuilder storageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public FilesetDTOBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public FilesetDTOBuilder audit(AuditDTO audit) {
            this.audit = audit;
            return this;
        }

        public FilesetDTO build() {
            return FilesetDTO.internalBuilder(this.name, this.comment, this.type, this.storageLocation, this.properties, this.audit);
        }

        public String toString() {
            return "FilesetDTO.FilesetDTOBuilder(name=" + this.name + ", comment=" + this.comment + ", type=" + (Object)((Object)this.type) + ", storageLocation=" + this.storageLocation + ", properties=" + this.properties + ", audit=" + this.audit + ")";
        }
    }
}

