/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.TaskState;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.internal.compute.ComputeUtils;
import org.apache.ignite3.internal.compute.HybridTimestampProvider;
import org.apache.ignite3.internal.compute.MarshallerProvider;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

class TaskExecutionWrapper<R>
implements TaskExecution<R>,
MarshallerProvider<R>,
HybridTimestampProvider {
    private final TaskExecution<R> delegate;

    TaskExecutionWrapper(TaskExecution<R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.statesAsync());
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return ComputeUtils.convertToComputeFuture(this.delegate.resultAsync());
    }

    @Override
    public CompletableFuture<@Nullable TaskState> stateAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.stateAsync());
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.changePriorityAsync(newPriority));
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        if (this.delegate instanceof MarshallerProvider) {
            return ((MarshallerProvider)((Object)this.delegate)).resultMarshaller();
        }
        return null;
    }

    @Override
    public boolean marshalResult() {
        return this.delegate instanceof MarshallerProvider && ((MarshallerProvider)((Object)this.delegate)).marshalResult();
    }

    @Override
    public long hybridTimestamp() {
        return ((HybridTimestampProvider)((Object)this.delegate)).hybridTimestamp();
    }
}

