/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.KeyFunctions;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Preconditions;

@Deprecated
@Public
public class PartitionOperator<T>
extends SingleInputOperator<T, T, PartitionOperator<T>> {
    private final Keys<T> pKeys;
    private final PartitionOperatorBase.PartitionMethod pMethod;
    private final String partitionLocationName;
    private final Partitioner<?> customPartitioner;
    private final DataDistribution distribution;
    private Order[] orders;

    public PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, Keys<T> pKeys, String partitionLocationName) {
        this(input, pMethod, pKeys, null, null, null, partitionLocationName);
    }

    public PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, Keys<T> pKeys, DataDistribution distribution, String partitionLocationName) {
        this(input, pMethod, pKeys, null, null, distribution, partitionLocationName);
    }

    public PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, String partitionLocationName) {
        this(input, pMethod, null, null, null, null, partitionLocationName);
    }

    public PartitionOperator(DataSet<T> input, Keys<T> pKeys, Partitioner<?> customPartitioner, String partitionLocationName) {
        this(input, PartitionOperatorBase.PartitionMethod.CUSTOM, pKeys, customPartitioner, null, null, partitionLocationName);
    }

    public <P> PartitionOperator(DataSet<T> input, Keys<T> pKeys, Partitioner<P> customPartitioner, TypeInformation<P> partitionerTypeInfo, String partitionLocationName) {
        this(input, PartitionOperatorBase.PartitionMethod.CUSTOM, pKeys, customPartitioner, partitionerTypeInfo, null, partitionLocationName);
    }

    private <P> PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, Keys<T> pKeys, Partitioner<P> customPartitioner, TypeInformation<P> partitionerTypeInfo, DataDistribution distribution, String partitionLocationName) {
        super(input, input.getType());
        Preconditions.checkNotNull((Object)pMethod);
        Preconditions.checkArgument((pKeys != null || pMethod == PartitionOperatorBase.PartitionMethod.REBALANCE ? 1 : 0) != 0, (Object)"Partitioning requires keys");
        Preconditions.checkArgument((pMethod != PartitionOperatorBase.PartitionMethod.CUSTOM || customPartitioner != null ? 1 : 0) != 0, (Object)"Custom partitioning requires a partitioner.");
        Preconditions.checkArgument((distribution == null || pMethod == PartitionOperatorBase.PartitionMethod.RANGE ? 1 : 0) != 0, (Object)"Customized data distribution is only necessary for range partition.");
        if (distribution != null) {
            Preconditions.checkArgument((pKeys.getNumberOfKeyFields() <= distribution.getNumberOfFields() ? 1 : 0) != 0, (Object)"The distribution must provide at least as many fields as flat key fields are specified.");
            Preconditions.checkArgument((boolean)Arrays.equals(pKeys.getKeyFieldTypes(), Arrays.copyOfRange(distribution.getKeyTypes(), 0, pKeys.getNumberOfKeyFields())), (Object)"The types of the flat key fields must be equal to the types of the fields of the distribution.");
        }
        if (customPartitioner != null) {
            pKeys.validateCustomPartitioner(customPartitioner, partitionerTypeInfo);
        }
        this.pMethod = pMethod;
        this.pKeys = pKeys;
        this.partitionLocationName = partitionLocationName;
        this.customPartitioner = customPartitioner;
        this.distribution = distribution;
    }

    @PublicEvolving
    public PartitionOperator<T> withOrders(Order ... orders) {
        Preconditions.checkState((this.pMethod == PartitionOperatorBase.PartitionMethod.RANGE ? 1 : 0) != 0, (String)"Orders cannot be applied for %s partition method", (Object[])new Object[]{this.pMethod});
        Preconditions.checkArgument((this.pKeys.getOriginalKeyFieldTypes().length == orders.length ? 1 : 0) != 0, (Object)"The number of key fields and orders should be the same.");
        this.orders = orders;
        return this;
    }

    @Internal
    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    protected org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateToDataFlow(Operator<T> input) {
        String name = "Partition at " + this.partitionLocationName;
        if (this.pMethod == PartitionOperatorBase.PartitionMethod.REBALANCE) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
            PartitionOperatorBase rebalancedInput = new PartitionOperatorBase(operatorInfo, this.pMethod, name);
            rebalancedInput.setInput(input);
            rebalancedInput.setParallelism(this.getParallelism());
            return rebalancedInput;
        }
        if (this.pMethod == PartitionOperatorBase.PartitionMethod.HASH || this.pMethod == PartitionOperatorBase.PartitionMethod.CUSTOM || this.pMethod == PartitionOperatorBase.PartitionMethod.RANGE) {
            if (this.pKeys instanceof Keys.ExpressionKeys) {
                int[] logicalKeyPositions = this.pKeys.computeLogicalKeyPositions();
                UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
                PartitionOperatorBase partitionedInput = new PartitionOperatorBase(operatorInfo, this.pMethod, logicalKeyPositions, name);
                partitionedInput.setInput(input);
                partitionedInput.setParallelism(this.getParallelism());
                partitionedInput.setDistribution(this.distribution);
                partitionedInput.setCustomPartitioner(this.customPartitioner);
                partitionedInput.setOrdering(PartitionOperator.computeOrdering(this.pKeys, this.orders));
                return partitionedInput;
            }
            if (this.pKeys instanceof Keys.SelectorFunctionKeys) {
                Keys.SelectorFunctionKeys selectorKeys = (Keys.SelectorFunctionKeys)this.pKeys;
                return PartitionOperator.translateSelectorFunctionPartitioner(selectorKeys, this.pMethod, name, input, this.getParallelism(), this.customPartitioner, this.orders);
            }
            throw new UnsupportedOperationException("Unrecognized key type.");
        }
        throw new UnsupportedOperationException("Unsupported partitioning method: " + this.pMethod.name());
    }

    private static <T> Ordering computeOrdering(Keys<T> pKeys, Order[] orders) {
        Ordering ordering = new Ordering();
        int[] logicalKeyPositions = pKeys.computeLogicalKeyPositions();
        if (orders == null) {
            for (int key : logicalKeyPositions) {
                ordering.appendOrdering(Integer.valueOf(key), null, Order.ASCENDING);
            }
        } else {
            TypeInformation[] originalKeyFieldTypes = pKeys.getOriginalKeyFieldTypes();
            int index = 0;
            for (int i = 0; i < originalKeyFieldTypes.length; ++i) {
                int typeTotalFields = originalKeyFieldTypes[i].getTotalFields();
                for (int j = index; j < index + typeTotalFields; ++j) {
                    ordering.appendOrdering(Integer.valueOf(logicalKeyPositions[j]), null, orders[i]);
                }
                index += typeTotalFields;
            }
        }
        return ordering;
    }

    private static <T, K> org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateSelectorFunctionPartitioner(Keys.SelectorFunctionKeys<T, ?> rawKeys, PartitionOperatorBase.PartitionMethod pMethod, String name, Operator<T> input, int partitionDop, Partitioner<?> customPartitioner, Order[] orders) {
        Keys.SelectorFunctionKeys<T, ?> keys = rawKeys;
        TypeInformation<Tuple2<?, T>> typeInfoWithKey = KeyFunctions.createTypeWithKey(keys);
        Operator<Tuple2<?, T>> keyedInput = KeyFunctions.appendKeyExtractor(input, keys);
        PartitionOperatorBase keyedPartitionedInput = new PartitionOperatorBase(new UnaryOperatorInformation(typeInfoWithKey, typeInfoWithKey), pMethod, new int[]{0}, name);
        keyedPartitionedInput.setInput(keyedInput);
        keyedPartitionedInput.setCustomPartitioner(customPartitioner);
        keyedPartitionedInput.setParallelism(partitionDop);
        keyedPartitionedInput.setOrdering(new Ordering(0, null, orders != null ? orders[0] : Order.ASCENDING));
        return KeyFunctions.appendKeyRemover(keyedPartitionedInput, keys);
    }
}

