/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.shared;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.neo4j.shared.NeoConnection;

@SearchableAnalyserPlugin(id="NeoConnectionSearchableAnalyser", name="Search in Neo4j Connection metadata")
public class NeoConnectionSearchableAnalyser
extends BaseMetadataSearchableAnalyser<NeoConnection>
implements ISearchableAnalyser<NeoConnection> {
    public Class<NeoConnection> getSearchableClass() {
        return NeoConnection.class;
    }

    public List<ISearchResult> search(ISearchable<NeoConnection> searchable, ISearchQuery searchQuery) {
        NeoConnection neoConnection = (NeoConnection)((Object)searchable.getSearchableObject());
        String component = this.getMetadataComponent();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "Name", neoConnection.getName(), component);
        this.matchProperty(searchable, results, searchQuery, "Server", neoConnection.getServer(), component);
        this.matchProperty(searchable, results, searchQuery, "Bolt port", neoConnection.getBoltPort(), component);
        this.matchProperty(searchable, results, searchQuery, "Username", neoConnection.getUsername(), component);
        this.matchProperty(searchable, results, searchQuery, "Database name", neoConnection.getDatabaseName(), component);
        return results;
    }
}

