/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;

public class GraphNodeData {
    protected String id;
    protected List<String> labels;
    protected List<GraphPropertyData> properties;
    protected String propertySetId;

    public GraphNodeData() {
        this.labels = new ArrayList<String>();
        this.properties = new ArrayList<GraphPropertyData>();
    }

    public GraphNodeData(String id) {
        this();
        this.id = id;
    }

    public GraphNodeData(String id, List<String> labels, List<GraphPropertyData> properties) {
        this.id = id;
        this.labels = labels;
        this.properties = properties;
    }

    public GraphNodeData(Node node) {
        this();
        this.id = Long.toString(node.id());
        StringBuilder propertySet = new StringBuilder();
        for (String label : node.labels()) {
            this.labels.add(label);
            if (propertySet.length() > 0) {
                propertySet.append(",");
            }
            propertySet.append(label);
        }
        for (String propertyKey : node.keys()) {
            Value propertyValue = node.get(propertyKey);
            Object propertyObject = propertyValue.asObject();
            GraphPropertyDataType propertyType = GraphPropertyDataType.getTypeFromNeo4jValue(propertyObject);
            this.properties.add(new GraphPropertyData(propertyKey, propertyObject, propertyType, false));
        }
        this.propertySetId = propertySet.toString();
    }

    public GraphNodeData(GraphNodeData graphNode) {
        this();
        this.setId(graphNode.getId());
        this.setLabels(new ArrayList<String>(graphNode.getLabels()));
        ArrayList<GraphPropertyData> propertiesCopy = new ArrayList<GraphPropertyData>();
        for (GraphPropertyData property : graphNode.getProperties()) {
            GraphPropertyData propertyCopy = new GraphPropertyData(property.getId(), property.getValue(), property.getType(), property.isPrimary());
            propertiesCopy.add(propertyCopy);
        }
        this.setProperties(propertiesCopy);
        this.setPropertySetId(graphNode.getPropertySetId());
    }

    public JSONObject toJson() {
        JSONObject jNode = new JSONObject();
        jNode.put((Object)"id", (Object)this.id);
        jNode.put((Object)"labels", this.labels);
        JSONArray jProperties = new JSONArray();
        jNode.put((Object)"properties", (Object)jProperties);
        for (GraphPropertyData property : this.properties) {
            jProperties.add(property.toJson());
        }
        jNode.put((Object)"property_set", (Object)this.propertySetId);
        return jNode;
    }

    public GraphNodeData(JSONObject jNode) {
        this.id = (String)jNode.get((Object)"id");
        JSONArray jLabels = (JSONArray)jNode.get((Object)"labels");
        for (int i = 0; i < jLabels.size(); ++i) {
            this.labels.add((String)jLabels.get(i));
        }
        JSONArray jProperties = (JSONArray)jNode.get((Object)"properties");
        for (int i = 0; i < jProperties.size(); ++i) {
            this.properties.add(new GraphPropertyData((JSONObject)jProperties.get(i)));
        }
        this.propertySetId = (String)jNode.get((Object)"property_set");
    }

    public GraphNodeData clone() {
        return new GraphNodeData(this);
    }

    public String toString() {
        return this.id == null ? super.toString() : this.id;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof GraphNodeData)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return ((GraphNodeData)o).getId().equals(this.id);
    }

    public GraphPropertyData findProperty(String id) {
        for (GraphPropertyData property : this.properties) {
            if (!property.getId().equalsIgnoreCase(id)) continue;
            return property;
        }
        return null;
    }

    public String getName() {
        GraphPropertyData nameProperty = this.findProperty("name");
        if (nameProperty == null || nameProperty.getValue() == null) {
            return this.id;
        }
        return nameProperty.getValue().toString();
    }

    public String getNodeText() {
        String nodeText = this.getName() + Const.CR;
        GraphPropertyData typeProperty = this.findProperty("type");
        if (typeProperty != null && typeProperty.getValue() != null) {
            nodeText = nodeText + typeProperty.getValue().toString();
        }
        if (!this.labels.isEmpty()) {
            nodeText = nodeText + " (:" + this.labels.get(0) + ")";
        }
        return nodeText;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public List<GraphPropertyData> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GraphPropertyData> properties) {
        this.properties = properties;
    }

    public String getPropertySetId() {
        return this.propertySetId;
    }

    public void setPropertySetId(String propertySetId) {
        this.propertySetId = propertySetId;
    }
}

