/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.model.mistralai.DefaultMistralAiHelper;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MistralAiRequestLoggingInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MistralAiRequestLoggingInterceptor.class);

    MistralAiRequestLoggingInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.log(request);
        return chain.proceed(request);
    }

    private void log(Request request) {
        try {
            LOGGER.debug("Request:\n- method: {}\n- url: {}\n- headers: {}\n- body: {}", new Object[]{request.method(), request.url(), DefaultMistralAiHelper.getHeaders(request.headers()), MistralAiRequestLoggingInterceptor.getBody(request)});
        }
        catch (Exception e) {
            LOGGER.warn("Error while logging request: {}", (Object)e.getMessage());
        }
    }

    private static String getBody(Request request) {
        try {
            Buffer buffer = new Buffer();
            if (request.body() == null) {
                return "";
            }
            request.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (Exception e) {
            LOGGER.warn("Exception while getting body", (Throwable)e);
            return "Exception while getting body: " + e.getMessage();
        }
    }
}

