/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import org.monetdb.mcl.net.ParameterType;

public enum Parameter {
    TLS("tls", ParameterType.Bool, false, "secure the connection using TLS", true, true),
    HOST("host", ParameterType.Str, "", "IP number, domain name or one of the special values `localhost` and `localhost.`", true),
    PORT("port", ParameterType.Int, -1, "Port to connect to, 1..65535 or -1 for 'not set'", true),
    DATABASE("database", ParameterType.Str, "", "name of database to connect to", true),
    TABLESCHEMA("tableschema", ParameterType.Str, "", "only used for REMOTE TABLE, otherwise unused", true),
    TABLE("table", ParameterType.Str, "", "only used for REMOTE TABLE, otherwise unused", true),
    SOCK("sock", ParameterType.Path, "", "path to Unix domain socket to connect to", false),
    SOCKDIR("sockdir", ParameterType.Path, "/tmp", "Directory for implicit Unix domain sockets (.s.monetdb.PORT)", false),
    CERT("cert", ParameterType.Path, "", "path to TLS certificate to authenticate server with", false, true),
    CERTHASH("certhash", ParameterType.Str, "", "hash of server TLS certificate must start with these hex digits; overrides cert", false, true),
    CLIENTKEY("clientkey", ParameterType.Path, "", "path to TLS key (+certs) to authenticate with as client", false, true),
    CLIENTCERT("clientcert", ParameterType.Path, "", "path to TLS certs for 'clientkey', if not included there", false, true),
    USER("user", ParameterType.Str, "", "user name to authenticate as", false),
    PASSWORD("password", ParameterType.Str, "", "password to authenticate with", false),
    LANGUAGE("language", ParameterType.Str, "sql", "for example, \"sql\", \"mal\", \"msql\", \"profiler\"", false),
    AUTOCOMMIT("autocommit", ParameterType.Bool, true, "initial value of autocommit", false),
    SCHEMA("schema", ParameterType.Str, "", "initial schema", false),
    TIMEZONE("timezone", ParameterType.Int, null, "client time zone as minutes east of UTC", false),
    BINARY("binary", ParameterType.Str, "on", "whether to use binary result set format (number or bool)", false),
    REPLYSIZE("replysize", ParameterType.Int, 250, "rows beyond this limit are retrieved on demand, <1 means unlimited", false),
    FETCHSIZE("fetchsize", ParameterType.Int, null, "alias for replysize, specific to jdbc", false),
    HASH("hash", ParameterType.Str, "", "specific to jdbc", false),
    DEBUG("debug", ParameterType.Bool, false, "enable tracing of socket communication for debugging", false),
    LOGFILE("logfile", ParameterType.Str, "", "when debug is enabled its output will be written to this logfile", false),
    SO_TIMEOUT("so_timeout", ParameterType.Int, 0, "abort if network I/O does not complete in this many milliseconds, 0 means no timeout", false),
    CLOB_AS_VARCHAR("treat_clob_as_varchar", ParameterType.Bool, true, "map CLOB/TEXT data to type VARCHAR instead of type CLOB", false),
    BLOB_AS_BINARY("treat_blob_as_binary", ParameterType.Bool, true, "map BLOB data to type BINARY instead of type BLOB", false),
    CLIENT_INFO("client_info", ParameterType.Bool, true, "whether to send ClientInfo when connecting", false),
    CLIENT_APPLICATION("client_application", ParameterType.Str, "", "application name to send in ClientInfo", false),
    CLIENT_REMARK("client_remark", ParameterType.Str, "", "any client remark to send in ClientInfo", false);

    public final String name;
    public final ParameterType type;
    private final Object defaultValue;
    public final String description;
    public final boolean isCore;
    public final boolean isTlsRelated;

    private Parameter(String string2, ParameterType parameterType, Object object, String string3, boolean bl, boolean bl2) {
        this.name = string2;
        this.type = parameterType;
        this.defaultValue = object;
        this.description = string3;
        this.isCore = bl;
        this.isTlsRelated = bl2;
    }

    private Parameter(String string2, ParameterType parameterType, Object object, String string3, boolean bl) {
        this(string2, parameterType, object, string3, bl, false);
    }

    public static Parameter forName(String string) {
        switch (string) {
            case "tls": {
                return TLS;
            }
            case "host": {
                return HOST;
            }
            case "port": {
                return PORT;
            }
            case "database": {
                return DATABASE;
            }
            case "tableschema": {
                return TABLESCHEMA;
            }
            case "table": {
                return TABLE;
            }
            case "sock": {
                return SOCK;
            }
            case "sockdir": {
                return SOCKDIR;
            }
            case "cert": {
                return CERT;
            }
            case "certhash": {
                return CERTHASH;
            }
            case "clientkey": {
                return CLIENTKEY;
            }
            case "clientcert": {
                return CLIENTCERT;
            }
            case "user": {
                return USER;
            }
            case "password": {
                return PASSWORD;
            }
            case "language": {
                return LANGUAGE;
            }
            case "autocommit": {
                return AUTOCOMMIT;
            }
            case "schema": {
                return SCHEMA;
            }
            case "timezone": {
                return TIMEZONE;
            }
            case "binary": {
                return BINARY;
            }
            case "replysize": {
                return REPLYSIZE;
            }
            case "fetchsize": {
                return FETCHSIZE;
            }
            case "hash": {
                return HASH;
            }
            case "debug": {
                return DEBUG;
            }
            case "logfile": {
                return LOGFILE;
            }
            case "so_timeout": {
                return SO_TIMEOUT;
            }
            case "treat_clob_as_varchar": {
                return CLOB_AS_VARCHAR;
            }
            case "treat_blob_as_binary": {
                return BLOB_AS_BINARY;
            }
            case "client_info": {
                return CLIENT_INFO;
            }
            case "client_application": {
                return CLIENT_APPLICATION;
            }
            case "client_remark": {
                return CLIENT_REMARK;
            }
        }
        return null;
    }

    public static boolean isIgnored(String string) {
        if (Parameter.forName(string) != null) {
            return false;
        }
        return string.contains("_");
    }

    public Object getDefault() {
        switch (this.ordinal()) {
            case 17: {
                Calendar calendar = Calendar.getInstance();
                int n = calendar.get(15) + calendar.get(16);
                int n2 = n / 60000;
                return n2;
            }
        }
        return this.defaultValue;
    }

    public boolean isTlsOnly() {
        switch (this.ordinal()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static DriverPropertyInfo[] getPropertyInfo(Properties properties, boolean bl) {
        String[] stringArray = new String[]{"true", "false"};
        ArrayList<Object> arrayList = new ArrayList<Object>(Parameter.values().length);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(Parameter.values().length);
        block5: for (Parameter parameter : Parameter.values()) {
            if (!bl && parameter.isTlsRelated) continue;
            switch (parameter.ordinal()) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 18: {
                    continue block5;
                }
                case 20: {
                    continue block5;
                }
                case 14: 
                case 21: {
                    continue block5;
                }
                default: {
                    Object object;
                    String string;
                    if (parameter == FETCHSIZE) continue block5;
                    String string2 = string = properties == null ? null : properties.getProperty(parameter.name);
                    if (string == null && (object = parameter.getDefault()) != null) {
                        string = object.toString();
                    }
                    object = new DriverPropertyInfo(parameter.name, string);
                    ((DriverPropertyInfo)object).description = parameter.description;
                    if (parameter.type == ParameterType.Bool) {
                        ((DriverPropertyInfo)object).choices = stringArray;
                    }
                    boolean bl2 = ((DriverPropertyInfo)object).required = parameter == USER || parameter == PASSWORD;
                    if (((DriverPropertyInfo)object).required) {
                        arrayList.add(object);
                        continue block5;
                    }
                    arrayList2.add(object);
                }
            }
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[arrayList.size() + arrayList2.size()];
        int n = 0;
        for (DriverPropertyInfo driverPropertyInfo : arrayList) {
            driverPropertyInfoArray[n++] = driverPropertyInfo;
        }
        for (DriverPropertyInfo driverPropertyInfo : arrayList2) {
            driverPropertyInfoArray[n++] = driverPropertyInfo;
        }
        return driverPropertyInfoArray;
    }
}

