/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMeta;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMetaFunction;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CalculatorDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = CalculatorMeta.class;
    public static final String CONST_SYSTEM_COMBO_YES = "System.Combo.Yes";
    private Text wTransformName;
    private Button wFailIfNoFile;
    private TableView wFields;
    private final CalculatorMeta currentMeta;
    private final CalculatorMeta originalMeta;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] colinf;

    public CalculatorDialog(Shell parent, IVariables variables, CalculatorMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.currentMeta = transformMeta;
        this.originalMeta = transformMeta.clone();
    }

    public String open() {
        int formMargin;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.currentMeta);
        ModifyListener lsMod = e -> this.currentMeta.setChanged();
        this.changed = this.currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = formMargin = 15;
        formLayout.marginHeight = formMargin;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CalculatorDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        int fdMargin = 15;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        CalculatorDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)fdMargin, null);
        Label wIcon = new Label((Composite)this.shell, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlIcon = new FormData();
        fdlIcon.top = new FormAttachment(0, 0);
        fdlIcon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlIcon);
        PropsUi.setLook((Widget)wIcon);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.bottom = new FormAttachment((Control)wIcon, 0, 0x1000000);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment((Control)wlTransformName, margin);
        fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        fdTransformName.right = new FormAttachment((Control)wIcon, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(0, 0);
        fdSeparator.top = new FormAttachment((Control)wIcon, 0);
        fdSeparator.right = new FormAttachment(100, 0);
        separator.setLayoutData((Object)fdSeparator);
        this.wFailIfNoFile = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wFailIfNoFile);
        this.wFailIfNoFile.setToolTipText(BaseMessages.getString(PKG, (String)"CalculatorDialog.FailIfNoFileTooltip", (String[])new String[0]));
        this.wFailIfNoFile.setText(BaseMessages.getString(PKG, (String)"CalculatorDialog.FailIfNoFile", (String[])new String[0]));
        FormData fdFailIfNoFile = new FormData();
        fdFailIfNoFile.left = new FormAttachment((Control)wlTransformName, margin);
        fdFailIfNoFile.top = new FormAttachment((Control)separator, fdMargin);
        fdFailIfNoFile.right = new FormAttachment(100);
        this.wFailIfNoFile.setLayoutData((Object)fdFailIfNoFile);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"CalculatorDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wFailIfNoFile, fdMargin);
        wlFields.setLayoutData((Object)fdlFields);
        int nrFieldsRows = this.currentMeta.getFunctions().size();
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.NewFieldColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.CalculationColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.FieldAColumn.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.FieldBColumn.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.FieldCColumn.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.ValueTypeColumn.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.LengthColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.RemoveColumn.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.ConversionMask.Column", (String[])new String[0]), 5, 6), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.DecimalSymbol.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.GroupingSymbol.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.CurrencySymbol.Column", (String[])new String[0]), 1, false)};
        this.colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog esd = new EnterSelectionDialog(CalculatorDialog.this.shell, CalculatorMetaFunction.CalculationType.getDescriptions(), BaseMessages.getString(PKG, (String)"CalculatorDialog.SelectCalculationType.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CalculatorDialog.SelectCalculationType.Message", (String[])new String[0]));
                String string = esd.open();
                if (string != null) {
                    TableView tv = (TableView)e.widget;
                    tv.setText(string, e.x, e.y);
                    CalculatorDialog.this.currentMeta.setChanged();
                }
            }
        });
        Label hSeparator = new Label((Composite)this.shell, 258);
        FormData fdhSeparator = new FormData();
        fdhSeparator.left = new FormAttachment(0, 0);
        fdhSeparator.right = new FormAttachment(100, 0);
        fdhSeparator.bottom = new FormAttachment((Control)this.wOk, -fdMargin);
        hSeparator.setLayoutData((Object)fdhSeparator);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, nrFieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)hSeparator, -fdMargin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"CalculatorDialog.Log.UnableToFindInput", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wFields.addModifyListener(arg0 -> this.shell.getDisplay().asyncExec(this::setComboBoxes));
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        ArrayList<String> fields = new ArrayList<String>();
        for (String s : this.inputFields) {
            fields.add(s);
        }
        this.shell.getDisplay().syncExec(() -> {
            int nrNonEmptyFields = this.wFields.nrNonEmpty();
            for (int i = 0; i < nrNonEmptyFields; ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                fields.add(item.getText(1));
            }
        });
        String[] fieldNames = ConstUi.sortFieldNames(fields);
        this.colinf[2].setComboValues(fieldNames);
        this.colinf[3].setComboValues(fieldNames);
        this.colinf[4].setComboValues(fieldNames);
    }

    public void getData() {
        for (int i = 0; i < this.currentMeta.getFunctions().size(); ++i) {
            CalculatorMetaFunction fn = this.currentMeta.getFunctions().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)fn.getFieldName(), (String)""));
            item.setText(2, Const.NVL((String)fn.getCalcType().getDescription(), (String)""));
            item.setText(3, Const.NVL((String)fn.getFieldA(), (String)""));
            item.setText(4, Const.NVL((String)fn.getFieldB(), (String)""));
            item.setText(5, Const.NVL((String)fn.getFieldC(), (String)""));
            item.setText(6, Const.NVL((String)fn.getValueType(), (String)""));
            if (fn.getValueLength() >= 0) {
                item.setText(7, "" + fn.getValueLength());
            }
            if (fn.getValuePrecision() >= 0) {
                item.setText(8, "" + fn.getValuePrecision());
            }
            item.setText(9, fn.isRemovedFromResult() ? BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            item.setText(10, Const.NVL((String)fn.getConversionMask(), (String)""));
            item.setText(11, Const.NVL((String)fn.getDecimalSymbol(), (String)""));
            item.setText(12, Const.NVL((String)fn.getGroupingSymbol(), (String)""));
            item.setText(13, Const.NVL((String)fn.getCurrencySymbol(), (String)""));
        }
        this.wFailIfNoFile.setSelection(this.currentMeta.isFailIfNoFile());
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.currentMeta.setFailIfNoFile(this.wFailIfNoFile.getSelection());
        this.currentMeta.getFunctions().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            String fieldName = item.getText(1);
            CalculatorMetaFunction.CalculationType calcType = CalculatorMetaFunction.CalculationType.getTypeWithDescription(item.getText(2));
            String fieldA = item.getText(3);
            String fieldB = item.getText(4);
            String fieldC = item.getText(5);
            String valueType = item.getText(6);
            int valueLength = Const.toInt((String)item.getText(7), (int)-1);
            int valuePrecision = Const.toInt((String)item.getText(8), (int)-1);
            boolean removed = BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(item.getText(9));
            String conversionMask = item.getText(10);
            String decimalSymbol = item.getText(11);
            String groupingSymbol = item.getText(12);
            String currencySymbol = item.getText(13);
            this.currentMeta.getFunctions().add(new CalculatorMetaFunction(fieldName, calcType, fieldA, fieldB, fieldC, valueType, valueLength, valuePrecision, conversionMask, decimalSymbol, groupingSymbol, currencySymbol, removed));
        }
        if (!((Object)((Object)this.originalMeta)).equals((Object)this.currentMeta)) {
            this.currentMeta.setChanged();
            this.changed = this.currentMeta.hasChanged();
        }
        this.dispose();
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"calculator.svg", (int)48, (int)48);
    }
}

