/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras;

import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;

@Immutable
public class OptionalCodec<T>
extends MappingCodec<T, Optional<T>> {
    public OptionalCodec(@NonNull TypeCodec<T> innerCodec) {
        super(Objects.requireNonNull(innerCodec, "innerCodec must not be null"), GenericType.optionalOf(innerCodec.getJavaType()));
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            return optional.map(this.innerCodec::accepts).orElse(true);
        }
        return false;
    }

    @Override
    @Nullable
    protected Optional<T> innerToOuter(@Nullable T value) {
        return Optional.ofNullable(this.isAbsent(value) ? null : (Object)value);
    }

    @Override
    @Nullable
    protected T outerToInner(@Nullable Optional<T> value) {
        return value != null && value.isPresent() ? (T)value.get() : null;
    }

    protected boolean isAbsent(@Nullable T value) {
        return value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof Map && ((Map)value).isEmpty();
    }
}

