/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DateCodec
implements TypeCodec<LocalDate> {
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    private static final long MAX_CQL_LONG_VALUE = 0xFFFFFFFFL;
    private static final long EPOCH_AS_CQL_LONG = 0x80000000L;

    @Override
    @NonNull
    public GenericType<LocalDate> getJavaType() {
        return GenericType.LOCAL_DATE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.DATE;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof LocalDate;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == LocalDate.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable LocalDate value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        long days = ChronoUnit.DAYS.between(EPOCH, value);
        int unsigned = DateCodec.signedToUnsigned((int)days);
        return TypeCodecs.INT.encodePrimitive(unsigned, protocolVersion);
    }

    @Override
    @Nullable
    public LocalDate decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        int unsigned = TypeCodecs.INT.decodePrimitive(bytes, protocolVersion);
        int signed = DateCodec.unsignedToSigned(unsigned);
        return EPOCH.plusDays(signed);
    }

    @Override
    @NonNull
    public String format(@Nullable LocalDate value) {
        return value == null ? "NULL" : Strings.quote(DateTimeFormatter.ISO_LOCAL_DATE.format(value));
    }

    @Override
    @Nullable
    public LocalDate parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (Strings.isQuoted(value)) {
            value = Strings.unquote(value);
        }
        if (Strings.isLongLiteral(value)) {
            int days;
            long raw;
            try {
                raw = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Cannot parse date value from \"%s\"", value));
            }
            try {
                days = DateCodec.cqlDateToDaysSinceEpoch(raw);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse date value from \"%s\"", value));
            }
            return EPOCH.plusDays(days);
        }
        try {
            return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Cannot parse date value from \"%s\"", value));
        }
    }

    private static int signedToUnsigned(int signed) {
        return signed - Integer.MIN_VALUE;
    }

    private static int unsignedToSigned(int unsigned) {
        return unsigned + Integer.MIN_VALUE;
    }

    private static int cqlDateToDaysSinceEpoch(long raw) {
        if (raw < 0L || raw > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("Numeric literals for DATE must be between 0 and %d (got %d)", 0xFFFFFFFFL, raw));
        }
        return (int)(raw - 0x80000000L);
    }
}

