/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultListType
implements ListType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DataType elementType;
    private final boolean frozen;

    public DefaultListType(@NonNull DataType elementType, boolean frozen) {
        Preconditions.checkNotNull((Object)elementType);
        this.elementType = elementType;
        this.frozen = frozen;
    }

    @Override
    @NonNull
    public DataType getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public boolean isDetached() {
        return this.elementType.isDetached();
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        this.elementType.attach(attachmentPoint);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ListType) {
            ListType that = (ListType)other;
            return this.elementType.equals(that.getElementType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(DefaultListType.class, this.elementType);
    }

    public String toString() {
        return "List(" + this.elementType + ", " + (this.frozen ? "" : "not ") + "frozen)";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Preconditions.checkNotNull((Object)this.elementType);
    }
}

